/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.persistence.NameSpace;
import oracle.jdeveloper.usage.lib.BrowseStack;
import oracle.jdeveloper.usage.lib.IPStack;
import oracle.jdeveloper.usage.lib.Librarian;
import oracle.jdeveloper.usage.lib.ReservedStack;

public final class IPLibrarian
extends Librarian {
    private static IPLibrarian _librarian = null;
    private Map _openStackMap;

    public static synchronized Librarian getLibrarian() {
        if (_librarian == null) {
            _librarian = new IPLibrarian();
        }
        return _librarian;
    }

    private IPLibrarian() {
        this.$init$();
    }

    void $init$() {
        this._openStackMap = new HashMap();
    }

    private boolean _namespaceExists(String string) {
        Iterator iterator = NameSpace.getNameSpaceIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected NameSpace getNameSpace(String string, int n) {
        int n2 = this.useSmallRecords(n) ? 1 : 0;
        NameSpace nameSpace = NameSpace.getNameSpace((String)string, (int)n2);
        return nameSpace;
    }

    public boolean createStack(String string, int n) {
        if (this._namespaceExists(string)) {
            return false;
        }
        NameSpace nameSpace = this.getNameSpace(string, n);
        return true;
    }

    public boolean destroyStack(String string) {
        if (!this._namespaceExists(string)) {
            return false;
        }
        NameSpace.deleteNameSpace((String)string);
        return true;
    }

    protected IPStack lookupStack(String string, int n) {
        if (this._namespaceExists(string)) {
            NameSpace nameSpace = this.getNameSpace(string, n);
            return new IPStack(nameSpace);
        }
        return null;
    }

    public BrowseStack browseStack(String string, int n) {
        IPStack iPStack = this.lookupStack(string, n);
        if (iPStack != null) {
            return iPStack.acquireBrowseStack();
        }
        return null;
    }

    public ReservedStack reserveStack(String string, int n) {
        IPStack iPStack = this.lookupStack(string, n);
        if (iPStack != null) {
            return iPStack.acquireReservedStack();
        }
        return null;
    }

    public void releaseStack(BrowseStack browseStack) {
        if (browseStack != null) {
            browseStack.releaseStack();
        }
    }
}

