/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.lib;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.persistence.NameSpace;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.jdeveloper.usage.lib.BrowseStack;
import oracle.jdeveloper.usage.lib.ReservedStack;

final class IPStack {
    private NameSpace _namespace;
    private static final String INFO_RECORD_NAME = "<<**IPSTACK_INFO**>>";
    private int _browseCount;
    private int _reservedCount;
    private boolean _dirty;
    private ReadWriteLock _lock;

    IPStack(NameSpace nameSpace) {
        this.$init$();
        this._namespace = nameSpace;
    }

    private Object _lookupBook(String string, AssemblyFactory assemblyFactory) throws AssemblyException {
        byte[] byArray = this._namespace.getRecord(string);
        if (byArray != null) {
            return assemblyFactory.assemble(byArray);
        }
        return null;
    }

    private String[] _lookupContents() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this._namespace.getKeyIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        arrayList.remove(INFO_RECORD_NAME);
        int n = arrayList.size();
        return arrayList.toArray(new String[n]);
    }

    private Object _lookupStackInfo(AssemblyFactory assemblyFactory) throws AssemblyException {
        return this._lookupBook(INFO_RECORD_NAME, assemblyFactory);
    }

    private void _removeBook(String string) {
        this._namespace.delRecord(string);
    }

    private void _removeAllBooks() {
        Iterator iterator = this._namespace.getKeyIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(INFO_RECORD_NAME)) continue;
            this._namespace.delRecord(string);
        }
    }

    private void _replaceBook(String string, Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
        if (string == null) {
            throw new IllegalArgumentException("Null names not allowed in stack");
        }
        byte[] byArray = assemblyFactory.disassemble(object);
        this._namespace.putRecord(string, byArray);
    }

    private void _replaceStackInfo(Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
        this._replaceBook(INFO_RECORD_NAME, object, assemblyFactory);
    }

    void $init$() {
        this._browseCount = 0;
        this._reservedCount = 0;
        this._dirty = false;
        this._lock = new ReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrowseStack acquireBrowseStack() {
        this._lock.readLock();
        IPStack iPStack = this;
        synchronized (iPStack) {
            ++this._browseCount;
            BrowseStackWrapper browseStackWrapper = new BrowseStackWrapper(null);
            return browseStackWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReservedStack acquireReservedStack() {
        this._lock.writeLock();
        IPStack iPStack = this;
        synchronized (iPStack) {
            ++this._reservedCount;
            ReservedStackWrapper reservedStackWrapper = new ReservedStackWrapper(null);
            return reservedStackWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBrowseStack() {
        IPStack iPStack = this;
        synchronized (iPStack) {
            --this._browseCount;
        }
        this._lock.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReservedStack(boolean bl) {
        IPStack iPStack = this;
        synchronized (iPStack) {
            --this._reservedCount;
            boolean bl2 = this._dirty = this._dirty || bl;
            if (this._dirty && this._reservedCount == 0) {
                this._namespace.flush();
                this._dirty = false;
            }
        }
        this._lock.writeUnlock();
    }

    static Object mav$_lookupStackInfo(IPStack iPStack, AssemblyFactory assemblyFactory) {
        return iPStack._lookupStackInfo(assemblyFactory);
    }

    static String[] mav$_lookupContents(IPStack iPStack) {
        return iPStack._lookupContents();
    }

    static Object mav$_lookupBook(IPStack iPStack, String string, AssemblyFactory assemblyFactory) {
        return iPStack._lookupBook(string, assemblyFactory);
    }

    static void mav$releaseBrowseStack(IPStack iPStack) {
        iPStack.releaseBrowseStack();
    }

    static void mav$_replaceStackInfo(IPStack iPStack, Object object, AssemblyFactory assemblyFactory) {
        iPStack._replaceStackInfo(object, assemblyFactory);
    }

    static void mav$_replaceBook(IPStack iPStack, String string, Object object, AssemblyFactory assemblyFactory) {
        iPStack._replaceBook(string, object, assemblyFactory);
    }

    static void mav$_removeAllBooks(IPStack iPStack) {
        iPStack._removeAllBooks();
    }

    static void mav$_removeBook(IPStack iPStack, String string) {
        iPStack._removeBook(string);
    }

    static void mav$releaseReservedStack(IPStack iPStack, boolean bl) {
        iPStack.releaseReservedStack(bl);
    }

    private class BrowseStackWrapper
    implements BrowseStack {
        protected boolean _released;

        void $init$() {
            this._released = false;
        }

        public void releaseStack() {
            this.assertNotReleased();
            IPStack.mav$releaseBrowseStack(IPStack.this);
            this._released = true;
        }

        protected void assertNotReleased() {
            if (this._released) {
                throw new IllegalStateException("Attempted access to released resource");
            }
        }

        public Object lookupBook(String string, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            return IPStack.mav$_lookupBook(IPStack.this, string, assemblyFactory);
        }

        public String[] lookupContents() {
            this.assertNotReleased();
            return IPStack.mav$_lookupContents(IPStack.this);
        }

        public Object lookupStackInfo(AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            return IPStack.mav$_lookupStackInfo(IPStack.this, assemblyFactory);
        }

        private BrowseStackWrapper() {
            this.$init$();
        }

        BrowseStackWrapper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ReservedStackWrapper
    extends BrowseStackWrapper
    implements ReservedStack {
        private boolean _modified;

        void $init$() {
            this._modified = false;
        }

        public void releaseStack() {
            this.assertNotReleased();
            IPStack.mav$releaseReservedStack(IPStack.this, this._modified);
            this._released = true;
        }

        public void removeBook(String string) {
            this.assertNotReleased();
            IPStack.mav$_removeBook(IPStack.this, string);
            this._modified = true;
        }

        public void removeAllBooks() {
            this.assertNotReleased();
            IPStack.mav$_removeAllBooks(IPStack.this);
            this._modified = true;
        }

        public void replaceBook(String string, Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            IPStack.mav$_replaceBook(IPStack.this, string, object, assemblyFactory);
            this._modified = true;
        }

        public void replaceStackInfo(Object object, AssemblyFactory assemblyFactory) throws AssemblyException {
            this.assertNotReleased();
            IPStack.mav$_replaceStackInfo(IPStack.this, object, assemblyFactory);
            this._modified = true;
        }

        private ReservedStackWrapper() {
            super(null);
            this.$init$();
        }

        ReservedStackWrapper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

