/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.util.BackgroundTask;

public abstract class AbstractBackgroundTask
extends AsyncTask
implements BackgroundTask {
    private boolean _cancelled;
    private int _progressValue;
    private String _progressText;

    public final void cancel() {
        AsyncScheduler asyncScheduler = this.getSchedulerImpl();
        if (asyncScheduler != null) {
            asyncScheduler.cancelTask((AsyncTask)this);
        }
    }

    protected abstract AsyncScheduler getSchedulerImpl();

    protected abstract Object runTaskImpl() throws AsyncTask.CancelledException;

    protected void cancelTaskImpl() {
    }

    protected final Object runImpl() throws AsyncTask.CancelledException {
        Object object = this.runTaskImpl();
        return object;
    }

    protected final void requestCancelImpl() {
        this._cancelled = true;
        this.cancelTaskImpl();
    }

    void $init$() {
        this._cancelled = false;
        this._progressValue = 0;
        this._progressText = "";
    }

    protected final boolean isCancelledImpl() {
        return this._cancelled;
    }

    protected void setProgressFromSubTask(int n, int n2, int n3) {
        int n4;
        try {
            n = Math.max(0, n);
            n = Math.min(100, n);
            int n5 = n3 - n2;
            int n6 = (int)((double)(n5 * n) / 100.0);
            n4 = n2 + n6;
        }
        catch (RuntimeException runtimeException) {
            n4 = n2;
        }
        this.setProgress(n4);
    }

    protected void setProgressFromSubTask(BackgroundTask backgroundTask, int n, int n2) {
        this.setProgressFromSubTask(backgroundTask.getProgress(), n, n2);
    }

    public final int getProgress() {
        return this._progressValue;
    }

    public final void setProgress(int n) {
        this._progressValue = n;
    }

    public final String getProgressText() {
        return this._progressText;
    }

    public final void setProgressText(String string) {
        this._progressText = string;
    }

    public AbstractBackgroundTask() {
        this.$init$();
    }
}

