/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.util.Comparator;
import java.util.Iterator;
import javax.swing.text.Segment;
import oracle.ide.util.ArraySortedSet;

public final class CharArrayPool {
    private CAP _pool;
    public static final Comparator CHAR_ARRAY_COMPARATOR = new CAPC(null);

    public CharArrayPool(int n) {
        this._pool = new CAP(n, null);
    }

    public char[] add(char[] cArray) {
        return (char[])CAP.mav$addIntern(this._pool, cArray);
    }

    public char[] add(String string) {
        return (char[])CAP.mav$addIntern(this._pool, string);
    }

    public char[] add(Segment segment) {
        return (char[])CAP.mav$addIntern(this._pool, segment);
    }

    public int size() {
        return this._pool.size();
    }

    public boolean contains(char[] cArray) {
        return this._pool.contains(cArray);
    }

    public Iterator iterator() {
        return this._pool.iterator();
    }

    public void trimToSize() {
        this._pool.trimToSize();
    }

    private static final class CAPC
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof char[]) {
                if (object2 instanceof char[]) {
                    return this.compareCharArrays((char[])object, (char[])object2);
                }
                if (object2 instanceof String) {
                    return this.compareCharArrayString((char[])object, (String)object2);
                }
                return this.compareCharArraySegment((char[])object, (Segment)object2);
            }
            if (object instanceof String) {
                return this.compareStringCharArray((String)object, (char[])object2);
            }
            return this.compareSegmentCharArray((Segment)object, (char[])object2);
        }

        private int compareSegmentCharArray(Segment segment, char[] cArray) {
            int n = segment.count;
            int n2 = cArray.length;
            int n3 = Math.min(n, n2);
            int n4 = 0;
            int n5 = segment.offset;
            char[] cArray2 = segment.array;
            while (n4 < n3) {
                char c;
                char c2;
                if ((c2 = cArray2[n5++]) == (c = cArray[n4++])) continue;
                return c2 - c;
            }
            return n - n2;
        }

        private int compareCharArraySegment(char[] cArray, Segment segment) {
            int n = cArray.length;
            int n2 = segment.count;
            int n3 = Math.min(n, n2);
            int n4 = 0;
            int n5 = segment.offset;
            char[] cArray2 = segment.array;
            while (n4 < n3) {
                char c;
                char c2;
                if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
                return c2 - c;
            }
            return n - n2;
        }

        private int compareStringCharArray(String string, char[] cArray) {
            int n = string.length();
            int n2 = cArray.length;
            int n3 = Math.min(n, n2);
            int n4 = 0;
            while (n4 < n3) {
                char c;
                char c2 = string.charAt(n4);
                if (c2 != (c = cArray[n4])) {
                    return c2 - c;
                }
                ++n4;
            }
            return n - n2;
        }

        private int compareCharArrayString(char[] cArray, String string) {
            int n = cArray.length;
            int n2 = string.length();
            int n3 = Math.min(n, n2);
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                char c2 = string.charAt(n4);
                if (c != c2) {
                    return c - c2;
                }
                ++n4;
            }
            return n - n2;
        }

        private int compareCharArrays(char[] cArray, char[] cArray2) {
            int n = cArray.length;
            int n2 = cArray2.length;
            int n3 = Math.min(n, n2);
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                char c2 = cArray2[n4];
                if (c != c2) {
                    return c - c2;
                }
                ++n4;
            }
            return n - n2;
        }

        public boolean equals(Object object) {
            return object instanceof CAPC;
        }

        private CAPC() {
        }

        CAPC(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class CAP
    extends ArraySortedSet {
        private CAP(int n) {
            super(n, CHAR_ARRAY_COMPARATOR);
        }

        private Object addIntern(char[] cArray) {
            return this.intern(cArray);
        }

        private Object addIntern(String string) {
            if (this.contains(string)) {
                return this.intern(string);
            }
            char[] cArray = string.toCharArray();
            this.add(cArray);
            return cArray;
        }

        private Object addIntern(Segment segment) {
            if (this.contains(segment)) {
                return this.intern(segment);
            }
            char[] cArray = new char[segment.count];
            System.arraycopy(segment.array, segment.offset, cArray, 0, segment.count);
            this.add(cArray);
            return cArray;
        }

        static Object mav$addIntern(CAP cAP, Segment segment) {
            return cAP.addIntern(segment);
        }

        static Object mav$addIntern(CAP cAP, String string) {
            return cAP.addIntern(string);
        }

        static Object mav$addIntern(CAP cAP, char[] cArray) {
            return cAP.addIntern(cArray);
        }

        CAP(int n, 1 var3_3) {
            this(n);
        }

        public final class 1 {
        }
    }
}

