/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v1.JavaParser;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.jdeveloper.model.JavaSourceNode;

public class NodeUtilities {
    public static RootSymbol getParseTreeFor(URL uRL, TextBuffer textBuffer, boolean bl) {
        RootSymbol rootSymbol = null;
        Node node = NodeFactory.find((URL)uRL);
        if (node != null && node instanceof JavaSourceNode && node.isOpen()) {
            JavaSourceNode javaSourceNode = (JavaSourceNode)node;
            rootSymbol = javaSourceNode.parse1(bl);
        }
        if (rootSymbol == null) {
            JavaParser.ParsingOptions parsingOptions = new JavaParser.ParsingOptions();
            parsingOptions.startOffset = 0;
            parsingOptions.inputType = 1;
            parsingOptions.parseDepth = bl ? 3 : 2;
            parsingOptions.reportErrors = true;
            rootSymbol = (RootSymbol)JavaParser.parse((ReadTextBuffer)textBuffer, (JavaParser.ParsingOptions)parsingOptions);
        }
        return rootSymbol;
    }

    public static TextBuffer getTextBufferFor(URL uRL) {
        TextBuffer textBuffer = null;
        Node node = NodeFactory.find((URL)uRL);
        if (node != null && node instanceof JavaSourceNode && node.isOpen()) {
            JavaSourceNode javaSourceNode = (JavaSourceNode)node;
            textBuffer = javaSourceNode.acquireTextBuffer();
        }
        if (textBuffer == null) {
            String string = IdeUtil.getIdeEncoding();
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                try {
                    inputStream = URLFileSystem.openInputStream((URL)uRL);
                    inputStreamReader = new InputStreamReader(inputStream, string);
                    TextBuffer textBuffer2 = TextBufferFactory.createArrayTextBuffer();
                    textBuffer2.read((Reader)inputStreamReader);
                    textBuffer = textBuffer2;
                }
                catch (IOException iOException) {
                    textBuffer = null;
                }
            }
            finally {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    } else if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return textBuffer;
    }
}

