/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util.gutter;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.LocatableItem;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;

public abstract class AbstractLineGutterMarkList
implements LineGutterMarkList {
    private List lineGutterMarkList = new ArrayList();

    public abstract LocatableItem createLineGutterMark(URL var1, int var2);

    public abstract boolean allowMultipleMarksPerLine();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineGutterMarkList.size();
        stringBuffer.append("num lineGutterMarks: " + n);
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            LocatableItem locatableItem = (LocatableItem)this.lineGutterMarkList.get(n2);
            stringBuffer.append(locatableItem.toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] getAllLineGutterMarks() {
        LocatableItem[] locatableItemArray;
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n = this.lineGutterMarkList.size();
            locatableItemArray = this.lineGutterMarkList.toArray(new LocatableItem[n]);
        }
        return locatableItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineGutterMarkCount() {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n = this.lineGutterMarkList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] findLineGutterMarks(URL uRL) {
        ArrayList<LocatableItem> arrayList = new ArrayList<LocatableItem>();
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n = this.lineGutterMarkList.size();
            int n2 = 0;
            while (n2 < n) {
                LocatableItem locatableItem = (LocatableItem)this.lineGutterMarkList.get(n2);
                if (this.matches(locatableItem, uRL)) {
                    arrayList.add(locatableItem);
                }
                ++n2;
            }
        }
        int n = arrayList.size();
        return arrayList.toArray(new LocatableItem[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] findLineGutterMark(URL uRL, int n) {
        ArrayList<LocatableItem> arrayList = new ArrayList<LocatableItem>();
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n2 = this.lineGutterMarkList.size();
            int n3 = 0;
            while (n3 < n2) {
                LocatableItem locatableItem = (LocatableItem)this.lineGutterMarkList.get(n3);
                if (this.matches(locatableItem, uRL, n)) {
                    arrayList.add(locatableItem);
                    if (!this.allowMultipleMarksPerLine()) break;
                }
                ++n3;
            }
        }
        int n4 = arrayList.size();
        if (n4 > 0) {
            return arrayList.toArray(new LocatableItem[n4]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem addLineGutterMark(URL uRL, int n) {
        LocatableItem[] locatableItemArray;
        if (!this.allowMultipleMarksPerLine() && (locatableItemArray = this.findLineGutterMark(uRL, n)) != null) {
            return locatableItemArray[0];
        }
        LocatableItem locatableItem = this.createLineGutterMark(uRL, n);
        List list = this.lineGutterMarkList;
        synchronized (list) {
            this.insertLineGutterMark(locatableItem);
        }
        return locatableItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyLineGutterMark(LocatableItem locatableItem, int n) {
        boolean bl;
        if (locatableItem.getLine() == n) {
            return true;
        }
        List list = this.lineGutterMarkList;
        synchronized (list) {
            if (!this.allowMultipleMarksPerLine()) {
                this.removeLineGutterMark(locatableItem);
                locatableItem.setLine(n);
                bl = this.insertLineGutterMark(locatableItem);
            } else {
                locatableItem.setLine(n);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLineGutterMark(LocatableItem locatableItem) {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n = this.lineGutterMarkList.indexOf(locatableItem);
            if (n != -1) {
                this.lineGutterMarkList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLineGutterMarks() {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            this.lineGutterMarkList.clear();
        }
    }

    protected abstract boolean insertLineGutterMark(LocatableItem var1);

    public List getLineGutterMarkList() {
        return this.lineGutterMarkList;
    }

    public void setLineGutterMarkList(List list) {
        this.lineGutterMarkList = list;
    }

    private boolean matches(LocatableItem locatableItem, URL uRL) {
        return URLFileSystem.equals((URL)locatableItem.getURL(), (URL)uRL);
    }

    private boolean matches(LocatableItem locatableItem, URL uRL, int n) {
        if (this.matches(locatableItem, uRL)) {
            return locatableItem.getLine() == n;
        }
        return false;
    }
}

