/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util.gutter;

import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.LocatableItem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;
import oracle.jdeveloper.util.gutter.OpenEditor;
import oracle.jdeveloper.util.gutter.OpenLineGutterMark;

public abstract class AbstractLineGutterMarkManager
implements GutterColumnListener,
EditorListener {
    public static final int MISSING_MOVE = 1;
    public static final int MISSING_DISCARD = 2;
    private static final OpenLineGutterMark[] NO_OPEN_LINE_GUTTER_MARKS = new OpenLineGutterMark[0];
    private boolean _started;
    private static final int VERY_BIG_LINE = 2000000000;
    private List openEditorList;

    public AbstractLineGutterMarkManager() {
        this.$init$();
        this.startup();
    }

    void $init$() {
        this._started = false;
        this.openEditorList = new ArrayList();
    }

    protected void startup() {
        if (!this._started) {
            this._started = true;
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.addEditorListener((EditorListener)this);
        }
    }

    protected void shutdown() {
        if (this._started) {
            this._started = false;
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.removeEditorListener((EditorListener)this);
        }
    }

    protected void toggleLineGutterMark(CodeEditor codeEditor) {
        int n = codeEditor.getCaretLine();
        this.toggleLineGutterMark(codeEditor, n);
    }

    public void toggleLineGutterMark(CodeEditor codeEditor, int n) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return;
        }
        LocatableItem[] locatableItemArray = this.getLineGutterMarkList().findLineGutterMark(uRL, n);
        if (locatableItemArray == null) {
            this.createLineGutterMarkFor(uRL, n);
        } else {
            this.removeLineGutterMark(locatableItemArray[0]);
        }
    }

    public boolean hasLineGutterMarks() {
        return this.getLineGutterMarkList().getLineGutterMarkCount() != 0;
    }

    public LocatableItem[] getAllLineGutterMarks() {
        return this.getLineGutterMarkList().getAllLineGutterMarks();
    }

    public void gotoLineGutterMark(LocatableItem locatableItem) {
        URL uRL = locatableItem.getURL();
        OpenEditor[] openEditorArray = this.getOpenEditorsFor(uRL);
        if (openEditorArray.length > 0) {
            CodeEditor codeEditor;
            OpenEditor openEditor = openEditorArray[0];
            if (openEditorArray.length > 1) {
                Project project = Ide.getActiveProject();
                Workspace workspace = Ide.getActiveWorkspace();
                OpenEditor openEditor2 = null;
                int n = openEditorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Context context = openEditorArray[n2].editor.getContext();
                    if (context.getProject() == project) {
                        openEditor2 = openEditorArray[n2];
                        break;
                    }
                    ++n2;
                }
                if (openEditor2 == null) {
                    int n3 = 0;
                    while (n3 < n) {
                        Context context = openEditorArray[n3].editor.getContext();
                        if (context.getWorkspace() == workspace) {
                            openEditor2 = openEditorArray[n3];
                            break;
                        }
                        ++n3;
                    }
                }
                if (openEditor2 != null) {
                    openEditor = openEditor2;
                }
            }
            if ((codeEditor = openEditor.editor) != null) {
                EditorManager editorManager = EditorManager.getEditorManager();
                Context context = codeEditor.getContext();
                CodeEditor codeEditor2 = (CodeEditor)editorManager.openEditorInFrame(CodeEditor.class, context);
                codeEditor2.gotoLine(locatableItem.getLine(), locatableItem.getColumn(), false);
            }
        } else {
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                if (node != null) {
                    Context context = Context.newIdeContext((Node)node);
                    EditorManager editorManager = EditorManager.getEditorManager();
                    CodeEditor codeEditor = (CodeEditor)editorManager.openEditorInFrame(CodeEditor.class, context);
                    if (codeEditor != null) {
                        codeEditor.gotoLine(locatableItem.getLine(), locatableItem.getColumn(), false);
                    }
                } else {
                    System.out.println("could not locate node");
                }
            }
            catch (InstantiationException instantiationException) {
                System.out.println("could not locate node");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("could not locate node");
            }
        }
    }

    public void removeLineGutterMark(LocatableItem locatableItem) {
        this.getLineGutterMarkList().removeLineGutterMark(locatableItem);
        OpenLineGutterMark[] openLineGutterMarkArray = this.getOpenLineGutterMarksFor(locatableItem);
        int n = openLineGutterMarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpenLineGutterMark openLineGutterMark = openLineGutterMarkArray[n2];
            OpenEditor openEditor = this.getOpenEditorFor(openLineGutterMark);
            if (openEditor != null) {
                openEditor.openLineGutterMarkList.remove(openLineGutterMark);
                openLineGutterMark.guttermark.getGutterColumn().removeGutterMark(openLineGutterMark.guttermark);
                if (openEditor.openLineGutterMarkList.size() == 0) {
                    this.removeGutterColumnFrom(openEditor.editor);
                }
            }
            ++n2;
        }
    }

    protected abstract Icon getIcon();

    protected abstract HighlightStyle getHighlightStyle();

    protected abstract int getMarkOrder();

    protected abstract int getMarkOptions();

    protected abstract String getGutterColumnName();

    protected abstract LineGutterMarkList getLineGutterMarkList();

    protected abstract int getMissingLineBehavior();

    private boolean shouldRemoveLineGutterMarkForNonExistentLine() {
        int n = this.getMissingLineBehavior();
        return n == 2;
    }

    public void createLineGutterMarkFor(LocatableItem locatableItem) {
        OpenEditor[] openEditorArray = this.getOpenEditorsFor(locatableItem.getURL());
        int n = openEditorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = openEditorArray[n2];
            this.createGutterColumnFor(openEditor.editor);
            OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(openEditor.gutter, locatableItem);
            openEditor.openLineGutterMarkList.add(openLineGutterMark);
            ++n2;
        }
    }

    private LocatableItem createLineGutterMarkFor(URL uRL, int n) {
        LocatableItem locatableItem = this.getLineGutterMarkList().addLineGutterMark(uRL, n);
        OpenEditor[] openEditorArray = this.getOpenEditorsFor(uRL);
        int n2 = openEditorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            OpenEditor openEditor = openEditorArray[n3];
            this.createGutterColumnFor(openEditor.editor);
            OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(openEditor.gutter, locatableItem);
            openEditor.openLineGutterMarkList.add(openLineGutterMark);
            ++n3;
        }
        return locatableItem;
    }

    private boolean isLineGutterMarkOnOpenList(LocatableItem locatableItem) {
        URL uRL = locatableItem.getURL();
        return this.hasOpenEditorsFor(uRL);
    }

    protected OpenLineGutterMark[] getOpenLineGutterMarkFor(GutterMark gutterMark) {
        ArrayList<OpenLineGutterMark> arrayList = new ArrayList<OpenLineGutterMark>();
        CodeEditorGutter codeEditorGutter = (CodeEditorGutter)gutterMark.getGutter();
        OpenEditor openEditor = this.getOpenEditorFor(codeEditorGutter);
        List list = openEditor.openLineGutterMarkList;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            OpenLineGutterMark openLineGutterMark = (OpenLineGutterMark)list.get(n2);
            if (openLineGutterMark.guttermark == gutterMark) {
                arrayList.add(openLineGutterMark);
                if (!this.getLineGutterMarkList().allowMultipleMarksPerLine()) break;
            }
            ++n2;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return NO_OPEN_LINE_GUTTER_MARKS;
        }
        return arrayList.toArray(new OpenLineGutterMark[n3]);
    }

    protected OpenEditor getOpenEditorFor(CodeEditorGutter codeEditorGutter) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.gutter == codeEditorGutter) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    protected OpenLineGutterMark[] getOpenLineGutterMarksFor(LocatableItem locatableItem) {
        ArrayList<OpenLineGutterMark> arrayList = new ArrayList<OpenLineGutterMark>();
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            OpenLineGutterMark openLineGutterMark = this.getOpenLineGutterMarkFor(openEditor, locatableItem);
            if (openLineGutterMark != null) {
                arrayList.add(openLineGutterMark);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new OpenLineGutterMark[n3]);
    }

    protected OpenLineGutterMark getOpenLineGutterMarkFor(OpenEditor openEditor, LocatableItem locatableItem) {
        List list = openEditor.openLineGutterMarkList;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            OpenLineGutterMark openLineGutterMark = (OpenLineGutterMark)list.get(n2);
            if (openLineGutterMark.lineGutterMark == locatableItem) {
                return openLineGutterMark;
            }
            ++n2;
        }
        return null;
    }

    protected OpenEditor getOpenEditorFor(OpenLineGutterMark openLineGutterMark) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.openLineGutterMarkList.contains(openLineGutterMark)) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    private boolean hasOpenEditorsFor(URL uRL) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.url.equals(uRL)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected OpenEditor[] getOpenEditorsFor(URL uRL) {
        ArrayList<OpenEditor> arrayList = new ArrayList<OpenEditor>();
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.url.equals(uRL)) {
                arrayList.add(openEditor);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new OpenEditor[n3]);
    }

    protected OpenEditor getOpenEditorFor(CodeEditor codeEditor) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.editor == codeEditor) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    protected URL getURLFor(CodeEditor codeEditor) {
        Node node;
        Context context;
        if (codeEditor != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
            return node.getURL();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private LocatableItem[] getNormalizedLineGutterMarksFor(CodeEditor var1_1, URL var2_2) {
        var3_3 = new ArrayList<LocatableItem>();
        var4_4 = this.getLineGutterMarkList().findLineGutterMarks(var2_2);
        var5_5 = var4_4.length;
        if (var1_1.getGUI() == null) {
            return null;
        }
        var6_6 = var1_1.getLineCount();
        var7_7 = 0;
        while (var7_7 < var5_5) {
            var8_8 = var4_4[var7_7];
            v0 = var9_9 = var8_8.getLine() > var6_6;
            if (!var9_9) ** GOTO lbl-1000
            if (this.isLineGutterMarkOnOpenList(var8_8)) {
                throw new IllegalStateException("bad line open elsewhere");
            }
            var10_10 = this.shouldRemoveLineGutterMarkForNonExistentLine();
            if (!var10_10 && !(var11_11 = this.getLineGutterMarkList().modifyLineGutterMark(var8_8, var6_6))) {
                var10_10 = true;
            }
            if (var10_10) {
                this.getLineGutterMarkList().removeLineGutterMark(var8_8);
                var4_4[var7_7] = null;
            } else lbl-1000:
            // 2 sources

            {
                var3_3.add(var8_8);
            }
            ++var7_7;
        }
        var12_12 = var3_3.size();
        return var3_3.toArray(new LocatableItem[var12_12]);
    }

    private void createGutterColumnFor(CodeEditor codeEditor) {
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(this.getGutterColumnName());
        if (gutterColumn == null) {
            codeEditorGutter.createGutterColumn(this.getGutterColumnName(), (GutterColumnListener)this);
        }
    }

    protected void removeGutterColumnFrom(CodeEditor codeEditor) {
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(this.getGutterColumnName());
        if (gutterColumn != null) {
            codeEditorGutter.removeGutterColumn(gutterColumn);
        }
    }

    protected OpenLineGutterMark createOpenLineGutterMarkFor(CodeEditorGutter codeEditorGutter, LocatableItem locatableItem) {
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(this.getGutterColumnName());
        GutterMark gutterMark = gutterColumn.addGutterMark(locatableItem.getLine(), this.getIcon(), this.getHighlightStyle(), this.getMarkOrder(), this.getMarkOptions());
        gutterMark.setUserData((Object)locatableItem);
        OpenLineGutterMark openLineGutterMark = new OpenLineGutterMark(locatableItem, gutterMark);
        return openLineGutterMark;
    }

    private OpenEditor createOpenEditorFor(CodeEditor codeEditor) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return null;
        }
        LocatableItem[] locatableItemArray = this.getNormalizedLineGutterMarksFor(codeEditor, uRL);
        if (locatableItemArray == null) {
            return null;
        }
        int n = locatableItemArray.length;
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        ArrayList<OpenLineGutterMark> arrayList = new ArrayList<OpenLineGutterMark>();
        if (n > 0) {
            this.createGutterColumnFor(codeEditor);
            int n2 = 0;
            while (n2 < n) {
                LocatableItem locatableItem = locatableItemArray[n2];
                OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(codeEditorGutter, locatableItem);
                arrayList.add(openLineGutterMark);
                ++n2;
            }
        }
        OpenEditor openEditor = new OpenEditor(codeEditor, uRL, codeEditorGutter, arrayList);
        return openEditor;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.createOpenEditorFor(codeEditor);
            this.openEditorList.add(openEditor);
        }
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.getOpenEditorFor(codeEditor);
            this.removeGutterColumnFrom(codeEditor);
            this.openEditorList.remove(openEditor);
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
        OpenLineGutterMark[] openLineGutterMarkArray = this.getOpenLineGutterMarkFor(gutterMark);
        int n3 = 0;
        while (n3 < openLineGutterMarkArray.length) {
            LocatableItem locatableItem = openLineGutterMarkArray[n3].lineGutterMark;
            boolean bl = this.getLineGutterMarkList().modifyLineGutterMark(locatableItem, n2);
            if (!bl) {
                this.removeLineGutterMark(locatableItem);
            }
            ++n3;
        }
    }

    public void markRemoved(GutterMark gutterMark, int n) {
        OpenLineGutterMark[] openLineGutterMarkArray = this.getOpenLineGutterMarkFor(gutterMark);
        int n2 = 0;
        while (n2 < openLineGutterMarkArray.length) {
            LocatableItem locatableItem = openLineGutterMarkArray[n2].lineGutterMark;
            this.removeLineGutterMark(locatableItem);
            ++n2;
        }
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        String string = null;
        Object object = gutterMark.getUserData();
        if (object != null) {
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod("getTooltip", null);
                if (method != null) {
                    string = (String)method.invoke(object, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

