/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.Component;
import java.util.Arrays;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.wizard.apptemplate.EditTemplatesPanel;
import oracle.jdeveloper.wizard.apptemplate.ProjectData;
import oracle.jdeveloper.wizard.apptemplate.ProjectDefinitionPanel;
import oracle.jdeveloper.wizard.apptemplate.TemplatesData;

public final class ApplicationData
implements Comparable,
Copyable {
    private String _name;
    private String _description;
    private float _weight;
    private ProjectData[] _projectData;
    private transient TemplatesData _master;

    public Object copyTo(Object object) {
        ApplicationData applicationData = object != null ? (ApplicationData)object : new ApplicationData();
        this.copyToImpl(applicationData);
        return applicationData;
    }

    public int compareTo(Object object) {
        ApplicationData applicationData = (ApplicationData)object;
        if (this._weight != applicationData._weight) {
            if (this._weight == 0.0f) {
                return 1;
            }
            if (applicationData._weight == 0.0f) {
                return -1;
            }
            return (int)Math.signum(this._weight - applicationData._weight);
        }
        return this._name.compareTo(applicationData._name);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public float getWeight() {
        return this._weight;
    }

    public void setWeight(float f) {
        this._weight = f;
    }

    public ProjectData[] getProjectData() {
        return this._projectData;
    }

    public void setProjectData(ProjectData[] projectDataArray) {
        if (projectDataArray != null) {
            int n = 0;
            while (n < projectDataArray.length) {
                projectDataArray[n].setMaster(this);
                ++n;
            }
        }
        this._projectData = projectDataArray;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.equalsImpl((ApplicationData)object);
    }

    protected final boolean equalsImpl(ApplicationData applicationData) {
        return ModelUtil.areEqual((Object)this._name, (Object)applicationData._name) && ModelUtil.areEqual((Object)this._description, (Object)applicationData._description) && this._weight == applicationData._weight && Arrays.equals(this._projectData, applicationData._projectData);
    }

    protected final void copyToImpl(ApplicationData applicationData) {
        applicationData._name = this._name;
        applicationData._description = this._description;
        applicationData._weight = this._weight;
        if (this._projectData != null) {
            int n = this._projectData.length;
            ProjectData[] projectDataArray = new ProjectData[n];
            int n2 = n;
            while (n2-- > 0) {
                ProjectData projectData = this._projectData[n2];
                ProjectData projectData2 = projectDataArray[n2] = projectData != null ? (ProjectData)projectData.copyTo(null) : null;
            }
            applicationData.setProjectData(projectDataArray);
        } else {
            applicationData._projectData = null;
        }
    }

    Navigable createNavigable() {
        Navigable[] navigableArray;
        if (this._projectData != null) {
            int n = this._projectData.length;
            navigableArray = new Navigable[n];
            int n2 = 0;
            while (n2 < n) {
                navigableArray[n2] = this._projectData[n2].createNavigable();
                ++n2;
            }
        } else {
            navigableArray = null;
        }
        return new Navigable(this._name, EditTemplatesPanel.ApplicationPanel.class, new Class[]{ApplicationData.class}, new Object[]{this}, navigableArray);
    }

    Navigable createChildNavigable(Component component) {
        ProjectDefinitionPanel projectDefinitionPanel = new ProjectDefinitionPanel();
        if (!projectDefinitionPanel.showDialog(component)) {
            return null;
        }
        String string = this.generateDefaultPackageName();
        int n = this._projectData != null ? this._projectData.length : 0;
        ProjectData[] projectDataArray = new ProjectData[n + 1];
        if (this._projectData != null) {
            System.arraycopy(this._projectData, 0, projectDataArray, 0, n);
        }
        this._projectData = projectDataArray;
        ProjectData projectData = new ProjectData();
        projectData.setName(projectDefinitionPanel.getTemplateName());
        projectData.setProjectName(projectDefinitionPanel.getProjectName());
        projectData.setPackageName(string);
        projectData.setMaster(this);
        projectDataArray[n] = projectData;
        return projectData.createNavigable();
    }

    void setMaster(TemplatesData templatesData) {
        this._master = templatesData;
    }

    boolean removeMaster(int n) {
        return this._master.remove(n);
    }

    boolean remove(int n) {
        int n2;
        int n3 = n2 = this._projectData != null ? this._projectData.length : 0;
        if (n >= n2) {
            return false;
        }
        if (n2 <= 1) {
            this._projectData = null;
            return true;
        }
        ProjectData[] projectDataArray = new ProjectData[n2 - 1];
        if (n > 0) {
            System.arraycopy(this._projectData, 0, projectDataArray, 0, n);
        }
        System.arraycopy(this._projectData, n + 1, projectDataArray, n, n2 - n - 1);
        this._projectData = projectDataArray;
        return true;
    }

    boolean isUniqueTemplateName(String string) {
        ApplicationData[] applicationDataArray = this._master.getApplicationData();
        if (applicationDataArray != null) {
            int n = 0;
            while (n < applicationDataArray.length) {
                ApplicationData applicationData = applicationDataArray[n];
                if (applicationData != this && ModelUtil.areEqual((Object)string, (Object)applicationData.getName())) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private String generateDefaultPackageName() {
        String string;
        int n = 1;
        block0: while (true) {
            string = "mypackage" + n++;
            if (this._projectData == null) break;
            int n2 = 0;
            while (n2 < this._projectData.length) {
                ProjectData projectData = this._projectData[n2];
                if (ModelUtil.areEqual((Object)string, (Object)projectData.getPackageName())) continue block0;
                ++n2;
            }
            break;
        }
        return string;
    }
}

