/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.model.TechnologyScope;
import oracle.jdeveloper.wizard.apptemplate.AppTemplateArb;
import oracle.jdeveloper.wizard.apptemplate.ApplicationData;
import oracle.jdeveloper.wizard.apptemplate.ProjectData;
import oracle.jdeveloper.wizard.apptemplate.TemplatesData;

public final class ApplicationTemplateHookHandler
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-application-templates";
    public static final ElementName ELEMENT = ApplicationTemplateHookHandler.element("application-templates-hook");
    private TemplatesData _templateData;
    private Map _techkeyMap;
    private static String KEY_ROOT_TEMPLATE_DATA = "root-template-data";
    private static String KEY_APPLICATION_DATA = "application-data";
    private static String KEY_PROJECT_DATA = "project-data";
    private static String KEY_PROJECT_LIST = "project-list";
    private static String KEY_TECHNOLOGY_SCOPE = "technology-scope";
    private static String KEY_TECHKEY_MAP = "technology-key-map";
    private final ElementVisitor _applicationDataHandler;
    private final ElementVisitor _nameHandler;
    private final ElementVisitor _namePrjHandler;
    private final ElementVisitor _descriptionHandler;
    private final ElementVisitor _weightHandler;
    private final ElementVisitor _projectDataHandler;
    private final ElementVisitor _packageNameHandler;
    private final ElementVisitor _projectNameHandler;
    private final ElementVisitor _technologyScopeHandler;

    void $init$() {
        this._templateData = new TemplatesData();
        this._techkeyMap = new HashMap();
        this._applicationDataHandler = new ApplicationDataHandler(null);
        this._nameHandler = new NameHandler(null);
        this._namePrjHandler = new NamePrjHandler(null);
        this._descriptionHandler = new DescriptionHandler(null);
        this._weightHandler = new WeightHandler(null);
        this._projectDataHandler = new ProjectDataHandler(null);
        this._packageNameHandler = new PackageNameHandler(null);
        this._projectNameHandler = new ProjectNameHandler(null);
        this._technologyScopeHandler = new TechnologyScopeHandler(null);
    }

    private static final ElementName element(String string) {
        return new ElementName(NS, string);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.element("application-data"), this._applicationDataHandler);
        elementStartContext.getScopeData().put(KEY_ROOT_TEMPLATE_DATA, this._templateData);
        elementStartContext.getScopeData().put(KEY_TECHKEY_MAP, this._techkeyMap);
    }

    TemplatesData getTemplatesData() {
        if (this._templateData.getName() == null) {
            this._templateData.setName(AppTemplateArb.getString(0));
        }
        this.assignTechnologyScope();
        return this._templateData;
    }

    private void assignTechnologyScope() {
        for (ProjectData projectData : this._techkeyMap.keySet()) {
            List list = (List)this._techkeyMap.get(projectData);
            TechnologyScope technologyScope = new TechnologyScope();
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            technologyScope.setTechnologyKeys(stringArray);
            projectData.setTechnologyScope(technologyScope);
        }
    }

    private Map getTechnologyKeyMap(ElementContext elementContext) {
        return (Map)elementContext.getScopeData().get(KEY_TECHKEY_MAP);
    }

    private ApplicationData getApplication(ElementContext elementContext) {
        return (ApplicationData)elementContext.getScopeData().get(KEY_APPLICATION_DATA);
    }

    private ProjectData getProjectData(ElementContext elementContext) {
        return (ProjectData)elementContext.getScopeData().get(KEY_PROJECT_DATA);
    }

    public ApplicationTemplateHookHandler() {
        this.$init$();
    }

    static String ra$KEY_ROOT_TEMPLATE_DATA() {
        return KEY_ROOT_TEMPLATE_DATA;
    }

    static String ra$KEY_PROJECT_LIST() {
        return KEY_PROJECT_LIST;
    }

    static ApplicationData mav$getApplication(ApplicationTemplateHookHandler applicationTemplateHookHandler, ElementContext elementContext) {
        return applicationTemplateHookHandler.getApplication(elementContext);
    }

    static ElementName maS$element(String string) {
        return ApplicationTemplateHookHandler.element(string);
    }

    static ElementVisitor ra$_nameHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._nameHandler;
    }

    static ElementVisitor ra$_descriptionHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._descriptionHandler;
    }

    static ElementVisitor ra$_weightHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._weightHandler;
    }

    static ElementVisitor ra$_projectDataHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._projectDataHandler;
    }

    static String ra$KEY_APPLICATION_DATA() {
        return KEY_APPLICATION_DATA;
    }

    static ProjectData mav$getProjectData(ApplicationTemplateHookHandler applicationTemplateHookHandler, ElementContext elementContext) {
        return applicationTemplateHookHandler.getProjectData(elementContext);
    }

    static ElementVisitor ra$_namePrjHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._namePrjHandler;
    }

    static ElementVisitor ra$_packageNameHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._packageNameHandler;
    }

    static ElementVisitor ra$_projectNameHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._projectNameHandler;
    }

    static ElementVisitor ra$_technologyScopeHandler(ApplicationTemplateHookHandler applicationTemplateHookHandler) {
        return applicationTemplateHookHandler._technologyScopeHandler;
    }

    static String ra$KEY_PROJECT_DATA() {
        return KEY_PROJECT_DATA;
    }

    static String ra$KEY_TECHNOLOGY_SCOPE() {
        return KEY_TECHNOLOGY_SCOPE;
    }

    static Map mav$getTechnologyKeyMap(ApplicationTemplateHookHandler applicationTemplateHookHandler, ElementContext elementContext) {
        return applicationTemplateHookHandler.getTechnologyKeyMap(elementContext);
    }

    private class ApplicationDataHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("name"), ApplicationTemplateHookHandler.ra$_nameHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("description"), ApplicationTemplateHookHandler.ra$_descriptionHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("weight"), ApplicationTemplateHookHandler.ra$_weightHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("projectData"), ApplicationTemplateHookHandler.ra$_projectDataHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.getScopeData().put(ApplicationTemplateHookHandler.ra$KEY_APPLICATION_DATA(), new ApplicationData());
            elementStartContext.getScopeData().put(ApplicationTemplateHookHandler.ra$KEY_PROJECT_LIST(), new ArrayList());
        }

        public void end(ElementEndContext elementEndContext) {
            TemplatesData templatesData = (TemplatesData)elementEndContext.getScopeData().get(ApplicationTemplateHookHandler.ra$KEY_ROOT_TEMPLATE_DATA());
            List list = (List)elementEndContext.getScopeData().get(ApplicationTemplateHookHandler.ra$KEY_PROJECT_LIST());
            ProjectData[] projectDataArray = new ProjectData[list.size()];
            list.toArray(projectDataArray);
            ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext).setProjectData(projectDataArray);
            ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext).setMaster(templatesData);
            templatesData.add(ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext));
        }

        private ApplicationDataHandler() {
        }

        ApplicationDataHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class NameHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ApplicationData applicationData = ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, elementContext);
            applicationData.setName(string);
        }

        private NameHandler() {
        }

        NameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DescriptionHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ApplicationData applicationData = ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, elementContext);
            applicationData.setDescription(string);
        }

        private DescriptionHandler() {
        }

        DescriptionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WeightHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ApplicationData applicationData = ApplicationTemplateHookHandler.mav$getApplication(ApplicationTemplateHookHandler.this, elementContext);
            try {
                applicationData.setWeight(Float.valueOf(string).floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                applicationData.setWeight(0.0f);
            }
        }

        private WeightHandler() {
        }

        WeightHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProjectDataHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("name"), ApplicationTemplateHookHandler.ra$_namePrjHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("packageName"), ApplicationTemplateHookHandler.ra$_packageNameHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("projectName"), ApplicationTemplateHookHandler.ra$_projectNameHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("technologyScope"), ApplicationTemplateHookHandler.ra$_technologyScopeHandler(ApplicationTemplateHookHandler.this));
            elementStartContext.getScopeData().put(ApplicationTemplateHookHandler.ra$KEY_PROJECT_DATA(), new ProjectData());
        }

        public void end(ElementEndContext elementEndContext) {
            List list = (List)elementEndContext.getScopeData().get(ApplicationTemplateHookHandler.ra$KEY_PROJECT_LIST());
            list.add(ApplicationTemplateHookHandler.mav$getProjectData(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext));
        }

        private ProjectDataHandler() {
        }

        ProjectDataHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class NamePrjHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ProjectData projectData = ApplicationTemplateHookHandler.mav$getProjectData(ApplicationTemplateHookHandler.this, elementContext);
            projectData.setName(string);
        }

        private NamePrjHandler() {
        }

        NamePrjHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PackageNameHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ApplicationTemplateHookHandler.mav$getProjectData(ApplicationTemplateHookHandler.this, elementContext).setPackageName(string);
        }

        private PackageNameHandler() {
        }

        PackageNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProjectNameHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            ApplicationTemplateHookHandler.mav$getProjectData(ApplicationTemplateHookHandler.this, elementContext).setProjectName(string);
        }

        private ProjectNameHandler() {
        }

        ProjectNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TechnologyScopeHandler
    extends ElementVisitor {
        private ElementVisitor _technologyKeyHandler;

        void $init$() {
            this._technologyKeyHandler = new TechnologyKeyHandler(null);
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(ApplicationTemplateHookHandler.maS$element("technologyKey"), this._technologyKeyHandler);
            elementStartContext.getScopeData().put(ApplicationTemplateHookHandler.ra$KEY_TECHNOLOGY_SCOPE(), new ArrayList());
        }

        public void end(ElementEndContext elementEndContext) {
            List list = (List)elementEndContext.getScopeData().get(ApplicationTemplateHookHandler.ra$KEY_TECHNOLOGY_SCOPE());
            ProjectData projectData = ApplicationTemplateHookHandler.mav$getProjectData(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext);
            Map map = ApplicationTemplateHookHandler.mav$getTechnologyKeyMap(ApplicationTemplateHookHandler.this, (ElementContext)elementEndContext);
            map.put(projectData, list);
        }

        private TechnologyScopeHandler() {
            this.$init$();
        }

        TechnologyScopeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TechnologyKeyHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            List list = (List)elementEndContext.getScopeData().get(ApplicationTemplateHookHandler.ra$KEY_TECHNOLOGY_SCOPE());
            list.add(elementEndContext.getText().trim());
        }

        private TechnologyKeyHandler() {
        }

        TechnologyKeyHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

