/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.net.URL;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.model.TechnologyScope;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.model.TechnologiesPanel;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.wizard.apptemplate.ApplicationData;
import oracle.jdeveloper.wizard.apptemplate.ApplicationDefinitionPanel;
import oracle.jdeveloper.wizard.apptemplate.NewApplicationDialog;
import oracle.jdeveloper.wizard.apptemplate.ProjectData;
import oracle.jdeveloper.wizard.apptemplate.ProjectDefinitionPanel;
import oracle.jdeveloper.wizard.apptemplate.TemplatesData;
import oracle.jdeveloper.wizard.apptemplate.TemplatesXMLDataNode;

final class EditTemplatesPanel
extends MDDPanel {
    private static final String HELP_ID = "f1_idededittemplatesmain_html";
    private static int mainDividerLocation;
    private final TemplatesData _data;
    private final JPanel _buttonPanel;
    private final JButton _newButton;
    private final JButton _deleteButton;

    void $init$() {
        this._buttonPanel = new JPanel();
        this._newButton = new JButton();
        this._deleteButton = new JButton();
    }

    public EditTemplatesPanel() {
        this(new TemplatesXMLDataNode().getTemplatesData());
    }

    EditTemplatesPanel(TemplatesData templatesData) {
        this.$init$();
        this._data = templatesData;
        this.setHelpID(HELP_ID);
        if (this._data != null) {
            this.setRootNavigables(new Navigable[]{this._data.createNavigable()});
        }
        EventAdapter eventAdapter = new EventAdapter(null);
        this.addHierarchyListener(eventAdapter);
        this.addMDDListener((MDDListener)eventAdapter);
        this._newButton.addActionListener(eventAdapter);
        this._deleteButton.addActionListener(eventAdapter);
        ResourceUtils.resButton((AbstractButton)this._newButton, (String)CommandArb.getString(23));
        ResourceUtils.resButton((AbstractButton)this._deleteButton, (String)CommandArb.getString(24));
        this._buttonPanel.setLayout(new GridBagLayout());
        this._buttonPanel.add((Component)Box.createHorizontalBox(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 8), 0, 0));
        this._buttonPanel.add((Component)this._newButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(8, 0, 0, 0), 0, 0));
        this._buttonPanel.add((Component)this._deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(8, 8, 0, 0), 0, 0));
        this.addTreePanelComponent(this._buttonPanel, "South");
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.expandTree1ToDepth(3);
    }

    void finish() {
        mainDividerLocation = this.getMainDividerLocation();
    }

    ApplicationData getSelectedApp() {
        String[] stringArray = this.getTree1SelectionPath();
        if (stringArray == null || stringArray.length < 2) {
            return null;
        }
        ApplicationData[] applicationDataArray = this._data.getApplicationData();
        if (applicationDataArray == null) {
            return null;
        }
        String string = stringArray[1];
        int n = 0;
        while (n < applicationDataArray.length) {
            ApplicationData applicationData = applicationDataArray[n];
            if (ModelUtil.areEqual((Object)string, (Object)applicationData.getName())) {
                return applicationData;
            }
            ++n;
        }
        return null;
    }

    private void setMainDividerLocation(int n) {
        this.getMainSplitPane().setDividerLocation(n);
    }

    private int getMainDividerLocation() {
        return this.getMainSplitPane().getDividerLocation();
    }

    static int ra$mainDividerLocation() {
        return mainDividerLocation;
    }

    static void mav$setMainDividerLocation(EditTemplatesPanel editTemplatesPanel, int n) {
        editTemplatesPanel.setMainDividerLocation(n);
    }

    static JButton ra$_newButton(EditTemplatesPanel editTemplatesPanel) {
        return editTemplatesPanel._newButton;
    }

    static JButton ra$_deleteButton(EditTemplatesPanel editTemplatesPanel) {
        return editTemplatesPanel._deleteButton;
    }

    private interface CreateSupport {
        public boolean canCreate(TraversableContext var1);

        public void create(TraversableContext var1);
    }

    private interface DeleteSupport {
        public boolean canDelete(TraversableContext var1);

        public void delete(TraversableContext var1);
    }

    private final class EventAdapter
    extends MDDAdapter
    implements HierarchyListener,
    ActionListener {
        private transient TraversableContext _curContext;
        private transient Traversable _curTraversable;

        public void traversableEntered(MDDEvent mDDEvent) {
            this._curContext = mDDEvent.getTraversableContext();
            this._curTraversable = mDDEvent.getTraversable();
            EditTemplatesPanel.ra$_newButton(EditTemplatesPanel.this).setEnabled(this._curTraversable instanceof CreateSupport && ((CreateSupport)this._curTraversable).canCreate(this._curContext));
            EditTemplatesPanel.ra$_deleteButton(EditTemplatesPanel.this).setEnabled(this._curTraversable instanceof DeleteSupport && ((DeleteSupport)this._curTraversable).canDelete(this._curContext));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EditTemplatesPanel.ra$_newButton(EditTemplatesPanel.this)) {
                ((CreateSupport)this._curTraversable).create(this._curContext);
            } else if (object == EditTemplatesPanel.ra$_deleteButton(EditTemplatesPanel.this)) {
                EditTemplatesPanel.ra$_deleteButton(EditTemplatesPanel.this).setEnabled(false);
                ((DeleteSupport)this._curTraversable).delete(this._curContext);
            }
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Component component;
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && (component = hierarchyEvent.getComponent()).isShowing()) {
                if (EditTemplatesPanel.ra$mainDividerLocation() != 0) {
                    EditTemplatesPanel.mav$setMainDividerLocation(EditTemplatesPanel.this, EditTemplatesPanel.ra$mainDividerLocation());
                } else {
                    EditTemplatesPanel.this.setMainDividerLocation(0.3);
                }
                EditTemplatesPanel.this.removeHierarchyListener(this);
            }
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class CreateDeleteDefaultTraversablePanel
    extends DefaultTraversablePanel
    implements DeleteSupport,
    CreateSupport {
        private static final String MDD_TIE = "CreateDeleteDefaultTraversablePanel-MDD-tie";

        protected void untieTextComponentFromTreeNode(JTextComponent jTextComponent) {
            Object object = jTextComponent.getClientProperty(MDD_TIE);
            if (object instanceof DocumentListener) {
                jTextComponent.getDocument().removeDocumentListener((DocumentListener)object);
            }
        }

        protected void tieTextComponentToTreeNode(JTextComponent jTextComponent, TraversableContext traversableContext) {
            this.tieTextComponentToTreeNode(jTextComponent, traversableContext, CommandArb.getString(22));
        }

        protected void tieTextComponentToTreeNode(JTextComponent jTextComponent, TraversableContext traversableContext, String string) {
            this.untieTextComponentFromTreeNode(jTextComponent);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_NODE");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_MODEL");
            if (defaultMutableTreeNode == null || defaultTreeModel == null) {
                new IllegalStateException("Trying to tie a text field when the TraversableContext is not representing MDDPanel").printStackTrace();
                return;
            }
            1 var6_6 = new 1(this, defaultMutableTreeNode, jTextComponent, string, defaultTreeModel);
            jTextComponent.putClientProperty(MDD_TIE, var6_6);
            jTextComponent.getDocument().addDocumentListener(var6_6);
        }

        public boolean canCreate(TraversableContext traversableContext) {
            return false;
        }

        public void create(TraversableContext traversableContext) {
            JTree jTree = (JTree)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_MODEL");
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_NODE");
            Navigable navigable = this.createChildNavigable((Component)((Object)this));
            if (navigable != null) {
                NavigableContext navigableContext = traversableContext.newNavigableContext();
                DefaultMutableTreeNode defaultMutableTreeNode2 = navigable.createTreeNode(navigableContext);
                int n = defaultMutableTreeNode.getChildCount();
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{n});
                TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                jTree.setSelectionPath(treePath);
                jTree.expandPath(treePath);
            }
        }

        public boolean canDelete(TraversableContext traversableContext) {
            return false;
        }

        public void delete(TraversableContext traversableContext) {
            JTree jTree = (JTree)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_MODEL");
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)traversableContext.getDesignTimeObject("MDDPanel.CURRENT_TREE1_NODE");
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2 == null) {
                throw new IllegalStateException();
            }
            int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
            if (this.removeMasterData(n)) {
                int n2 = jTree.getSelectionRows()[0];
                defaultMutableTreeNode2.remove(n);
                defaultTreeModel.nodesWereRemoved(defaultMutableTreeNode2, new int[]{n}, new Object[]{defaultMutableTreeNode});
                jTree.setSelectionRow(n2 < jTree.getRowCount() ? n2 : n2 - 1);
            }
        }

        protected Navigable createChildNavigable(Component component) {
            return null;
        }

        protected boolean removeMasterData(int n) {
            return false;
        }

        private CreateDeleteDefaultTraversablePanel() {
        }

        CreateDeleteDefaultTraversablePanel(1 var1_1) {
            this();
        }

        final class 1
        implements DocumentListener {
            private final /* synthetic */ DefaultMutableTreeNode v$treeNode;
            private final /* synthetic */ JTextComponent v$textComp;
            private final /* synthetic */ String v$anonLabel;
            private final /* synthetic */ DefaultTreeModel v$treeModel;
            final /* synthetic */ CreateDeleteDefaultTraversablePanel this$0;

            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateName();
            }

            private void updateName() {
                Navigable navigable = (Navigable)this.v$treeNode.getUserObject();
                String string = this.v$textComp.getText();
                if (string != null) {
                    string = string.trim();
                }
                if (!ModelUtil.hasLength((String)string)) {
                    string = this.v$anonLabel;
                }
                navigable.setShortLabel(string);
                this.v$treeModel.nodeChanged(this.v$treeNode);
            }

            public 1(CreateDeleteDefaultTraversablePanel createDeleteDefaultTraversablePanel, DefaultMutableTreeNode defaultMutableTreeNode, JTextComponent jTextComponent, String string, DefaultTreeModel defaultTreeModel) {
                this.v$treeModel = defaultTreeModel;
                this.v$anonLabel = string;
                this.v$textComp = jTextComponent;
                this.v$treeNode = defaultMutableTreeNode;
                this.this$0 = createDeleteDefaultTraversablePanel;
            }
        }
    }

    public static final class TemplatesPanel
    extends CreateDeleteDefaultTraversablePanel {
        private static final String HELP_ID = "f1_idededittemplatesmain_html";
        private final TemplatesData _data;
        private final GridBagLayout _layout;
        private final JTextArea _helpTextArea;

        void $init$() {
            this._layout = new GridBagLayout();
            this._helpTextArea = new JTextArea();
        }

        public TemplatesPanel(TemplatesData templatesData) {
            super(null);
            this.$init$();
            this._data = templatesData;
            this.setHelpID("f1_idededittemplatesmain_html");
            this._helpTextArea.setEditable(false);
            this._helpTextArea.setOpaque(false);
            this._helpTextArea.setLineWrap(true);
            this._helpTextArea.setWrapStyleWord(true);
            this._helpTextArea.setFont(UIManager.getFont("Label.font"));
            this._helpTextArea.setText(CommandArb.getString(25));
            this.setLayout(this._layout);
            this.add(this._helpTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean canCreate(TraversableContext traversableContext) {
            return true;
        }

        protected Navigable createChildNavigable(Component component) {
            return this._data.createChildNavigable(component);
        }
    }

    public static final class ApplicationPanel
    extends CreateDeleteDefaultTraversablePanel {
        private static final String HELP_ID = "f1_idededittemplatesapplication_html";
        private final ApplicationData _data;
        private final GridBagLayout _layout;
        private final JTextArea _helpTextArea;
        private final ApplicationDefinitionPanel _applicationPanel;
        private final JLabel _applicationDescriptionLabel;
        private final JTextArea _applicationDescriptionTextArea;
        private final JScrollPane _applicationDescriptionScrollPane;

        void $init$() {
            this._layout = new GridBagLayout();
            this._helpTextArea = new JTextArea();
            this._applicationPanel = new ApplicationDefinitionPanel();
            this._applicationDescriptionLabel = new JLabel();
            this._applicationDescriptionTextArea = new JTextArea();
            this._applicationDescriptionScrollPane = new JScrollPane();
        }

        public ApplicationPanel(ApplicationData applicationData) {
            super(null);
            this.$init$();
            this._data = applicationData;
            this.setHelpID(HELP_ID);
            ResourceUtils.resLabel((JLabel)this._applicationDescriptionLabel, (Component)this._applicationDescriptionTextArea, (String)CommandArb.getString(28));
            this._helpTextArea.setEditable(false);
            this._helpTextArea.setOpaque(false);
            this._helpTextArea.setLineWrap(true);
            this._helpTextArea.setWrapStyleWord(true);
            this._helpTextArea.setFont(UIManager.getFont("Label.font"));
            this._helpTextArea.setText(CommandArb.getString(26));
            this._applicationDescriptionTextArea.setLineWrap(true);
            this._applicationDescriptionTextArea.setWrapStyleWord(true);
            this._applicationDescriptionScrollPane.setViewportView(this._applicationDescriptionTextArea);
            this.setLayout(this._layout);
            this.add(this._helpTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._applicationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.add(this._applicationDescriptionLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
            this.add(this._applicationDescriptionScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.5, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void onEntry(TraversableContext traversableContext) {
            super.onEntry(traversableContext);
            this.tieTextComponentToTreeNode(this._applicationPanel.getApplicationNameTextField(), traversableContext);
            this._applicationPanel.setTemplateName(this._data.getName());
            this._applicationDescriptionTextArea.setText(this._data.getDescription());
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            super.onExit(traversableContext);
            String string = this._applicationPanel.getTemplateName();
            if (!ModelUtil.hasLength((String)string)) {
                throw new TraversalException(CommandArb.getString(29));
            }
            if (!this._data.isUniqueTemplateName(string)) {
                String string2 = CommandArb.format(30, string);
                throw new TraversalException(string2);
            }
            this.untieTextComponentFromTreeNode(this._applicationPanel.getApplicationNameTextField());
            this._data.setName(string);
            this._data.setDescription(this._applicationDescriptionTextArea.getText().trim());
        }

        public boolean canCreate(TraversableContext traversableContext) {
            return true;
        }

        public boolean canDelete(TraversableContext traversableContext) {
            return true;
        }

        protected Navigable createChildNavigable(Component component) {
            return this._data.createChildNavigable(component);
        }

        protected boolean removeMasterData(int n) {
            return this._data.removeMaster(n);
        }
    }

    public static final class ProjectPanel
    extends CreateDeleteDefaultTraversablePanel {
        private static final String HELP_ID = "f1_idededittemplatesproject_html";
        private final ProjectData _data;
        private final GridBagLayout _layout;
        private final ProjectDefinitionPanel _projectPanel;
        private final JLabel _defaultPackageLabel;
        private final JTextField _defaultPackageTextField;
        private final TechnologiesPanel _technologiesPanel;

        void $init$() {
            this._layout = new GridBagLayout();
            this._projectPanel = new ProjectDefinitionPanel();
            this._defaultPackageLabel = new JLabel();
            this._defaultPackageTextField = new JTextField();
            this._technologiesPanel = new TechnologiesPanel();
        }

        public ProjectPanel(ProjectData projectData) {
            super(null);
            this.$init$();
            this._data = projectData;
            this.setHelpID(HELP_ID);
            ResourceUtils.resLabel((JLabel)this._defaultPackageLabel, (Component)this._defaultPackageTextField, (String)CommandArb.getString(33));
            this.setLayout(this._layout);
            this.add(this._projectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._defaultPackageLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
            this.add(this._defaultPackageTextField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)((Object)this._technologiesPanel), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 21, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        public void onEntry(TraversableContext traversableContext) {
            super.onEntry(traversableContext);
            traversableContext.putDesignTimeObject("technologyScope", (Object)this._data.getTechnologyScope());
            this._technologiesPanel.onEntry(traversableContext);
            this.tieTextComponentToTreeNode(this._projectPanel.getNameTextField(), traversableContext);
            this._projectPanel.setTemplateName(this._data.getName());
            this._projectPanel.setProjectName(this._data.getProjectName());
            this._defaultPackageTextField.setText(this._data.getPackageName());
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            ListResourceBundle listResourceBundle;
            String string;
            super.onExit(traversableContext);
            traversableContext.putDesignTimeObject("technologyScope", (Object)new TechnologyScope(this._data.getTechnologyScope()));
            this._technologiesPanel.onExit(traversableContext);
            TechnologyScope technologyScope = (TechnologyScope)traversableContext.getDesignTimeObject("technologyScope");
            String string2 = this._projectPanel.getTemplateName();
            if (!ModelUtil.hasLength((String)string2)) {
                throw new TraversalException(CommandArb.getString(34));
            }
            if (!this._data.isUniqueProjectTemplateName(string2)) {
                String string3 = CommandArb.format(35, string2);
                throw new TraversalException(string3);
            }
            String string4 = this._projectPanel.getProjectName();
            if (!ModelUtil.hasLength((String)string4)) {
                throw new TraversalException(CommandArb.getString(36));
            }
            if (!this._data.isUniqueProjectName(string4)) {
                String string5 = CommandArb.format(37, string4);
                throw new TraversalException(string5);
            }
            URL uRL = URLFactory.newDirURL((URL)Ide.getWorkspaces().getWorkDirectory(), (String)NewApplicationDialog.removeSuffix(string4));
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)string4);
            if (string4.indexOf(File.separatorChar) != -1 || string4.indexOf(47) != -1 || !URLFileSystem.isValid((URL)uRL2)) {
                String string6 = CommandArb.format(38, string4);
                throw new TraversalException(string6);
            }
            String string7 = this._defaultPackageTextField.getText().trim();
            if (!string7.equals(string = (listResourceBundle = (ListResourceBundle)ResourceBundle.getBundle("oracle.jdeveloper.resource.ExtensionManifest")).getString("TEMPLATE_AUTO_GENERATE_DEFAULT_PACKAGE"))) {
                if (!IdeUtil.isPackageIdentifier((String)string7)) {
                    String string8 = CommandArb.format(40, string7);
                    throw new TraversalException(string8);
                }
                if (!this._data.isUniquePackageName(string7)) {
                    String string9 = CommandArb.format(39, string7);
                    throw new TraversalException(string9);
                }
            }
            this.untieTextComponentFromTreeNode(this._projectPanel.getNameTextField());
            this._data.setName(string2);
            this._data.setProjectName(string4);
            this._data.setPackageName(string7);
            this._data.setTechnologyScope((TechnologyScope)(!technologyScope.isEmpty() ? technologyScope : null));
        }

        public boolean canDelete(TraversableContext traversableContext) {
            return true;
        }

        protected boolean removeMasterData(int n) {
            return this._data.removeMaster(n);
        }
    }
}

