/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.util.ModelUtil;

final class JEWTDialogFieldValidator {
    public static final Validator EMPTY_FIELD_VALIDATOR = new 2();
    public static final Validator EMPTY_COMBOBOX_VALIDATOR = new 1();
    private JEWTDialog _dlg;
    private final Map _requiredComponents;
    private final EventAdapter _eventAdapter;

    void $init$() {
        this._requiredComponents = new HashMap();
        this._eventAdapter = new EventAdapter(null);
    }

    public JEWTDialogFieldValidator() {
        this(null);
    }

    public JEWTDialogFieldValidator(JEWTDialog jEWTDialog) {
        this.$init$();
        this.attach(jEWTDialog);
    }

    public void attach(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
        this.updateOKButton();
    }

    public void requireTextComponent(JTextComponent jTextComponent) {
        this.requireTextComponent(jTextComponent, EMPTY_FIELD_VALIDATOR);
    }

    public void requireTextComponent(JTextComponent jTextComponent, Validator validator) {
        if (jTextComponent != null) {
            if (validator == null) {
                throw new IllegalArgumentException();
            }
            this._requiredComponents.put(jTextComponent, validator);
            jTextComponent.getDocument().addDocumentListener(this._eventAdapter);
            this.updateOKButton();
        }
    }

    public void unrequireTextComponent(JTextComponent jTextComponent) {
        if (this._requiredComponents.remove(jTextComponent) != null) {
            jTextComponent.getDocument().removeDocumentListener(this._eventAdapter);
            this.updateOKButton();
        }
    }

    public void requireComboBox(JComboBox jComboBox) {
        this.requireComboBox(jComboBox, EMPTY_COMBOBOX_VALIDATOR);
    }

    public void requireComboBox(JComboBox jComboBox, Validator validator) {
        if (jComboBox != null) {
            if (validator == null) {
                throw new IllegalArgumentException();
            }
            this._requiredComponents.put(jComboBox, validator);
            jComboBox.addItemListener(this._eventAdapter);
            jComboBox.addPropertyChangeListener(this._eventAdapter);
            jComboBox.getModel().addListDataListener(this._eventAdapter);
            this.updateOKButton();
        }
    }

    public void unrequireComboBox(JComboBox jComboBox) {
        if (this._requiredComponents.remove(jComboBox) != null) {
            jComboBox.removeItemListener(this._eventAdapter);
            jComboBox.removePropertyChangeListener(this._eventAdapter);
            jComboBox.getModel().removeListDataListener(this._eventAdapter);
            this.updateOKButton();
        }
    }

    private void updateOKButton() {
        if (this._dlg != null) {
            boolean bl = true;
            for (Map.Entry entry : this._requiredComponents.entrySet()) {
                JComponent jComponent = (JComponent)entry.getKey();
                Validator validator = (Validator)entry.getValue();
                if (validator.isValid(jComponent)) continue;
                bl = false;
                break;
            }
            this._dlg.setOKButtonEnabled(bl);
        }
    }

    static void mav$updateOKButton(JEWTDialogFieldValidator jEWTDialogFieldValidator) {
        jEWTDialogFieldValidator.updateOKButton();
    }

    public interface Validator {
        public boolean isValid(JComponent var1);
    }

    static final class 2
    implements Validator {
        public boolean isValid(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            String string = jTextComponent.getText().trim();
            return ModelUtil.hasLength((String)string);
        }
    }

    static final class 1
    implements Validator {
        public boolean isValid(JComponent jComponent) {
            JComboBox jComboBox = (JComboBox)jComponent;
            return jComboBox.getModel() != null && jComboBox.getModel().getSize() != 0 && jComboBox.getSelectedItem() != null;
        }
    }

    private final class EventAdapter
    implements PropertyChangeListener,
    ListDataListener,
    ItemListener,
    DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JComboBox && propertyChangeEvent.getPropertyName().equals("model")) {
                JEWTDialogFieldValidator.mav$updateOKButton(JEWTDialogFieldValidator.this);
            }
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

