/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Workspaces;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.wizard.apptemplate.ApplicationData;
import oracle.jdeveloper.wizard.apptemplate.EditTemplatesDialog;
import oracle.jdeveloper.wizard.apptemplate.TemplatesData;
import oracle.jdeveloper.wizard.apptemplate.TemplatesXMLDataNode;

final class NewApplicationPanel
extends JPanel {
    private static final String HELP_ID = "f1_idednewapplication_html";
    private final TemplatesXMLDataNode _dataNode;
    private final NewWorkspacePanel _workspacePanel;
    private final JLabel _applicationPackageRootLabel;
    private final JTextField _applicationPackageRootTextField;
    private final JLabel _applicationTypeLabel;
    private final JComboBox _applicationTypeComboBox;
    private final JButton _editApplicationButton;
    private final JLabel _applicationDescriptionLabel;
    private final JTextArea _applicationDescriptionTextArea;
    private final JScrollPane _applicationDescriptionScrollPane;

    void $init$() {
        this._workspacePanel = new NewWorkspacePanel(false, false, true);
        this._applicationPackageRootLabel = new JLabel();
        this._applicationPackageRootTextField = new JTextField();
        this._applicationTypeLabel = new JLabel();
        this._applicationTypeComboBox = new JComboBox();
        this._editApplicationButton = new JButton();
        this._applicationDescriptionLabel = new JLabel();
        this._applicationDescriptionTextArea = new JTextArea();
        this._applicationDescriptionScrollPane = new JScrollPane();
    }

    public NewApplicationPanel() {
        this(new TemplatesXMLDataNode());
    }

    private NewApplicationPanel(TemplatesXMLDataNode templatesXMLDataNode) {
        this.$init$();
        this._dataNode = templatesXMLDataNode;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_ID);
        EventAdapter eventAdapter = new EventAdapter(null);
        this._editApplicationButton.addActionListener(eventAdapter);
        this._applicationTypeComboBox.addActionListener(eventAdapter);
        ResourceUtils.resLabel((JLabel)this._applicationPackageRootLabel, (Component)this._applicationPackageRootTextField, (String)CommandArb.getString(13));
        ResourceUtils.resLabel((JLabel)this._applicationTypeLabel, (Component)this._applicationTypeComboBox, (String)CommandArb.getString(15));
        ResourceUtils.resLabel((JLabel)this._applicationDescriptionLabel, (Component)this._applicationDescriptionTextArea, (String)CommandArb.getString(16));
        ResourceUtils.resButton((AbstractButton)this._editApplicationButton, (String)CommandArb.getString(17));
        this._workspacePanel.setFilePrompt(CommandArb.getString(12));
        this._workspacePanel.getNewFilePanel().setCanOverwriteOpenNodes(true);
        this.initFilePanel();
        this._applicationDescriptionTextArea.setRows(5);
        this._applicationDescriptionTextArea.setEditable(false);
        this._applicationDescriptionTextArea.setOpaque(false);
        this._applicationDescriptionTextArea.setLineWrap(true);
        this._applicationDescriptionTextArea.setWrapStyleWord(true);
        this._applicationDescriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this._applicationDescriptionScrollPane.setViewportView(this._applicationDescriptionTextArea);
        this.updateApplicationTypesComboBox();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._workspacePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._applicationPackageRootLabel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this._applicationPackageRootTextField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._applicationTypeLabel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this._applicationTypeComboBox, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._editApplicationButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this._applicationDescriptionLabel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this._applicationDescriptionScrollPane, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    Component getDefaultFocusComponent() {
        return this._workspacePanel.getNewFilePanel().getDefaultFocusComponent();
    }

    NewWorkspacePanel getWorkspacePanel() {
        return this._workspacePanel;
    }

    JTextField getFileField() {
        return this._workspacePanel.getNewFilePanel().getFileField();
    }

    JTextField getDirectoryField() {
        return this._workspacePanel.getNewFilePanel().getDirectoryField();
    }

    JTextField getPackageField() {
        return this._applicationPackageRootTextField;
    }

    JComboBox getApplicationTypeComboBox() {
        return this._applicationTypeComboBox;
    }

    URL getApplicationURL() {
        return this._workspacePanel.getFileURL();
    }

    String getPackageRoot() {
        return this._applicationPackageRootTextField.getText().trim();
    }

    void setPackageRoot(String string) {
        this._applicationPackageRootTextField.setText(string);
    }

    String getActiveTemplateName() {
        Object object = this._applicationTypeComboBox.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    void setActiveTemplate(int n) {
        this._applicationTypeComboBox.setSelectedIndex(n);
    }

    void setActiveTemplateName(String string) {
        if (string != null) {
            int n = 0;
            int n2 = this._applicationTypeComboBox.getItemCount();
            while (n < n2) {
                if (string.equals(this._applicationTypeComboBox.getItemAt(n).toString())) {
                    this._applicationTypeComboBox.setSelectedIndex(n);
                    return;
                }
                ++n;
            }
        }
    }

    ApplicationData getApplicationData() {
        return (ApplicationData)this._applicationTypeComboBox.getSelectedItem();
    }

    private void initFilePanel() {
        Workspaces workspaces = Ide.getWorkspaces();
        URL uRL = workspaces.getWorkDirectory();
        if (uRL == null) {
            uRL = URLFactory.newDirURL((String)Ide.getWorkDirectory());
        }
        String string = CommandArb.getString(18);
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string, null, 1);
        URL uRL2 = URLFactory.newUniqueURL((URL)uRL, (NameGenerator)defaultNameGenerator);
        NewFilePanel newFilePanel = this._workspacePanel.getNewFilePanel();
        newFilePanel.setDirectoryURL(uRL2);
        newFilePanel.setFileName(URLFileSystem.getFileName((URL)uRL2) + ".jws");
    }

    private void updateDescription() {
        ApplicationData applicationData = this.getApplicationData();
        String string = applicationData != null ? applicationData.getDescription() : "";
        this._applicationDescriptionTextArea.setText(string);
        this._applicationDescriptionTextArea.getAccessibleContext().setAccessibleDescription(string);
        this._applicationDescriptionTextArea.setCaretPosition(0);
    }

    private void updateApplicationTypesComboBox() {
        TemplatesData templatesData = this._dataNode.getTemplatesData();
        if (templatesData != null) {
            ApplicationData applicationData = null;
            ApplicationData applicationData2 = (ApplicationData)this._applicationTypeComboBox.getSelectedItem();
            if (applicationData2 != null) {
                String string = applicationData2.getName();
                ApplicationData[] applicationDataArray = templatesData.getApplicationData();
                if (applicationDataArray != null) {
                    int n = 0;
                    while (n < applicationDataArray.length) {
                        ApplicationData applicationData3 = applicationDataArray[n];
                        if (applicationData3.getName().equals(string)) {
                            applicationData = applicationData3;
                            break;
                        }
                        ++n;
                    }
                }
            }
            this._applicationTypeComboBox.setModel(templatesData.getTemplateComboBoxModel());
            if (applicationData != null) {
                this._applicationTypeComboBox.setSelectedItem(applicationData);
            }
            this.updateDescription();
        }
    }

    static JButton ra$_editApplicationButton(NewApplicationPanel newApplicationPanel) {
        return newApplicationPanel._editApplicationButton;
    }

    static TemplatesXMLDataNode ra$_dataNode(NewApplicationPanel newApplicationPanel) {
        return newApplicationPanel._dataNode;
    }

    static void mav$updateApplicationTypesComboBox(NewApplicationPanel newApplicationPanel) {
        newApplicationPanel.updateApplicationTypesComboBox();
    }

    static JComboBox ra$_applicationTypeComboBox(NewApplicationPanel newApplicationPanel) {
        return newApplicationPanel._applicationTypeComboBox;
    }

    static void mav$updateDescription(NewApplicationPanel newApplicationPanel) {
        newApplicationPanel.updateDescription();
    }

    private final class EventAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == NewApplicationPanel.ra$_editApplicationButton(NewApplicationPanel.this)) {
                if (EditTemplatesDialog.showDialog(NewApplicationPanel.this, NewApplicationPanel.ra$_dataNode(NewApplicationPanel.this))) {
                    ApplicationData applicationData = NewApplicationPanel.ra$_dataNode(NewApplicationPanel.this).getSelectedApp();
                    NewApplicationPanel.mav$updateApplicationTypesComboBox(NewApplicationPanel.this);
                    if (applicationData != null) {
                        NewApplicationPanel.ra$_applicationTypeComboBox(NewApplicationPanel.this).setSelectedItem(applicationData);
                    }
                }
            } else if (object == NewApplicationPanel.ra$_applicationTypeComboBox(NewApplicationPanel.this)) {
                NewApplicationPanel.mav$updateDescription(NewApplicationPanel.this);
            }
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

