/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.wizard.apptemplate.DefinitionPanel;
import oracle.jdeveloper.wizard.apptemplate.NewApplicationDialog;

final class ProjectDefinitionPanel
extends DefinitionPanel
implements FocusListener {
    private static final String HELP_ID = "f1_idednewprojecttemplate_html";
    private final GridBagLayout _layout;
    private final JLabel _nameLabel;
    private final JTextField _nameTextField;
    private final JLabel _projectNameLabel;
    private final JTextField _projectNameTextField;

    void $init$() {
        this._layout = new GridBagLayout();
        this._nameLabel = new JLabel();
        this._nameTextField = new JTextField();
        this._projectNameLabel = new JLabel();
        this._projectNameTextField = new JTextField();
    }

    public ProjectDefinitionPanel() {
        this.$init$();
        this._projectNameTextField.addFocusListener(this);
        this.requireTextComponent(this._nameTextField);
        this.requireTextComponent(this._projectNameTextField);
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameTextField, (String)CommandArb.getString(31));
        ResourceUtils.resLabel((JLabel)this._projectNameLabel, (Component)this._projectNameTextField, (String)CommandArb.getString(32));
        this.setLayout(this._layout);
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this._nameTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._projectNameLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this._projectNameTextField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    boolean showDialog(Component component) {
        boolean bl = super.showDialog(component);
        this.ensureProjectSuffix();
        return bl;
    }

    String getTitle() {
        return CommandArb.getString(21);
    }

    JTextField getNameTextField() {
        return this._nameTextField;
    }

    Component getDefaultFocusComponent() {
        return this.getNameTextField();
    }

    String getHelpID() {
        return HELP_ID;
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this._projectNameTextField) {
            this.ensureProjectSuffix();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    String getTemplateName() {
        return this._nameTextField.getText().trim();
    }

    void setTemplateName(String string) {
        this._nameTextField.setText(string);
    }

    String getProjectName() {
        return this._projectNameTextField.getText().trim();
    }

    void setProjectName(String string) {
        this._projectNameTextField.setText(string);
    }

    private void ensureProjectSuffix() {
        String string = this.getProjectName();
        if (ModelUtil.hasLength((String)string)) {
            this.unrequireTextComponent(this._projectNameTextField);
            this.setProjectName(NewApplicationDialog.ensureSuffix(string, ".jpr"));
            this.requireTextComponent(this._projectNameTextField);
        }
    }
}

