/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.wizard.apptemplate.ApplicationData;
import oracle.jdeveloper.wizard.apptemplate.ApplicationDefinitionPanel;
import oracle.jdeveloper.wizard.apptemplate.EditTemplatesPanel;

public class TemplatesData
implements Copyable {
    private String _name;
    private ApplicationData[] _applicationData;

    public Object copyTo(Object object) {
        TemplatesData templatesData = object != null ? (TemplatesData)object : new TemplatesData();
        this.copyToImpl(templatesData);
        return templatesData;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public ApplicationData[] getApplicationData() {
        return this._applicationData;
    }

    public void setApplicationData(ApplicationData[] applicationDataArray) {
        if (applicationDataArray != null) {
            int n = 0;
            while (n < applicationDataArray.length) {
                applicationDataArray[n].setMaster(this);
                ++n;
            }
        }
        this._applicationData = applicationDataArray;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.equalsImpl((TemplatesData)object);
    }

    protected final boolean equalsImpl(TemplatesData templatesData) {
        return ModelUtil.areEqual((Object)this._name, (Object)templatesData._name) && Arrays.equals(this._applicationData, templatesData._applicationData);
    }

    protected final void copyToImpl(TemplatesData templatesData) {
        templatesData._name = this._name;
        if (this._applicationData != null) {
            int n = this._applicationData.length;
            ApplicationData[] applicationDataArray = new ApplicationData[n];
            int n2 = n;
            while (n2-- > 0) {
                ApplicationData applicationData = this._applicationData[n2];
                ApplicationData applicationData2 = applicationDataArray[n2] = applicationData != null ? (ApplicationData)applicationData.copyTo(null) : null;
            }
            templatesData.setApplicationData(applicationDataArray);
        } else {
            templatesData._applicationData = null;
        }
    }

    Navigable createNavigable() {
        Navigable[] navigableArray;
        if (this._applicationData != null) {
            int n = this._applicationData.length;
            navigableArray = new Navigable[n];
            int n2 = 0;
            while (n2 < n) {
                navigableArray[n2] = this._applicationData[n2].createNavigable();
                ++n2;
            }
        } else {
            navigableArray = null;
        }
        return new Navigable(this._name, EditTemplatesPanel.TemplatesPanel.class, new Class[]{TemplatesData.class}, new Object[]{this}, navigableArray);
    }

    Navigable createChildNavigable(Component component) {
        ApplicationDefinitionPanel applicationDefinitionPanel = new ApplicationDefinitionPanel();
        if (!applicationDefinitionPanel.showDialog(component)) {
            return null;
        }
        ApplicationData applicationData = new ApplicationData();
        applicationData.setName(applicationDefinitionPanel.getTemplateName());
        applicationData.setMaster(this);
        this.add(applicationData);
        return applicationData.createNavigable();
    }

    boolean add(ApplicationData applicationData) {
        int n;
        if (applicationData == null) {
            return false;
        }
        int n2 = n = this._applicationData != null ? this._applicationData.length : 0;
        if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                ApplicationData applicationData2 = this._applicationData[n3];
                if (applicationData.getName().equals(applicationData2.getName()) || applicationData.equals(applicationData2)) {
                    return false;
                }
                ++n3;
            }
        }
        ApplicationData[] applicationDataArray = new ApplicationData[n + 1];
        if (this._applicationData != null) {
            System.arraycopy(this._applicationData, 0, applicationDataArray, 0, n);
        }
        this._applicationData = applicationDataArray;
        applicationDataArray[n] = applicationData;
        return true;
    }

    boolean remove(int n) {
        int n2;
        int n3 = n2 = this._applicationData != null ? this._applicationData.length : 0;
        if (n >= n2) {
            return false;
        }
        if (n2 <= 1) {
            this._applicationData = null;
            return true;
        }
        ApplicationData[] applicationDataArray = new ApplicationData[n2 - 1];
        if (n > 0) {
            System.arraycopy(this._applicationData, 0, applicationDataArray, 0, n);
        }
        System.arraycopy(this._applicationData, n + 1, applicationDataArray, n, n2 - n - 1);
        this._applicationData = applicationDataArray;
        return true;
    }

    ComboBoxModel getTemplateComboBoxModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator((Comparator)ObjectComparator.INSTANCE);
        if (this._applicationData != null) {
            int n = 0;
            while (n < this._applicationData.length) {
                sortedComboBoxModel.addElement((Object)this._applicationData[n]);
                ++n;
            }
        }
        return sortedComboBoxModel;
    }

    private static final class ObjectComparator
    implements Comparator {
        public static final ObjectComparator INSTANCE = new ObjectComparator();

        private ObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Comparable && object2 instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
            return object.toString().compareTo(object2.toString());
        }
    }
}

