/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessSpawner {
    private static final int PROCESS_WAIT_DELAY_MS = 10;
    private static final int PROCESS_READ_DELAY_MS = 5;
    private static final int PROCESS_OUTPUT_BUFSIZE = 5012;
    private char[] buf;
    private StringBuffer ob;
    private StringBuffer eb;
    private Process ps;

    void $init$() {
        this.buf = new char[5012];
        this.ob = new StringBuffer(this.buf.length);
        this.eb = new StringBuffer(this.buf.length);
    }

    public int exec(String string) throws IOException, InterruptedException {
        return this.displayProcessOutput(Runtime.getRuntime().exec(string));
    }

    public int exec(String string, String[] stringArray) throws IOException, InterruptedException {
        return this.displayProcessOutput(Runtime.getRuntime().exec(string, stringArray));
    }

    public int exec(String[] stringArray) throws IOException, InterruptedException {
        return this.displayProcessOutput(Runtime.getRuntime().exec(stringArray));
    }

    private int displayProcessOutput(Process process) throws IOException, InterruptedException {
        this.ps = process;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while (true) {
            ProcessSpawner.sleep(10);
            if (bufferedReader.ready()) {
                this.printAvailOut(bufferedReader);
                continue;
            }
            if (bufferedReader2.ready()) {
                this.printAvailErr(bufferedReader2);
                continue;
            }
            try {
                int n = process.exitValue();
                this.printAvailOut(bufferedReader);
                this.printAvailErr(bufferedReader2);
                int n2 = n;
                return n2;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
    }

    private void printAvailOut(BufferedReader bufferedReader) throws IOException {
        int n;
        while (bufferedReader.ready() && (n = bufferedReader.read(this.buf, 0, this.buf.length)) > 0) {
            this.ob.append(this.buf, 0, n);
            ProcessSpawner.sleep(5);
        }
    }

    private void printAvailErr(BufferedReader bufferedReader) throws IOException {
        int n;
        while (bufferedReader.ready() && (n = bufferedReader.read(this.buf, 0, this.buf.length)) > 0) {
            this.eb.append(this.buf, 0, n);
            ProcessSpawner.sleep(5);
        }
    }

    public StringBuffer getOutputBuffer() {
        return this.ob;
    }

    public StringBuffer getErrorBuffer() {
        return this.eb;
    }

    public Process getProcess() {
        return this.ps;
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProcessSpawner() {
        this.$init$();
    }
}

