/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.common;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;

public class WizardFile {
    private String className;
    private String packageName;
    private String basePath;
    private static final String TRACE_CATEGORY = "oracle.jdeveloper.wizard.common";

    public WizardFile() {
        this(null, null, null);
    }

    public WizardFile(String string, String string2, String string3) {
        this.className = string;
        this.packageName = string2;
        this.basePath = string3;
    }

    public boolean isValid() {
        if (this.basePath == null || this.basePath.length() == 0) {
            return false;
        }
        return this.isClassNameValid() && this.isPackageNameValid();
    }

    public boolean isClassNameValid() {
        return this.isClassNameValid(false);
    }

    public boolean isClassNameValid(boolean bl) {
        if (this.className != null) {
            return bl ? Jot2Utils.isValidClassName(this.className) : Jot2Utils.isValidIdentifier(this.className);
        }
        return false;
    }

    public static boolean isClassNameValid(String string) {
        return WizardFile.isClassNameValid(string, false);
    }

    public static boolean isClassNameValid(String string, boolean bl) {
        if (string != null) {
            return bl ? Jot2Utils.isValidClassName(string) : Jot2Utils.isValidIdentifier(string);
        }
        return false;
    }

    public boolean isPackageNameValid() {
        if (this.packageName == null || this.packageName.length() == 0) {
            return true;
        }
        return Jot2Utils.isValidClassName(this.packageName);
    }

    public static boolean isPackageNameValid(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return Jot2Utils.isValidClassName(string);
    }

    public boolean fileExists() {
        File file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public boolean classExistsInProject(Project project) {
        String string = this.getFullPath();
        URL uRL = URLFactory.newFileURL((String)string);
        Node node = NodeFactory.findInFolder((Folder)project, (URL)uRL);
        if (node != null) {
            JavaFile javaFile;
            JavaManager javaManager = JavaManager.getJavaManager(project);
            JavaFile javaFile2 = javaFile = javaManager != null ? javaManager.getFile(node.getURL()) : null;
            if (javaFile != null) {
                Iterator iterator = javaFile.getClasses().iterator();
                String string2 = this.getQualifiedClassName().toLowerCase();
                while (iterator.hasNext()) {
                    JavaClass javaClass = (JavaClass)iterator.next();
                    if (javaClass == null || !javaClass.getName().toLowerCase().equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public JavaSourceNode getSourceNode(Project project) {
        String string = this.getFullPath();
        URL uRL = URLFactory.newFileURL((String)string);
        Node node = NodeFactory.findInFolder((Folder)project, (URL)uRL);
        if (node == null) {
            node = WizardFile.createNodeInProject(project, uRL);
        }
        return (JavaSourceNode)node;
    }

    public void setDefaultClassName(Project project, String string, String string2) {
        String string3 = this.basePath;
        if (this.packageName != null && this.packageName.length() > 0) {
            string3 = string3 + File.separator + this.packageName.replace('.', File.separatorChar);
        }
        this.className = string;
        this.className = this.className + WizardFile.getUniqueFileNameID(project, string3, this.className, string2);
    }

    public void setDefaultClassName(Project project, String string) {
        this.setDefaultClassName(project, string, ".java");
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedClassName() {
        if (this.packageName != null && this.packageName.length() > 0) {
            return this.packageName + "." + this.className;
        }
        return this.className;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getFullPath() {
        if (this.basePath == null || this.className == null) {
            return null;
        }
        String string = this.basePath;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            string = string + this.packageName.replace('.', File.separatorChar) + File.separator;
        }
        string = string + this.className + ".java";
        return string;
    }

    public File getFile() {
        String string = this.getFullPath();
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public boolean verifyFilePath() {
        File file = this.getFile();
        if (file == null) {
            return false;
        }
        File file2 = new File(file.getParent());
        return file2 == null || file2.exists() || file2.mkdirs();
    }

    public String toString() {
        String string = "WizardFile: basePath = " + this.basePath + "; packageName = " + this.packageName + "; className = " + this.className;
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof WizardFile) {
            WizardFile wizardFile = (WizardFile)object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            bl = this.className == null ? wizardFile.getClassName() == null : this.className.equals(wizardFile.getClassName());
            bl2 = this.packageName == null ? wizardFile.getPackageName() == null : this.packageName.equals(wizardFile.getPackageName());
            bl3 = this.basePath == null ? wizardFile.getBasePath() == null : this.basePath.equals(wizardFile.getBasePath());
            return bl && bl2 && bl3;
        }
        return false;
    }

    private static final Node createNodeInProject(Project project, URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node != null) {
                project.add(node, PathsConfiguration.JAVA_CONTENT_SET_KEY);
            }
            Node node2 = node;
            return node2;
        }
        catch (Exception exception) {
            Node node = null;
            return node;
        }
    }

    private static final int getUniqueFileNameID(Project project, String string, String string2, String string3) {
        int n = 1;
        while (n < 1000) {
            File file = new File(string, string2 + n + string3);
            if (NodeFactory.findInFolder((Folder)project, (URL)URLFactory.newFileURL((String)file.getPath())) == null && !file.exists()) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

