/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.tree.TreeMouseClickHandler;
import oracle.jdeveloper.wizard.method.MethodTreeNode;
import oracle.jdeveloper.wizard.method.MethodsTreeModel;
import oracle.jdeveloper.wizard.method.Res;

class ClassTreeNode
extends DefaultMutableTreeNode
implements TreeMouseClickHandler {
    private static List collectedAbstractMethods = new ArrayList();
    private boolean childrenLoaded;
    private JavaClass cls;
    private ClassTreeNode parent;
    private MethodsTreeModel mdl;
    private List childNodes;

    ClassTreeNode(JavaClass javaClass, ClassTreeNode classTreeNode, MethodsTreeModel methodsTreeModel) {
        this.cls = javaClass;
        this.parent = classTreeNode;
        this.mdl = methodsTreeModel;
        this.setAllowsChildren(true);
    }

    public void setModel(MethodsTreeModel methodsTreeModel) {
        this.mdl = methodsTreeModel;
    }

    public JavaClass getJavaClass() {
        return this.cls;
    }

    public boolean isInterface() {
        return this.cls.isInterface();
    }

    public boolean containsMatchingMethod(JavaMethod javaMethod) {
        boolean bl = false;
        JavaMethod javaMethod2 = null;
        try {
            Collection collection = this.cls.getDeclaredMethods(javaMethod.getName());
            String string = this.getErasureTypeName(javaMethod);
            for (JavaMethod javaMethod3 : collection) {
                String string2 = this.getErasureTypeName(javaMethod3);
                if (!string.equals(string2)) continue;
                javaMethod2 = javaMethod3;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaMethod2 != null || !(this.parent != null ? !this.parent.containsMatchingMethod(javaMethod) : !false);
    }

    private String getErasureTypeName(JavaMethod javaMethod) {
        String string;
        Collection collection = javaMethod.getParameters();
        if (collection.isEmpty()) {
            string = javaMethod.getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer(javaMethod.getName());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(',');
                JavaVariable javaVariable = (JavaVariable)iterator.next();
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType == null) continue;
                JavaClass javaClass = javaType.getTypeErasure();
                if (javaClass == null) {
                    stringBuffer.append("java.lang.Object");
                    continue;
                }
                String string2 = javaClass.getQualifiedName();
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        String string = null;
        string = this.parent == null ? Res.getString(7) : this.cls.getQualifiedName();
        return string;
    }

    public String getPackage() {
        return this.cls.getPackageName();
    }

    public TreePath getExpansionPath() {
        return new TreePath(this.getPath());
    }

    public Object getUserObject() {
        return this.toString();
    }

    public void setSelected(boolean bl) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ((MethodTreeNode)enumeration.nextElement()).setSelected(bl);
        }
    }

    public int getSelectedChildCount() {
        int n = 0;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            if (!((MethodTreeNode)enumeration.nextElement()).isSelected()) continue;
            ++n;
        }
        return n;
    }

    public boolean isSelected() {
        return this.getChildCount() == this.getSelectedChildCount();
    }

    public void handleMouseClick() {
        this.setSelected(this.isSelected() ^ true);
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public void loadChildren(DefaultTreeModel defaultTreeModel) {
        if (!this.childrenLoaded) {
            collectedAbstractMethods.clear();
            List list = this.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.add((MutableTreeNode)iterator.next());
            }
            this.childrenLoaded = true;
            defaultTreeModel.reload(this);
        }
    }

    public List getChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList();
        }
        return this.childNodes;
    }

    private List getChildren() {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        if (this.parent == null) {
            ClassTreeNode classTreeNode = this;
            JavaType javaType = this.cls.getSuperclass();
            while (javaType != null) {
                JavaClass javaClass = javaType.getTypeErasure();
                if (javaClass == null) {
                    String string = Res.format(18, javaType.getName());
                    1 var6_7 = new 1(this, string);
                    if (EventQueue.isDispatchThread()) {
                        var6_7.run();
                        break;
                    }
                    try {
                        SwingUtilities.invokeAndWait(var6_7);
                    }
                    catch (Exception exception) {}
                    break;
                }
                List list = (classTreeNode = new ClassTreeNode(javaClass, classTreeNode, this.mdl)).getChildren();
                if (list.size() != 0) {
                    classTreeNode.addChildren(list);
                    classTreeNode.setChildNodes(list);
                    classTreeNode.childrenLoaded = true;
                    arrayList.add(classTreeNode);
                }
                javaType = javaClass.getSuperclass();
            }
            this.addInterfaces(this.cls, classTreeNode, arrayList);
        } else {
            for (JavaMethod javaMethod : this.cls.getDeclaredMethods()) {
                MethodTreeNode methodTreeNode;
                int n = javaMethod.getModifiers();
                if (Modifier.isFinal(n) || Modifier.isPrivate(n) || Modifier.isStatic(n) || this.parent.containsMatchingMethod(javaMethod) || !Modifier.isProtected(n) && !Modifier.isPublic(n) && !this.getPackage().equals(((ClassTreeNode)this.mdl.getRoot()).getPackage())) continue;
                if (Modifier.isAbstract(n)) {
                    String string = this.getMethodSignature(javaMethod);
                    if (collectedAbstractMethods.contains(string)) continue;
                    collectedAbstractMethods.add(string);
                }
                if (arrayList.contains(methodTreeNode = new MethodTreeNode(javaMethod, this, this.mdl))) continue;
                arrayList.add(methodTreeNode);
            }
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    private String getMethodSignature(JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(javaMethod.getReturnType().getName());
        stringBuffer.append(javaMethod.getName());
        JavaType[] javaTypeArray = javaMethod.getParameterTypes();
        int n = 0;
        while (n < javaTypeArray.length) {
            if (javaTypeArray[n] != null) {
                stringBuffer.append(javaTypeArray[n].getName());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void addInterfaces(JavaClass javaClass, ClassTreeNode classTreeNode, List list) {
        for (JavaType javaType : javaClass.getInterfaces()) {
            ClassTreeNode classTreeNode2;
            List list2;
            JavaClass javaClass2 = javaType.getTypeErasure();
            if (javaClass2 != null && (list2 = (classTreeNode2 = new ClassTreeNode(javaClass2, classTreeNode, this.mdl)).getChildren()).size() != 0) {
                classTreeNode2.addChildren(list2);
                classTreeNode2.setChildNodes(list2);
                classTreeNode2.childrenLoaded = true;
                list.add(classTreeNode2);
            }
            this.addInterfaces(javaClass2, classTreeNode, list);
        }
        JavaType javaType = javaClass.getSuperclass();
        if (javaType != null) {
            JavaClass javaClass3 = javaType.getTypeErasure();
            this.addInterfaces(javaClass3, classTreeNode, list);
        }
    }

    private void addChildren(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add((MutableTreeNode)iterator.next());
        }
    }

    private void setChildNodes(List list) {
        this.childNodes = list;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ ClassTreeNode this$0;

        public void run() {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.v$msg, (String)Res.getString(16), null);
        }

        public 1(ClassTreeNode classTreeNode, String string) {
            this.v$msg = string;
            this.this$0 = classTreeNode;
        }
    }
}

