/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.jdeveloper.tree.TreeMouseClickHandler;
import oracle.jdeveloper.wizard.method.ClassTreeNode;
import oracle.jdeveloper.wizard.method.MethodsTreeModel;

class MethodTreeNode
extends DefaultMutableTreeNode
implements Comparable,
TreeMouseClickHandler {
    private int mods;
    private boolean selected;
    private JavaMethod mthd;
    private ClassTreeNode parent;
    private MethodsTreeModel model;
    private String nodeText;

    MethodTreeNode(JavaMethod javaMethod, ClassTreeNode classTreeNode, MethodsTreeModel methodsTreeModel) {
        this.mthd = javaMethod;
        this.parent = classTreeNode;
        this.model = methodsTreeModel;
        this.mods = javaMethod.getModifiers();
        this.setAllowsChildren(false);
    }

    public String toString() {
        return this.mthd.getName();
    }

    public JavaMethod getJavaMethod() {
        return this.mthd;
    }

    public String getSignature() {
        if (this.nodeText == null) {
            StringBuffer stringBuffer = new StringBuffer(this.mthd.getName());
            Collection collection = this.mthd.getParameters();
            if (collection.isEmpty()) {
                stringBuffer.append("()");
            } else {
                int n = 40;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((char)n);
                    JavaVariable javaVariable = (JavaVariable)iterator.next();
                    JavaType javaType = javaVariable.getResolvedType();
                    if (javaType == null) {
                        UnresolvedType unresolvedType = javaVariable.getUnresolvedType();
                        stringBuffer.append(unresolvedType.getSimplifiedName());
                    } else if (javaType.getPackageName().equals("java.lang")) {
                        stringBuffer.append(javaType.getName());
                    } else {
                        stringBuffer.append(javaType.getQualifiedName());
                    }
                    n = 44;
                }
                stringBuffer.append(')');
            }
            JavaType javaType = this.mthd.getReturnType();
            stringBuffer.append(" : ");
            if (javaType != null) {
                if (javaType.getPackageName().equals("java.lang")) {
                    stringBuffer.append(javaType.getName());
                } else {
                    stringBuffer.append(javaType.getTypeErasure().getQualifiedName());
                }
            } else {
                stringBuffer.append("Unknown Type");
            }
            this.nodeText = stringBuffer.toString();
        }
        return this.nodeText;
    }

    public int compareTo(Object object) {
        MethodTreeNode methodTreeNode = (MethodTreeNode)object;
        this.getSignature();
        methodTreeNode.getSignature();
        String string = this.nodeText;
        String string2 = methodTreeNode.nodeText;
        return string.compareToIgnoreCase(string2);
    }

    public Object getUserObject() {
        return this.mthd;
    }

    public String getToolTipText() {
        return this.mthd.toString();
    }

    public void handleMouseClick() {
        this.setSelected(this.isSelected() ^ true);
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            if (bl) {
                this.model.addSelectedNode(this);
            } else {
                this.model.removeSelectedNode(this);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.mods);
    }

    public int getModifier() {
        return this.mods;
    }
}

