/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.java.legacy.JotNames;

public class MethodUtils {
    private MethodUtils() {
    }

    public static SourceMethod generateMethod(JavaMethod javaMethod, SourceClass sourceClass, boolean bl) {
        String string;
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        SourceFactory sourceFactory = sourceFile.getFactory();
        Collection collection = javaMethod.getParameters();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        SourceLocalVariable[] sourceLocalVariableArray = new SourceLocalVariable[collection.size()];
        if (!collection.isEmpty()) {
            int n = 0;
            for (JavaVariable javaVariable : collection) {
                String string2;
                if (javaVariable instanceof CompiledTmpVariable) continue;
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType == null) {
                    string2 = javaVariable.getUnresolvedType().getSimplifiedName();
                } else {
                    MethodUtils.addImport(javaType, sourceFile);
                    string2 = MethodUtils.getNameForType(javaType);
                }
                SourceTypeReference sourceTypeReference = sourceFactory.createType(string2);
                String string3 = MethodUtils.getParameterName(javaVariable, arrayList);
                arrayList.add(string3);
                SourceLocalVariable sourceLocalVariable = sourceFactory.createLocalVariable(sourceTypeReference, string3);
                sourceLocalVariableArray[n++] = sourceLocalVariable;
                MethodUtils.addTypeParameters(sourceFactory, javaType, sourceTypeReference);
            }
        }
        Collection collection2 = javaMethod.getExceptions();
        SourceTypeReference[] sourceTypeReferenceArray = new SourceTypeReference[collection2.size()];
        if (!collection2.isEmpty()) {
            int n = 0;
            for (JavaType javaType : collection2) {
                SourceTypeReference sourceTypeReference = sourceFactory.createType(javaType.getQualifiedName());
                sourceTypeReferenceArray[n++] = sourceTypeReference;
                MethodUtils.addImport(javaType, sourceFile);
            }
        }
        SourceBlock sourceBlock = sourceFactory.createBlock();
        int n = javaMethod.getModifiers();
        boolean bl2 = Modifier.isAbstract(n);
        JavaType javaType = javaMethod.getReturnType();
        if (javaType != null) {
            string = MethodUtils.getNameForType(javaType);
            MethodUtils.addImport(javaType, sourceFile);
        } else {
            string = javaMethod.getUnresolvedType().getSimplifiedName();
        }
        boolean bl3 = "void".equals(string);
        if (bl2) {
            if (!bl3) {
                SourceExpression sourceExpression = MethodUtils.getDefaultInitializer(sourceFactory, javaType);
                SourceReturnStatement sourceReturnStatement = sourceFactory.createReturnStatement(sourceExpression);
                sourceReturnStatement.addSelf((SourceElement)sourceBlock);
            }
        } else {
            SourceExpression sourceExpression = sourceFactory.createExpression("super");
            SourceExpression[] sourceExpressionArray = new SourceExpression[arrayList.size()];
            int n2 = 0;
            while (n2 < arrayList.size()) {
                sourceExpressionArray[n2] = sourceFactory.createExpression((String)arrayList.get(n2));
                ++n2;
            }
            SourceListExpression sourceListExpression = sourceFactory.createArgumentList(sourceExpressionArray);
            SourceMethodCallExpression sourceMethodCallExpression = sourceFactory.createMethodCall(sourceExpression, javaMethod.getName(), sourceListExpression);
            if (bl3) {
                SourceExpressionStatement sourceExpressionStatement = sourceFactory.createExpressionStatement((SourceExpression)sourceMethodCallExpression);
                sourceExpressionStatement.addSelf((SourceElement)sourceBlock);
            } else {
                SourceReturnStatement sourceReturnStatement = sourceFactory.createReturnStatement((SourceExpression)sourceMethodCallExpression);
                sourceReturnStatement.addSelf((SourceElement)sourceBlock);
            }
        }
        SourceTypeReference sourceTypeReference = sourceFactory.createType(string);
        String string4 = javaMethod.getName();
        SourceFormalParameterList sourceFormalParameterList = sourceFactory.createFormalParameterList(sourceLocalVariableArray);
        SourceThrowsClause sourceThrowsClause = sourceFactory.createThrowsClause(sourceTypeReferenceArray);
        SourceMethod sourceMethod = sourceFactory.createMethod(sourceTypeReference, string4, sourceFormalParameterList, sourceThrowsClause, sourceBlock);
        sourceMethod.setModifiers(n & 0xFFFFFAFF);
        SourceClass sourceClass2 = (SourceClass)sourceClass.getSourceElement();
        sourceMethod.addSelf((SourceElement)sourceClass2.getSourceBody());
        if (bl) {
            try {
                SourceElement sourceElement = javaMethod.getOwningClass().getSourceElement();
                if (sourceElement instanceof SourceClass) {
                    SourceClass sourceClass3 = (SourceClass)sourceElement;
                    JavaMethod javaMethod2 = sourceClass3.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
                    SourceMethod sourceMethod2 = (SourceMethod)javaMethod2;
                    SourceDocComment sourceDocComment = (SourceDocComment)sourceMethod2.getDocComment().cloneSelf(sourceFile);
                    sourceDocComment.addSelf((SourceElement)sourceMethod);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sourceMethod;
    }

    public static void narrowImports(SourceFile sourceFile) {
        sourceFile.compile();
        List list = sourceFile.getSourceImports();
        ArrayList<SourceImport> arrayList = new ArrayList<SourceImport>();
        for (SourceImport sourceImport : list) {
            if (sourceImport.isUsed()) continue;
            arrayList.add(sourceImport);
        }
        list.removeAll(arrayList);
    }

    private static String getParameterName(JavaVariable javaVariable, List list) {
        String string;
        SourceVariable sourceVariable = (SourceVariable)javaVariable.getSourceElement();
        String string2 = sourceVariable != null ? ((string = sourceVariable.getName()).length() == 0 ? MethodUtils.getDefaultParamName(javaVariable) : string) : MethodUtils.getDefaultParamName(javaVariable);
        if (list.contains(string2)) {
            int n = 1;
            int n2 = string2.length();
            String string3 = Character.isDigit(string2.charAt(n2 - 1)) ? string2 + "_" : string2;
            String string4 = string2 + n;
            while (list.contains(string4)) {
                string4 = string3 + 1;
            }
            return string4;
        }
        return string2;
    }

    private static String getDefaultParamName(JavaVariable javaVariable) {
        String string;
        String string2;
        JavaType javaType = javaVariable.getResolvedType();
        if (javaType == null) {
            String string3 = javaVariable.getUnresolvedType().getSimplifiedName();
            string2 = MethodUtils.shortenParamName(string3);
        } else {
            int n;
            String string4 = javaType.getTypeErasure().getQualifiedName();
            String string5 = MethodUtils.shortenParamName(string4);
            string2 = javaType.isPrimitive() ? string5.substring(0, 1) : (javaType.isArray() ? ((n = string5.indexOf("[")) != -1 ? string5.substring(0, n) : string5.substring(0, 1)) : string5);
        }
        if (JotNames.isValidIdentifier(string2)) {
            return string2;
        }
        if (string2.length() > 1 && JotNames.isValidIdentifier(string = string2.substring(0, 1))) {
            return string;
        }
        return "param";
    }

    private static String shortenParamName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    private static SourceImport addImport(JavaType javaType, SourceFile sourceFile) {
        JavaType javaType2;
        if (javaType == null || javaType instanceof JavaTypeVariable || javaType instanceof JavaWildcardType) {
            return null;
        }
        if (!javaType.isArray()) {
            javaType2 = javaType;
        } else {
            JavaType javaType3 = javaType;
            while (javaType3.isArray()) {
                javaType3 = javaType3.getComponentType();
            }
            javaType2 = javaType3;
        }
        if (javaType2.isPrimitive()) {
            return null;
        }
        String string = "";
        String string2 = javaType2.getTypeErasure().getQualifiedName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && (string = string2.substring(0, n)).equals("java.lang")) {
            return null;
        }
        if (string.equals(sourceFile.getPackageName())) {
            return null;
        }
        int n2 = 0;
        List list = sourceFile.getSourceImports();
        if (!list.isEmpty()) {
            int n3 = 0;
            int n4 = list.size();
            while (n3 < n4) {
                SourceImport sourceImport = (SourceImport)list.get(n3);
                if (!sourceImport.isStatic()) {
                    String string3 = sourceImport.getName();
                    if (string3.endsWith(".*") ? (string3 = string3.substring(0, string3.length() - 2)).equals(string) : string3.equals(string2)) {
                        return null;
                    }
                    if (string2.compareTo(string3) > 0) {
                        n2 = n3 + 1;
                    }
                }
                ++n3;
            }
        }
        SourceImport sourceImport = sourceFile.getFactory().createImportDeclaration(string2);
        list.add(n2, sourceImport);
        return sourceImport;
    }

    private static void addTypeParameters(SourceFactory sourceFactory, JavaType javaType, SourceTypeReference sourceTypeReference) {
        if (javaType == null) {
            return;
        }
        Collection collection = javaType.getActualTypeArguments();
        if (collection.size() > 0) {
            for (JavaType javaType2 : collection) {
                if (javaType2 instanceof JavaTypeVariable || javaType2 instanceof JavaWildcardType) continue;
                SourceTypeReference sourceTypeReference2 = sourceFactory.createType(javaType2.getQualifiedName());
                SourceTypeArgument sourceTypeArgument = sourceFactory.createTypeArgument(0, sourceTypeReference2);
                sourceTypeArgument.addSelf((SourceElement)sourceTypeReference);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SourceExpression getDefaultInitializer(SourceFactory sourceFactory, JavaType javaType) {
        String string;
        if (javaType == null) {
            string = "null";
            return sourceFactory.createExpression(string);
        } else if (javaType.isPrimitive()) {
            if (javaType.getName().equals("boolean")) {
                string = "false";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("byte")) {
                string = "0";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("char")) {
                string = "0";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("short")) {
                string = "0";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("int")) {
                string = "0";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("long")) {
                string = "0l";
                return sourceFactory.createExpression(string);
            } else if (javaType.getName().equals("float")) {
                string = "0.0f";
                return sourceFactory.createExpression(string);
            } else {
                if (!javaType.getName().equals("double")) throw new IllegalArgumentException();
                string = "0.0";
            }
            return sourceFactory.createExpression(string);
        } else {
            string = javaType.isArray() ? "new " + MethodUtils.getNameForReturn(javaType.getComponentType()) + "[0]" : ("java.util.List".equals(javaType.getQualifiedName()) ? "java.util.Collections.EMPTY_LIST" : ("java.util.Set".equals(javaType.getQualifiedName()) ? "java.util.Collections.EMPTY_SET" : ("java.util.Map".equals(javaType.getQualifiedName()) ? "java.util.Collections.EMPTY_MAP" : "null")));
        }
        return sourceFactory.createExpression(string);
    }

    private static String getNameForReturn(JavaType javaType) {
        if (javaType.isArray()) {
            return MethodUtils.getNameForReturn(javaType.getComponentType()) + "[0]";
        }
        return javaType.getTypeErasure().getName();
    }

    private static String getNameForType(JavaType javaType) {
        String string = "";
        JavaType javaType2 = javaType;
        while (javaType2.isArray()) {
            javaType2 = javaType2.getComponentType();
            string = string + "[]";
        }
        return javaType2.getTypeErasure().getQualifiedName() + string;
    }
}

