/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.jdeveloper.wizard.method.ClassTreeNode;
import oracle.jdeveloper.wizard.method.MethodTreeNode;

class MethodsTreeModel
extends DefaultTreeModel {
    private boolean loaded;
    private boolean grouped;
    private List nodes;
    private Vector selection;

    MethodsTreeModel(ClassTreeNode classTreeNode) {
        super(classTreeNode, true);
    }

    public void loadModel(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.isLoaded();
        if (!this.isLoaded()) {
            ClassTreeNode classTreeNode = (ClassTreeNode)this.getRoot();
            classTreeNode.loadChildren(this);
            this.storeNodes(classTreeNode);
            this.loaded = true;
        }
        if (bl != this.grouped || !bl && bl2) {
            ClassTreeNode classTreeNode = (ClassTreeNode)this.getRoot();
            classTreeNode.removeAllChildren();
            ArrayList arrayList = new ArrayList();
            for (ClassTreeNode classTreeNode2 : this.nodes) {
                List list = classTreeNode2.getChildNodes();
                if (bl) {
                    int n = 0;
                    while (n < list.size()) {
                        MutableTreeNode mutableTreeNode = (MutableTreeNode)list.get(n);
                        classTreeNode2.add(mutableTreeNode);
                        ++n;
                    }
                    classTreeNode.add(classTreeNode2);
                    continue;
                }
                arrayList.addAll(list);
            }
            if (!bl) {
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    classTreeNode.add((MutableTreeNode)iterator.next());
                }
            }
            this.reload(classTreeNode);
        }
        this.grouped = bl;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void storeNodes(ClassTreeNode classTreeNode) {
        this.nodes = new ArrayList();
        Enumeration<TreeNode> enumeration = classTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.nodes.add((ClassTreeNode)enumeration.nextElement());
        }
    }

    public void addSelectedNode(MethodTreeNode methodTreeNode) {
        if (this.selection == null) {
            this.selection = new Vector();
        }
        if (this.selection.indexOf(methodTreeNode) == -1) {
            this.selection.addElement(methodTreeNode);
            this.nodeChanged(methodTreeNode);
        }
    }

    public void removeSelectedNode(MethodTreeNode methodTreeNode) {
        if (this.selection != null && this.selection.indexOf(methodTreeNode) != -1) {
            this.selection.removeElement(methodTreeNode);
            this.nodeChanged(methodTreeNode);
        }
    }

    public Enumeration getSelectedElements() {
        if (this.selection == null) {
            this.selection = new Vector();
        }
        return this.selection.elements();
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.size();
    }
}

