/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.awt.Component;
import java.awt.Font;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.accessibility.AccessibleState;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.wizard.common.BaliWizardState;
import oracle.jdeveloper.wizard.method.ClassTreeNode;
import oracle.jdeveloper.wizard.method.MethodTreeNode;
import oracle.jdeveloper.wizard.method.MethodUtils;
import oracle.jdeveloper.wizard.method.MethodsTreeModel;
import oracle.jdeveloper.wizard.method.OverrideMethodWizard;
import oracle.jdeveloper.wizard.method.Res;
import oracle.jdevimpl.java.JavaArb;

public class OverrideMethodState
implements BaliWizardState {
    private static boolean copyJavadoc;
    private static boolean groupByClass;
    private DefaultComboBoxModel comboModel;
    private String selectedClass;
    private TreeCellRenderer renderer;
    private HashMap clsHash;
    private Project prj;
    private Node javaNode;
    private URL url;
    private Context context;
    private JavaManager javaManager;
    private SourceFile srcFile;
    private JavaMethod refMethod;
    private JEWTDialog _dlg;
    private boolean okEnabled;

    public OverrideMethodState(Context context) {
        Node node = OverrideMethodWizard.getJavaNode(context);
        this.prj = context.getProject();
        this.javaNode = node;
        this.url = node.getURL();
        this.context = context;
        this.javaManager = JavaManager.getJavaManager(this.prj);
    }

    public ComboBoxModel getComboBoxModel() {
        if (this.comboModel == null) {
            this.loadData();
        }
        return this.comboModel;
    }

    public TreeModel getTreeModel(String string) {
        if (this.clsHash == null) {
            this.loadData();
        }
        return (TreeModel)this.clsHash.get(string);
    }

    public TreeModel getCurrentTreeModel() {
        String string;
        if (this.clsHash == null) {
            this.loadData();
        }
        return (string = (String)this.comboModel.getSelectedItem()) != null ? this.getTreeModel(string) : null;
    }

    public void loadModel(TreeModel treeModel, boolean bl) {
        ((MethodsTreeModel)treeModel).loadModel(bl);
    }

    public boolean isModelLoaded(TreeModel treeModel) {
        return ((MethodsTreeModel)treeModel).isLoaded();
    }

    public Project getProject() {
        return this.prj;
    }

    public boolean isCopyJavadoc() {
        return copyJavadoc;
    }

    public void setCopyJavadoc(boolean bl) {
        copyJavadoc = bl;
    }

    public boolean isGroupByClass() {
        return groupByClass;
    }

    public void setGroupByClass(boolean bl) {
        groupByClass = bl;
    }

    public void setSelectedClass(String string) {
        this.selectedClass = string;
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    void setDialog(JEWTDialog jEWTDialog) {
        if (this._dlg == null) {
            this._dlg = jEWTDialog;
            this.updateOK();
        }
    }

    public void enableOK(boolean bl) {
        this.okEnabled = bl;
        this.updateOK();
    }

    private void updateOK() {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(this.okEnabled);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new CheckboxNodeRenderer();
        }
        return this.renderer;
    }

    public void commitWizardState() {
        ClassTreeNode classTreeNode;
        MethodsTreeModel methodsTreeModel;
        if (!OverrideMethodWizard.ensureAccessible(this.context)) {
            return;
        }
        JavaClass javaClass = null;
        Object var2_2 = null;
        if (this.comboModel != null && (methodsTreeModel = (MethodsTreeModel)this.getCurrentTreeModel()) != null && (javaClass = (classTreeNode = (ClassTreeNode)methodsTreeModel.getRoot()).getJavaClass()).isSourceElement()) {
            SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            SourceTransaction sourceTransaction = sourceFile.getTransaction();
            if (sourceTransaction == null) {
                sourceTransaction = sourceFile.beginTransaction();
            }
            try {
                Enumeration enumeration = methodsTreeModel.getSelectedElements();
                while (enumeration.hasMoreElements()) {
                    MethodTreeNode methodTreeNode = (MethodTreeNode)enumeration.nextElement();
                    JavaMethod javaMethod = (JavaMethod)methodTreeNode.getUserObject();
                    MethodUtils.generateMethod(javaMethod, sourceClass, this.isCopyJavadoc());
                    this.refMethod = methodTreeNode.getJavaMethod();
                }
                sourceTransaction.savepoint();
                MethodUtils.narrowImports(sourceFile);
                this.javaManager.commitTransaction(sourceTransaction, new TransactionDescriptor(Res.getString(0)));
                sourceTransaction = null;
            }
            finally {
                if (sourceTransaction != null) {
                    sourceTransaction.abort();
                    sourceTransaction = null;
                }
            }
        }
        if (this.refMethod != null) {
            SourceName sourceName;
            int n = -1;
            int n2 = -1;
            JavaMethod javaMethod = javaClass.getDeclaredMethod(this.refMethod.getName(), this.refMethod.getParameterTypes());
            SourceMethod sourceMethod = javaMethod != null ? (SourceMethod)javaMethod.getSourceElement() : null;
            SourceName sourceName2 = sourceName = sourceMethod != null ? sourceMethod.getNameElement() : null;
            if (sourceName != null) {
                n = sourceName.getStartOffset();
                n2 = sourceName.getEndOffset();
            } else if (sourceMethod != null) {
                n = sourceMethod.getStartOffset();
                n2 = sourceMethod.getEndOffset();
            }
            NavigationManager navigationManager = NavigationManager.getNavigationManager();
            OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(this.context, n, n2 - n);
            try {
                if (navigationManager != null) {
                    navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint, true);
                } else {
                    offsetNavigationPoint.navigate();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void loadData() {
        if (this.clsHash == null) {
            this.clsHash = new HashMap();
        }
        if (this.comboModel == null) {
            this.comboModel = new DefaultComboBoxModel();
        }
        if (this.javaNode != null) {
            if (this.srcFile == null) {
                this.srcFile = this.javaManager.getSourceFile(this.url);
            }
            if (this.srcFile != null) {
                String string = this.srcFile.getPrimaryClass().getQualifiedName();
                JavaClass[] javaClassArray = this.getAllClasses(this.srcFile);
                if (javaClassArray != null) {
                    int n = 0;
                    while (n < javaClassArray.length) {
                        JavaClass javaClass = javaClassArray[n];
                        TreeModel treeModel = this.createTreeModel(javaClass);
                        if (treeModel != null) {
                            String string2 = javaClass.getQualifiedName();
                            if (string2.equals(string)) {
                                this.selectedClass = string2;
                            }
                            this.comboModel.addElement(string2);
                            this.clsHash.put(string2, treeModel);
                        }
                        ++n;
                    }
                }
            }
            if (this.selectedClass == null && this.comboModel.getSize() > 0) {
                this.selectedClass = (String)this.comboModel.getElementAt(0);
            }
        }
    }

    private JavaClass[] getAllClasses(SourceFile sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass : sourceFile.getClasses()) {
            arrayList.add(javaClass);
            this.getContainedClasses(javaClass, arrayList);
        }
        return arrayList.toArray(new JavaClass[arrayList.size()]);
    }

    private void getContainedClasses(JavaClass javaClass, ArrayList arrayList) {
        for (JavaClass javaClass2 : javaClass.getDeclaredClasses()) {
            arrayList.add(javaClass2);
            this.getContainedClasses(javaClass2, arrayList);
        }
    }

    private TreeModel createTreeModel(JavaClass javaClass) {
        MethodsTreeModel methodsTreeModel = null;
        if (!(javaClass.isInterface() || javaClass.isArray() || javaClass.isPrimitive())) {
            ClassTreeNode classTreeNode = new ClassTreeNode(javaClass, null, null);
            methodsTreeModel = new MethodsTreeModel(classTreeNode);
            classTreeNode.setModel(methodsTreeModel);
        }
        return methodsTreeModel;
    }

    private JLabeledCheckBox getPartialCheckBox() {
        JLabeledCheckBox jLabeledCheckBox = new JLabeledCheckBox();
        ButtonModel buttonModel = jLabeledCheckBox.checkBox.getModel();
        buttonModel.setArmed(true);
        buttonModel.setPressed(true);
        buttonModel.setSelected(true);
        return jLabeledCheckBox;
    }

    static JLabeledCheckBox mav$getPartialCheckBox(OverrideMethodState overrideMethodState) {
        return overrideMethodState.getPartialCheckBox();
    }

    private class CheckboxNodeRenderer
    extends DefaultTreeCellRenderer {
        Font normalFont;
        Font abstractFont;
        DefaultTreeCellRenderer genericRenderer;
        Icon protectedIcon;
        Icon privateIcon;
        Icon publicIcon;
        Icon packageIcon;
        Icon abstractIcon;

        void $init$() {
            this.protectedIcon = JavaArb.getIcon(63);
            this.privateIcon = JavaArb.getIcon(64);
            this.publicIcon = JavaArb.getIcon(62);
            this.packageIcon = JavaArb.getIcon(65);
            this.abstractIcon = JavaArb.getIcon(68);
        }

        CheckboxNodeRenderer() {
            this.$init$();
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = null;
            boolean bl5 = false;
            if (object instanceof MethodTreeNode) {
                JLabeledCheckBox jLabeledCheckBox = new JLabeledCheckBox();
                MethodTreeNode methodTreeNode = (MethodTreeNode)object;
                if (methodTreeNode.isAbstract()) {
                    if (this.abstractFont != null) {
                        jLabeledCheckBox.label.setFont(this.abstractFont);
                    } else if (this.normalFont == null) {
                        this.normalFont = jTree.getFont();
                    }
                    if (this.abstractFont == null && this.normalFont != null) {
                        this.abstractFont = this.normalFont.deriveFont(1);
                        jLabeledCheckBox.label.setFont(this.abstractFont);
                    }
                } else if (this.normalFont != null) {
                    jLabeledCheckBox.label.setFont(this.normalFont);
                }
                int n2 = methodTreeNode.getModifier();
                Icon icon = null;
                if (Modifier.isAbstract(n2)) {
                    icon = this.abstractIcon;
                }
                if (Modifier.isProtected(n2)) {
                    jLabeledCheckBox.label.setIcon(icon == null ? this.protectedIcon : new OverlayIcon(this.protectedIcon, this.abstractIcon));
                } else if (Modifier.isPrivate(n2)) {
                    jLabeledCheckBox.label.setIcon(icon == null ? this.privateIcon : new OverlayIcon(this.privateIcon, this.abstractIcon));
                } else if (Modifier.isPublic(n2)) {
                    jLabeledCheckBox.label.setIcon(icon == null ? this.publicIcon : new OverlayIcon(this.publicIcon, this.abstractIcon));
                } else {
                    jLabeledCheckBox.label.setIcon(icon == null ? this.packageIcon : new OverlayIcon(this.packageIcon, this.abstractIcon));
                }
                jLabeledCheckBox.checkBox.setSelected(methodTreeNode.isSelected());
                jLabeledCheckBox.label.setText(methodTreeNode.getSignature());
                jLabeledCheckBox.label.setHasFocus(bl4);
                jLabeledCheckBox.label.setSelected(bl);
                boolean bl6 = jTree.isEnabled();
                jLabeledCheckBox.label.setEnabled(bl6);
                jLabeledCheckBox.setEnabled(bl6);
                bl5 = methodTreeNode.isSelected();
                component = jLabeledCheckBox;
            } else if (object instanceof ClassTreeNode && !((DefaultMutableTreeNode)object).isRoot()) {
                JLabeledCheckBox jLabeledCheckBox;
                ClassTreeNode classTreeNode = (ClassTreeNode)object;
                boolean bl7 = classTreeNode.isInterface();
                int n3 = classTreeNode.getSelectedChildCount();
                bl5 = classTreeNode.isSelected();
                if (n3 > 0 && !bl5) {
                    jLabeledCheckBox = OverrideMethodState.mav$getPartialCheckBox(OverrideMethodState.this);
                } else {
                    jLabeledCheckBox = new JLabeledCheckBox();
                    ButtonModel buttonModel = jLabeledCheckBox.checkBox.getModel();
                    buttonModel.setSelected(bl5);
                    buttonModel.setArmed(false);
                    buttonModel.setPressed(false);
                }
                jLabeledCheckBox.label.setIcon(JavaIcons.getIcon(bl7 ? 1 : 0));
                jLabeledCheckBox.label.setText(classTreeNode.toString());
                jLabeledCheckBox.label.setHasFocus(bl4);
                jLabeledCheckBox.label.setSelected(bl);
                component = jLabeledCheckBox;
            } else {
                if (this.genericRenderer == null) {
                    this.genericRenderer = new DefaultTreeCellRenderer();
                }
                component = this.genericRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            if (component instanceof JLabeledCheckBox) {
                JLabeledCheckBox jLabeledCheckBox = (JLabeledCheckBox)component;
                jLabeledCheckBox.getAccessibleContext().setAccessibleName(jLabeledCheckBox.label.getText());
                if (bl4) {
                    jLabeledCheckBox.getAccessibleContext().firePropertyChange("AccessibleState", bl5 ? null : AccessibleState.CHECKED, bl5 ? AccessibleState.CHECKED : null);
                }
            }
            return component;
        }

        private Icon _loadIcon(String string) {
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                return null;
            }
            return new ImageIcon(uRL);
        }
    }
}

