/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.method;

import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MenuSpec;
import oracle.ide.vcs.VCSManager;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.wizard.common.BaliWizard;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;
import oracle.jdeveloper.wizard.method.OverrideMethodPanel;
import oracle.jdeveloper.wizard.method.OverrideMethodState;
import oracle.jdeveloper.wizard.method.Res;

public class OverrideMethodWizard
extends BaliWizard
implements DynamicMenuListener,
Addin {
    public static final String OVERRIDE_METHODS_CMD = "OverrideMethodWizard.SHOW_DIALOG_CMD";
    public static final int OVERRIDE_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"OverrideMethodWizard.SHOW_DIALOG_CMD");
    private JComponent[] _dynamicItems;
    private static final SizeKeeperCallback DLG_SIZE_KEEPER = new SizeKeeperCallback("override-method-wizard");

    public OverrideMethodWizard() {
        this.wizName = Res.getString(0);
    }

    public void initialize() {
        this.initializeMenuItems();
        WizardManager.getInstance().registerWizard((Wizard)this);
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
    }

    private void initializeMenuItems() {
        String string = Res.getString(1);
        String string2 = StringUtils.stripMnemonic((String)string);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        Icon icon = this.getIcon();
        IdeAction ideAction = IdeAction.get((int)OVERRIDE_METHODS_CMD_ID, (String)OVERRIDE_METHODS_CMD, (String)string2, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)n, (Icon)icon, null, (boolean)true);
        1 var6_6 = new 1();
        ideAction.addController((Controller)var6_6);
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction, 400.0f);
        this._dynamicItems = new JComponent[]{jMenuItem};
    }

    public MenuSpec getMenuSpecification() {
        return null;
    }

    protected BaliWizardPanel buildPanel(Context context, BaliWizardState baliWizardState) {
        OverrideMethodPanel overrideMethodPanel = new OverrideMethodPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)overrideMethodPanel, "f1_idedoverridemethods_html");
        return overrideMethodPanel;
    }

    protected BaliWizardState buildState(Context context) {
        Node node = OverrideMethodWizard.getJavaNode(context);
        if (node != null) {
            OverrideMethodState overrideMethodState = new OverrideMethodState(context);
            if (overrideMethodState.getComboBoxModel().getSize() > 0) {
                return overrideMethodState;
            }
            this.displayErrorMessage(Res.getString(19), Res.format(20, URLFileSystem.getPlatformPathName((URL)node.getURL())), null);
        }
        return null;
    }

    public boolean isAvailable(Context context) {
        return OverrideMethodWizard.getJavaNode(context) != null;
    }

    protected JEWTDialog buildDialog(Context context, BaliWizardState baliWizardState) {
        JEWTDialog jEWTDialog = null;
        if (baliWizardState != null) {
            jEWTDialog = super.buildDialog(context, baliWizardState);
            jEWTDialog.pack();
            jEWTDialog.setResizable(true);
            DLG_SIZE_KEEPER.dialogAboutToRun((JDialog)jEWTDialog);
            OverrideMethodPanel overrideMethodPanel = (OverrideMethodPanel)jEWTDialog.getContent();
            jEWTDialog.setInitialFocus(overrideMethodPanel.getInitialFocusComponent());
            OverrideMethodState overrideMethodState = (OverrideMethodState)baliWizardState;
            overrideMethodState.setDialog(jEWTDialog);
        }
        return jEWTDialog;
    }

    protected String getHeaderTitle() {
        return Res.getString(3);
    }

    protected String getHeaderDescription() {
        return Res.getString(4);
    }

    static Node getJavaNode(Context context) {
        if (context != null && context.getProject() != null) {
            JavaSourceNode javaSourceNode = null;
            Element element = context.getElement();
            if (element instanceof JavaSourceNode) {
                javaSourceNode = (JavaSourceNode)element;
            } else {
                Node node = context.getNode();
                if (node instanceof JavaSourceNode) {
                    javaSourceNode = (JavaSourceNode)node;
                }
            }
            if (javaSourceNode != null && (!javaSourceNode.isReadOnly() || VCSManager.getVCSManager() != null && VCSManager.getVCSManager().isVersioned(javaSourceNode.getURL()))) {
                return javaSourceNode;
            }
        }
        return null;
    }

    static boolean ensureAccessible(Context context) {
        Node node = OverrideMethodWizard.getJavaNode(context);
        if (node.isReadOnly() && !VCSManager.getVCSManager().checkOutNode(node)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Res.format(22, URLFileSystem.getPlatformPathName((URL)node.getURL())), (String)Res.getString(21), null);
            return false;
        }
        return true;
    }

    public JComponent[] gatherDynamicActions(Context context) {
        if (context.getProject() != null && context.getView() instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
            return this._dynamicItems;
        }
        return new JComponent[0];
    }

    public final class 1
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            OverrideMethodWizard.this.invoke(context);
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(OverrideMethodWizard.this.isAvailable(context));
            return true;
        }
    }
}

