/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.project;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.model.PatternFiltersTreePanel;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.resource.WizardsArb;

public abstract class AbstractCopySourceIntoProjectWizard
extends JPanel
implements Runnable,
VetoableChangeListener,
DocumentListener,
ActionListener,
ImportWizard {
    public static final String CONTEXT_KEY = "Context";
    private JEWTDialog _dialog;
    private Namespace _namespace;
    private URLTextField _urlFld;
    private JButton _browseBtn;
    private FileSelectionTreePanel _treePanel;
    private URLTextField _copyToURLFld;
    private JButton _copyToBrowseBtn;
    private Project _tempProject;
    private ContentSet _contentSet;
    protected Project _addToProject;
    private ProgressBar _progressBar;
    private List _copiedFileList;
    public static final String IMPORT_PROPERTY = "oracle.jdeveloper.wizard.project.AbstractCopySourceIntoProjectWizard";
    public static final String IMPORT_BEGIN = "BeginImport";
    public static final String IMPORT_END = "EndImport";
    public static final String IMPORT_FILE_LIST = "ImportFileList";

    void $init$() {
        this._urlFld = new URLTextField(null, true);
    }

    public Icon getImportWizardIcon(Context context) {
        return UIManager.getIcon("FileView.directoryIcon");
    }

    public abstract String getImportWizardName(Context var1);

    public abstract String getImportWizardTooltipText(Context var1);

    public abstract String getHelpID();

    public abstract String getDialogHeaderTitle();

    public abstract String getDialogHeaderDescription();

    public abstract String getDialogTitle();

    protected abstract boolean validateData(URL var1, ContentSet var2);

    protected void configureBrowseButton(JButton jButton, URLTextField uRLTextField) {
        jButton.addActionListener((ActionListener)uRLTextField);
    }

    protected URL getDefaultCopyToURL() {
        return null;
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return context.getProject() != null;
    }

    protected static boolean isDirectoryInContentSet(URL uRL, ContentSet contentSet) {
        return contentSet.toRelativePath(uRL) != null;
    }

    protected static void addDirectoryURLToContentSet(URL uRL, ContentSet contentSet) {
        contentSet.getURLPath().add(uRL);
    }

    protected void processData(ContentSet contentSet, URL uRL, String string) {
        this._progressBar = new ProgressBar((Component)this, WizardsArb.getString(441), (Runnable)this, true);
        this._progressBar.start(DirOptionsArb.getString((int)2), null);
        this._progressBar.waitUntilDone();
    }

    protected Context getContext() {
        return (Context)this._namespace.get(CONTEXT_KEY);
    }

    protected Dialog getDialog() {
        return this._dialog;
    }

    public final boolean invokeImportWizard(Context context, String[] stringArray) {
        this._addToProject = context.getProject();
        this._urlFld.setURL(null);
        this._namespace = new Namespace();
        this._namespace.put(CONTEXT_KEY, (Object)context);
        this._copiedFileList = new ArrayList();
        this._tempProject = new Project();
        Project project = Ide.getDefaultProject();
        if (project != null) {
            project.copyTo((Object)this._tempProject);
        }
        PathsConfiguration.getInstance(this._tempProject).setProjectSourcePath(null);
        this._namespace.put("Project", (Object)this._tempProject);
        this._contentSet = ContentSet.getInstance((PropertyStorage)this._tempProject, (String)PathsConfiguration.JAVA_CONTENT_SET_KEY);
        PatternFilters patternFilters = this._contentSet.getPatternFilters();
        WorkingSetsEditor.setPatternFilters(this._namespace, patternFilters);
        this._initUI();
        this._treePanel.clearRootURLNode();
        this._treePanel.onEntry(new TraversableContext(this._namespace, 1));
        this._treePanel.setTreeVisible(false);
        if (this.showDialog()) {
            this.processData(this._contentSet, this._copyToURLFld.getURL(), this._urlFld.getText());
            return true;
        }
        return false;
    }

    private boolean showDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, this.getHelpID());
        this._dialog = DialogUtil.createJEWTDialogOwnedBy((Component)Ide.getMainWindow());
        if (this._dialog == null) {
            return false;
        }
        String string = this.getDialogHeaderTitle();
        if (string != null) {
            JDevDialogHeader jDevDialogHeader = new JDevDialogHeader();
            jDevDialogHeader.setHeaderTitle(string);
            jDevDialogHeader.setHeaderDescription(this.getDialogHeaderDescription());
            this._dialog.setDialogHeader((Component)jDevDialogHeader);
        }
        this._dialog.setContent((Component)this);
        this._dialog.setOKButtonEnabled(false);
        this._dialog.setInitialFocus((Component)this._urlFld);
        this._dialog.addVetoableChangeListener((VetoableChangeListener)this);
        this._dialog.setTitle(this.getDialogTitle());
        this._dialog.setButtonMask(7);
        this._dialog.setResizable(true);
        this._dialog.pack();
        boolean bl = this._dialog.runDialog();
        if (bl) {
            PatternFilters patternFilters = this._contentSet.getPatternFilters();
            PatternFilters patternFilters2 = WorkingSetsEditor.getPatternFilters(this._namespace);
            patternFilters2.copyTo((Object)patternFilters);
            return true;
        }
        this._dialog.dispose();
        this._dialog = null;
        return bl;
    }

    public final void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            URL uRL = this._copyToURLFld.getURL();
            if (uRL == null) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)this._addToProject);
            ContentSet contentSet = projectContent.getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            if (!this.validateData(uRL, contentSet)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }
    }

    private void _copyFiles() {
        ContentSet contentSet = this._contentSet;
        URL uRL = this._copyToURLFld.getURL();
        String string = this._urlFld.getText();
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)this._addToProject);
        updateMessage.setProperty(IMPORT_PROPERTY, (Object)IMPORT_BEGIN);
        this._addToProject.notifyObservers((Object)this._addToProject, updateMessage);
        Iterator iterator = contentSet.urlIterator(null);
        URL uRL2 = URLFactory.newDirURL((String)string);
        URL uRL3 = null;
        while (iterator.hasNext()) {
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            uRL3 = (URL)iterator.next();
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(WizardsArb.getString(442), URLFileSystem.getPlatformPathName((URL)uRL3));
            this._copyFile(uRL2, uRL, uRL3);
        }
        this._progressBar.setDoneStatus();
        UpdateMessage updateMessage2 = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, (Object)this._addToProject);
        updateMessage2.setProperty(IMPORT_PROPERTY, (Object)IMPORT_END);
        updateMessage2.setProperty(IMPORT_FILE_LIST, (Object)this._copiedFileList);
        this._addToProject.notifyObservers((Object)this._addToProject, updateMessage2);
    }

    private void _copyFile(URL uRL, URL uRL2, URL uRL3) {
        String string = URLFileSystem.toRelativeSpec((URL)uRL3, (URL)uRL);
        URL uRL4 = URLFactory.newURL((URL)uRL2, (String)string);
        try {
            URLFileSystem.copy((URL)uRL3, (URL)uRL4);
            this._copiedFileList.add(uRL4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        this._copyFiles();
    }

    private void _handleOKButton() {
        if (this._copyToURLFld.getURL() != null && this._treePanel.isAnythingSelected()) {
            this._dialog.setOKButtonEnabled(true);
        } else {
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private void _initUI() {
        if (this._browseBtn == null) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._urlFld, (String)WizardsArb.getString(435));
            this._browseBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)WizardsArb.getString(436));
            this._browseBtn.addActionListener(this);
            JLabel jLabel2 = new JLabel();
            this._copyToURLFld = new URLTextField(null, true);
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._copyToURLFld, (String)WizardsArb.getString(437));
            this._copyToURLFld.setURL(this.getDefaultCopyToURL());
            this._copyToURLFld.getDocument().addDocumentListener(this);
            this._copyToBrowseBtn = new JButton();
            ResourceUtils.resButton((AbstractButton)this._copyToBrowseBtn, (String)WizardsArb.getString(438));
            this.configureBrowseButton(this._copyToBrowseBtn, this._copyToURLFld);
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._urlFld, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._browseBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this._treePanel = new FileSelectionTreePanel();
            this.add((Component)((Object)this._treePanel), new GridBagConstraints(0, 2, 2, 5, 0.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)jLabel2, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._copyToURLFld, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._copyToBrowseBtn, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._urlFld.actionPerformed(actionEvent);
        URL uRL = this._urlFld.getURL();
        if (uRL != null) {
            if (this._contentSet != null) {
                this._contentSet.setContentFolderURL(uRL);
                this._contentSet.getURLPath().add(uRL);
            }
            this._treePanel.clearRootURLNode();
            this._treePanel.setRootURLNodeLabel(this._urlFld.getText());
            this._treePanel.onEntry(new TraversableContext(this._namespace, 1));
            this._treePanel.setTreeVisible(true);
            if (this._treePanel.isAnythingSelected()) {
                this._dialog.setOKButtonEnabled(true);
                this._treePanel.setFilterButtonEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this._handleOKButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this._handleOKButton();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this._handleOKButton();
    }

    public AbstractCopySourceIntoProjectWizard() {
        this.$init$();
    }

    static void mav$_handleOKButton(AbstractCopySourceIntoProjectWizard abstractCopySourceIntoProjectWizard) {
        abstractCopySourceIntoProjectWizard._handleOKButton();
    }

    static URLTextField ra$_urlFld(AbstractCopySourceIntoProjectWizard abstractCopySourceIntoProjectWizard) {
        return abstractCopySourceIntoProjectWizard._urlFld;
    }

    private class FileSelectionTreePanel
    extends PatternFiltersTreePanel
    implements MouseListener {
        public FileSelectionTreePanel() {
            this._dirTree.addMouseListener((MouseListener)this);
            this._buttonPanel.remove(this._btnFilterDirectories);
        }

        public void onEntry(TraversableContext traversableContext) {
            super.onEntry(traversableContext);
            if (AbstractCopySourceIntoProjectWizard.ra$_urlFld(AbstractCopySourceIntoProjectWizard.this).getURL() == null) {
                this.clearRootURLNode();
                this.setFilterButtonEnabled(false);
            } else {
                this.setFilterButtonEnabled(true);
            }
        }

        public void clearRootURLNode() {
            this._rootNode = null;
        }

        public void setRootURLNodeLabel(String string) {
            this._rootNodeLabel = string;
        }

        public void setTreeVisible(boolean bl) {
            this._dirTree.setVisible(bl);
        }

        public boolean isAnythingSelected() {
            JMutableTreeNode jMutableTreeNode;
            JTreeCellData jTreeCellData;
            TriStateBoolean triStateBoolean;
            return this._rootNode != null && ((triStateBoolean = (jTreeCellData = (JTreeCellData)(jMutableTreeNode = (JMutableTreeNode)this._rootNode).getUserObject()).getCheckBoxState()).isTrue() || triStateBoolean.isTriState());
        }

        public void setFilterButtonEnabled(boolean bl) {
            this._btnFilterFiles.setEnabled(bl);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractCopySourceIntoProjectWizard.mav$_handleOKButton(AbstractCopySourceIntoProjectWizard.this);
        }
    }
}

