/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.IOException;
import java.net.URL;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.XMLBinding;
import oracle.jdeveloper.xml.DomIO;
import oracle.jdeveloper.xml.URLDomIO;
import oracle.jdevimpl.xml.ElementDescriptor;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public abstract class BindingIO {
    public static final String XMLNS_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private XMLDocument _document;
    private Object _rootProxy;
    private EventListener _eventListener;
    private boolean _dirty;

    public void load(URL uRL) throws IOException {
        this.load(new URLDomIO(uRL));
    }

    public void load(DomIO domIO) throws IOException {
        String string;
        this.checkLoad();
        this._document = (XMLDocument)domIO.load();
        this.enableDirtyDetection();
        if (this._document != null && this.isStandalone() && !"yes".equals(string = this._document.getStandalone())) {
            this._document.setStandalone("yes");
        }
    }

    public void save(URL uRL) throws IOException {
        this.save(new URLDomIO(uRL), false);
    }

    public void save(DomIO domIO) throws IOException {
        this.save(domIO, false);
    }

    public void save(DomIO domIO, boolean bl) throws IOException {
        if (this._dirty || bl) {
            this.checkSave();
            domIO.save((Document)this._document);
            if (!bl) {
                this.resetDirty();
            }
        }
    }

    public void saveAsynchronously(DomIO domIO, boolean bl) throws IOException {
        DomIO.runSwingClosure(new 2(this, true, domIO, bl));
    }

    public ElementDescriptor getElementDescriptor(Object object) {
        Element element = DOMBindingRuntime.getBoundElement((Object)object);
        if (element instanceof XMLElement) {
            XMLElement xMLElement = (XMLElement)element;
            return new ElementDescriptor(xMLElement.getLineNumber(), xMLElement.getColumnNumber());
        }
        return new ElementDescriptor(0, 0);
    }

    public Object getRootProxy() {
        if (this._rootProxy == null) {
            XMLBinding xMLBinding = this.getXMLBinding((Document)this._document);
            DOMBindingRuntime dOMBindingRuntime = new DOMBindingRuntime((Document)this._document, xMLBinding);
            Object object = this._document.getUserData("disable-whitespace-handling");
            if (Boolean.TRUE.equals(object)) {
                dOMBindingRuntime.setEnableWhitespace(false);
            }
            this._rootProxy = dOMBindingRuntime.getProxy();
        }
        return this._rootProxy;
    }

    public Object create() {
        return this.create(null);
    }

    public Object create(String string) {
        return this.create(string, new XMLDocument());
    }

    public Object create(String string, DomIO domIO) throws IOException {
        return this.create(string, (XMLDocument)domIO.create());
    }

    private Object create(String string, XMLDocument xMLDocument) {
        this._document = xMLDocument;
        this.enableDirtyDetection();
        this._document.setVersion("1.0");
        this._document.setEncoding(BindingIO.getEncoding());
        if (this.isStandalone()) {
            this._document.setStandalone("yes");
        }
        DoctypeInfo doctypeInfo = this.ensureDoctype(string);
        Element element = this._document.createElementNS(doctypeInfo.uri, doctypeInfo.qname);
        this._document.appendChild((Node)element);
        this.initDocument((Document)this._document, string);
        return this.getRootProxy();
    }

    protected void initDocument(Document document, String string) {
    }

    protected boolean isStandalone() {
        return false;
    }

    protected final void warnVersionNotRecognized(String string, String string2) {
    }

    protected abstract XMLBinding getXMLBinding(Document var1);

    protected abstract DoctypeInfo getDoctypeInfo(String var1);

    protected String getMinimumRequiredVersion() {
        return null;
    }

    protected int mapVersionToInt(String string) {
        return 0;
    }

    protected int compareVersions(String string, String string2) {
        int n = this.mapVersionToInt(string);
        int n2 = this.mapVersionToInt(string2);
        return n - n2;
    }

    private void enableDirtyDetection() {
        this._eventListener = new 1();
        this._document.addEventListener("DOMSubtreeModified", this._eventListener, false);
        this.resetDirty();
    }

    private void checkLoad() {
        this._document = null;
        this._rootProxy = null;
        this._eventListener = null;
        this.resetDirty();
    }

    private void checkSave() {
        if (this._document == null) {
            throw new IllegalStateException("No document loaded.");
        }
        this.ensureDoctype(null);
    }

    private void resetDirty() {
        this._dirty = false;
    }

    private DoctypeInfo ensureDoctype(String string) {
        DoctypeInfo doctypeInfo = this.getDoctypeInfo(string);
        DocumentType documentType = this._document.getDoctype();
        if (documentType == null) {
            if (doctypeInfo.publicID != null || doctypeInfo.systemID != null) {
                this._document.setDoctype(doctypeInfo.qname, doctypeInfo.systemID, doctypeInfo.publicID);
            }
        } else {
            this.maybeUpdateDoctype(documentType.getSystemId());
        }
        return doctypeInfo;
    }

    private void maybeUpdateDoctype(String string) {
        String string2 = this.getMinimumRequiredVersion();
        if (this.compareVersions(string2, string) > 0) {
            DoctypeInfo doctypeInfo = this.getDoctypeInfo(string2);
            this._document.setDoctype(doctypeInfo.qname, doctypeInfo.systemID, doctypeInfo.publicID);
        }
    }

    private static String getEncoding() {
        return IdeUtil.getIdeIanaEncoding();
    }

    static void wa$_dirty(BindingIO bindingIO, boolean bl) {
        bindingIO._dirty = bl;
    }

    public final class 2
    extends SwingClosure {
        private final /* synthetic */ DomIO v$io;
        private final /* synthetic */ boolean v$isPreview;
        final /* synthetic */ BindingIO this$0;

        protected void runImpl() throws IOException {
            this.this$0.save(this.v$io, this.v$isPreview);
        }

        public 2(BindingIO bindingIO, boolean bl, DomIO domIO, boolean bl2) {
            this.v$isPreview = bl2;
            this.v$io = domIO;
            this.this$0 = bindingIO;
            super(bl);
        }
    }

    protected static final class DoctypeInfo {
        public final String uri;
        public final String qname;
        public final String systemID;
        public final String publicID;

        public DoctypeInfo(String string, String string2, String string3) {
            this(null, string, string2, string3);
        }

        public DoctypeInfo(String string, String string2, String string3, String string4) {
            this.uri = string;
            this.qname = string2;
            this.systemID = string3;
            this.publicID = string4;
        }
    }

    public final class 1
    implements EventListener {
        public void handleEvent(Event event) {
            BindingIO.wa$_dirty(BindingIO.this, true);
        }
    }
}

