/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class DomIO {
    public Document create() throws IOException {
        return new XMLDocument();
    }

    public abstract Document load() throws IOException;

    public abstract void save(Document var1) throws IOException;

    protected CharArrayWriter getCharArrayWriter(Document document) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter(16384);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        XMLUtil.writeXML((XMLDocument)((XMLDocument)document), (PrintWriter)printWriter, (int)this.getIndentSize(), (boolean)this.getIndentReplaceWithTabs(), (int)this.getTabSize());
        return charArrayWriter;
    }

    protected int getTabWidth() {
        return 2;
    }

    protected int getIndentSize() {
        return this.getTabWidth();
    }

    protected boolean getIndentReplaceWithTabs() {
        return false;
    }

    protected int getTabSize() {
        return 8;
    }

    protected static Document loadImpl(InputStream inputStream, Reader reader, URL uRL) throws IOException {
        XMLDocument xMLDocument = null;
        try {
            try {
                DOMParser dOMParser = DomIO.newDOMParser();
                if (inputStream != null) {
                    dOMParser.parse(inputStream);
                } else {
                    dOMParser.parse(reader);
                }
                xMLDocument = dOMParser.getDocument();
            }
            catch (SAXException sAXException) {
                IOException iOException = uRL != null ? new IOException(URLFileSystem.getPlatformPathName((URL)uRL)) : new IOException();
                iOException.initCause(sAXException);
                throw iOException;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return xMLDocument;
    }

    protected static void runSwingClosure(SwingClosure swingClosure) throws IOException {
        try {
            swingClosure.run();
        }
        catch (ClosureException closureException) {
            IOException iOException = new IOException();
            iOException.initCause(closureException.getCause());
            throw iOException;
        }
    }

    private static DOMParser newDOMParser() {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        dOMParser.setDebugMode(true);
        return dOMParser;
    }
}

