/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.SwingClosure;
import oracle.jdeveloper.xml.DomIO;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class TextBufferDomIO
extends DomIO {
    private final TextBuffer _buffer;
    private final URL _bufferURL;

    public TextBufferDomIO(TextBuffer textBuffer, URL uRL) {
        this._buffer = textBuffer;
        this._bufferURL = uRL;
    }

    public Document load() throws IOException {
        Reader reader = TextBufferFactory.createReader((ReadTextBuffer)this._buffer);
        return TextBufferDomIO.loadImpl(null, reader, this._bufferURL);
    }

    public void save(Document document) throws IOException {
        TextBufferDomIO.runSwingClosure(new 1(this, false, document));
    }

    private boolean tryDumpBufferDomModel(Document document, TextBuffer textBuffer) throws IOException {
        if (document instanceof XMLDocument) {
            XMLDocument xMLDocument = (XMLDocument)document;
            Object object = xMLDocument.getUserData("text-buffer-copy");
            Object object2 = xMLDocument.getUserData("dom-model-copy");
            if (object != null && object2 != null) {
                TextBuffer textBuffer2 = (TextBuffer)object;
                BufferDomModel bufferDomModel = (BufferDomModel)object2;
                bufferDomModel.commitTransaction();
                bufferDomModel.startTransaction("internal");
                TextBufferDomIO.dumpToTextBuffer(textBuffer2, textBuffer);
                return true;
            }
        }
        return false;
    }

    private void dumpToTextBuffer(Document document, TextBuffer textBuffer) throws IOException {
        CharArrayWriter charArrayWriter = this.getCharArrayWriter(document);
        TextBufferDomIO.dumpToTextBuffer(charArrayWriter.toCharArray(), this._buffer);
    }

    private static void dumpToTextBuffer(TextBuffer textBuffer, TextBuffer textBuffer2) {
        TextBufferDomIO.dumpToTextBuffer(textBuffer.getChars(0, textBuffer.getLength()), textBuffer2);
    }

    private static void dumpToTextBuffer(char[] cArray, TextBuffer textBuffer) {
        try {
            textBuffer.beginEdit();
            textBuffer.removeToEnd(0);
            textBuffer.insert(0, cArray);
        }
        finally {
            textBuffer.endEdit();
        }
    }

    static TextBuffer ra$_buffer(TextBufferDomIO textBufferDomIO) {
        return textBufferDomIO._buffer;
    }

    static boolean mav$tryDumpBufferDomModel(TextBufferDomIO textBufferDomIO, Document document, TextBuffer textBuffer) {
        return textBufferDomIO.tryDumpBufferDomModel(document, textBuffer);
    }

    static void mav$dumpToTextBuffer(TextBufferDomIO textBufferDomIO, Document document, TextBuffer textBuffer) {
        textBufferDomIO.dumpToTextBuffer(document, textBuffer);
    }

    public final class 1
    extends SwingClosure {
        private final /* synthetic */ Document v$doc;
        final /* synthetic */ TextBufferDomIO this$0;

        protected void runImpl() throws Exception {
            if (!TextBufferDomIO.mav$tryDumpBufferDomModel(this.this$0, this.v$doc, TextBufferDomIO.ra$_buffer(this.this$0))) {
                TextBufferDomIO.mav$dumpToTextBuffer(this.this$0, this.v$doc, TextBufferDomIO.ra$_buffer(this.this$0));
            }
        }

        public 1(TextBufferDomIO textBufferDomIO, boolean bl, Document document) {
            this.v$doc = document;
            this.this$0 = textBufferDomIO;
            super(bl);
        }
    }
}

