/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.IdeMenus;
import oracle.ideri.util.Product;

public final class JDevMenus {
    private static final Menubar menuMgr = Ide.getMenubar();

    public static JMenu findJMenu(String string) {
        String string2 = string = string != null ? string.trim() : null;
        if (string == null || string.length() == 0) {
            return null;
        }
        return MenuManager.getJMenu((String)string);
    }

    public static JMenu findOrCreateJMenu(String string) {
        JMenu jMenu = JDevMenus.findJMenu(string);
        if (jMenu != null) {
            return jMenu;
        }
        if (string.equals("File") || string.equals("Edit") || string.equals("View") || string.equals("Navigate") || string.equals("Run") || string.equals("Tools")) {
            return IdeMenus.findOrCreateJMenu((String)string);
        }
        if (string.equals("Search")) {
            jMenu = JDevMenus.createSearchMenu();
        }
        if (jMenu != null) {
            MenuManager.putJMenu((String)string, (JMenu)jMenu);
            menuMgr.add((Component)jMenu);
        }
        return jMenu;
    }

    public static JMenuItem createMenuItem(int n, String string, String string2, String string3, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Object object, boolean bl, float f) {
        return IdeMenus.createMenuItem((int)n, (String)string, (String)string2, (String)string3, (Integer)n2, (ArrayResourceBundle)arrayResourceBundle, (int)n3, (Object)object, (boolean)bl, (float)f);
    }

    public static JMenuItem createMenuItem(Controller controller, int n, String string, String string2, String string3, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Object object, boolean bl, float f) {
        return IdeMenus.createMenuItem((Controller)controller, (int)n, (String)string, (String)string2, (String)string3, (Integer)n2, (ArrayResourceBundle)arrayResourceBundle, (int)n3, (Object)object, (boolean)bl, (float)f);
    }

    private static JMenuItem createMenuItem(IdeAction ideAction, float f) {
        return menuMgr.createMenuItem((ToggleAction)ideAction, f);
    }

    public static void loadSearchMenu() {
        if (Product.isRaptor()) {
            JMenu jMenu = JDevMenus.findOrCreateJMenu("Edit");
            menuMgr.add((Component)JDevMenus.createFindMenuItem(), jMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)JDevMenus.createSearchAgainMenuItem(), jMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)JDevMenus.createSearchBackwardMenuItem(), jMenu, MenuConstants.SECTION_EDIT_FIND);
            menuMgr.add((Component)JDevMenus.createIncrementalSearchForwardMenuItem(), jMenu, MenuConstants.SECTION_EDIT_INCREMENTAL_FIND);
            menuMgr.add((Component)JDevMenus.createIncrementalSearchBackwardMenuItem(), jMenu, MenuConstants.SECTION_EDIT_INCREMENTAL_FIND);
            menuMgr.add((Component)JDevMenus.createReplaceMenuItem(), jMenu, MenuConstants.SECTION_EDIT_FIND);
        } else {
            JMenu jMenu = JDevMenus.findOrCreateJMenu("Search");
            menuMgr.add((Component)JDevMenus.createFindMenuItem(), jMenu, 1.0f);
            menuMgr.add((Component)JDevMenus.createSearchAgainMenuItem(), jMenu, 1.0f);
            menuMgr.add((Component)JDevMenus.createSearchBackwardMenuItem(), jMenu, 1.0f);
            menuMgr.add((Component)JDevMenus.createIncrementalSearchForwardMenuItem(), jMenu, MenuConstants.SECTION_SEARCH_INCREMENTAL_FIND);
            menuMgr.add((Component)JDevMenus.createIncrementalSearchBackwardMenuItem(), jMenu, MenuConstants.SECTION_SEARCH_INCREMENTAL_FIND);
            menuMgr.add((Component)JDevMenus.createReplaceMenuItem(), jMenu, 1.0f);
        }
    }

    private static JMenu createSearchMenu() {
        return menuMgr.createMenu(IdeArb.getString((int)106), IdeArb.getInteger((int)107), MenuConstants.WEIGHT_SEARCH_MENU, MenuConstants.SECTION_SEARCH_ADDINS);
    }

    private static JMenuItem createFindMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchFindAction(), 1.0f);
    }

    private static JMenuItem createSearchAgainMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchFindNextAction(), MenuConstants.WEIGHT_SEARCH_FIND_NEXT);
    }

    private static JMenuItem createSearchBackwardMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchFindPreviousAction(), MenuConstants.WEIGHT_SEARCH_FIND_PREVIOUS);
    }

    private static JMenuItem createIncrementalSearchForwardMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchIncrementalFindForwardAction(), MenuConstants.WEIGHT_SEARCH_INCREMENTAL_FIND_FORWARD);
    }

    private static JMenuItem createIncrementalSearchBackwardMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchIncrementalFindBackwardAction(), MenuConstants.WEIGHT_SEARCH_INCREMENTAL_FIND_BACKWARD);
    }

    private static JMenuItem createReplaceMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchReplaceAction(), MenuConstants.WEIGHT_SEARCH_REPLACE);
    }

    private static JMenuItem createSearchSourcePathMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getSearchFindInFilesAction(), MenuConstants.WEIGHT_SEARCH_FIND_IN_FILES);
    }

    private static JMenuItem createReplaceSourcePathMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getReplaceInFilesAction(), MenuConstants.WEIGHT_SEARCH_REPLACE_IN_FILES);
    }

    public static void loadNavigateMenu() {
        JMenu jMenu = JDevMenus.findOrCreateJMenu("Navigate");
        menuMgr.add((Component)JDevMenus.createGotoLineNumberMenuItem(), jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        menuMgr.add((Component)JDevMenus.createBrowseSymbolMenuItem(), jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
    }

    private static JMenuItem createGotoLineNumberMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getNavigateGoToLineAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_LINE);
    }

    private static JMenuItem createBrowseSymbolMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getNavigateGoToClassAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
    }

    public static void loadToolsMenu() {
        JMenu jMenu = JDevMenus.findOrCreateJMenu("Tools");
        menuMgr.add((Component)JDevMenus.createProjectPropertiesMenuItem(), jMenu, MenuConstants.SECTION_TOOLS_PROJECT_PROPERTIES);
        menuMgr.add((Component)JDevMenus.createDefaultProjectPropertiesMenuItem(), jMenu, MenuConstants.SECTION_TOOLS_PROJECT_PROPERTIES);
        menuMgr.sortSectionByName(jMenu, MenuConstants.SECTION_TOOLS_ADDINS);
    }

    private static JMenuItem createProjectPropertiesMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getToolsProjectPropertiesAction(), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
    }

    private static JMenuItem createDefaultProjectPropertiesMenuItem() {
        return JDevMenus.createMenuItem(IdeActions.getToolsDefaultProjectPropertiesAction(), MenuConstants.WEIGHT_TOOLS_DEFAULT_PROJECT_PROPERTIES);
    }
}

