/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.ant.AntBuildfile;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AntBuildfileImpl
implements AntBuildfile {
    private URL url;
    private Document document;
    private Properties properties;
    private ArrayList rootPaths;

    void $init$() {
        this.properties = new Properties();
        this.rootPaths = new ArrayList();
    }

    public AntBuildfileImpl(URL uRL, Document document) {
        this.$init$();
        this.url = uRL;
        this.document = document;
    }

    public URL getURL() {
        return this.url;
    }

    public Document getDocument() {
        return this.document;
    }

    public String[] getTargets() {
        NodeList nodeList = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            Attr attr = element.getAttributeNodeNS(null, "name");
            if (attr != null) {
                arrayList.add(attr.getValue());
            }
            ++n2;
        }
        return arrayList.toArray(new String[0]);
    }

    public Element getTarget(String string) {
        NodeList nodeList = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            Attr attr = element.getAttributeNodeNS(null, "name");
            if (attr != null && string.equals(attr.getValue())) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public Element createTarget(String string) {
        return this.createTarget(string, null);
    }

    public Element createTarget(String string, String string2) {
        return this.createTarget(string, string2, null);
    }

    public void appendBeforeTargets(org.w3c.dom.Node node) {
        NodeList nodeList = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        org.w3c.dom.Node node2 = nodeList.getLength() > 0 ? nodeList.item(0) : null;
        Element element = this.document.getDocumentElement();
        element.insertBefore(node, node2);
    }

    public void addDependency(String string, String string2) {
        Element element = this.getTarget(string);
        Attr attr = element.getAttributeNodeNS(null, "depends");
        if (attr == null) {
            element.setAttributeNS(null, "depends", string2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(attr.getValue());
            stringBuffer.append(",");
            stringBuffer.append(string2);
            attr.setValue(stringBuffer.toString());
        }
    }

    public Element createTarget(String string, String string2, String[] stringArray) {
        Element element = this.document.createElementNS("antlib:org.apache.tools.ant", "target");
        element.setAttributeNS(null, "name", string);
        if (string2 != null) {
            element.setAttributeNS(null, "description", string2);
        }
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n < stringArray.length - 1) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            element.setAttributeNS(null, "depends", stringBuffer.toString());
        }
        this.document.getDocumentElement().appendChild(element);
        return element;
    }

    public void addGlobalProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void addPathRoot(String string, URL uRL) {
        this.rootPaths.add(new PathRoot(string, uRL));
    }

    public String getRelativePath(URL uRL) {
        URL uRL2;
        if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
            uRL = JarUtil.getJarFileURL((URL)uRL);
        }
        Iterator iterator = this.rootPaths.iterator();
        String string = null;
        while (iterator.hasNext() && string == null) {
            PathRoot pathRoot = (PathRoot)iterator.next();
            string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)pathRoot.getURL(), (boolean)true);
            if (string == null) continue;
            string = "${" + pathRoot.getProperty() + "}/" + string;
        }
        URL uRL3 = URLFileSystem.getParent((URL)this.url);
        if (string == null) {
            string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL3, (boolean)true);
        }
        if (string == null && (string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)(uRL2 = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory())), (boolean)true)) != null) {
            string = "${oracle.home}/" + string;
        }
        if (string == null && (string = URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL3, (boolean)false)).equals(uRL.getPath())) {
            string = URLFileSystem.getPlatformPathName((URL)uRL);
        }
        if (string == null || string.length() == 0) {
            string = ".";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String createPropertyReference(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, "${");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Element createPath(String string, URLPath uRLPath) {
        Element element = this.document.createElementNS("antlib:org.apache.tools.ant", "path");
        element.setAttributeNS(null, "id", string);
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            Element element2 = this.document.createElementNS("antlib:org.apache.tools.ant", "pathelement");
            element2.setAttributeNS(null, "location", this.getRelativePath(uRLArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public Element createPatternSet(String string, String[] stringArray, String[] stringArray2) {
        Element element = this.document.createElementNS("antlib:org.apache.tools.ant", "patternset");
        element.setAttributeNS(null, "id", string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Element element2 = this.document.createElementNS("antlib:org.apache.tools.ant", "include");
                element2.setAttributeNS(null, "name", stringArray[n]);
                element.appendChild(element2);
                ++n;
            }
        }
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                Element element3 = this.document.createElementNS("antlib:org.apache.tools.ant", "exclude");
                element3.setAttributeNS(null, "name", stringArray2[n]);
                element.appendChild(element3);
                ++n;
            }
        }
        return element;
    }

    public void saveProperties(URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer textBuffer = null;
                try {
                    textBuffer = textNode.acquireTextBuffer();
                    textBuffer.removeToEnd(0);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.properties.store(byteArrayOutputStream, null);
                    String string = byteArrayOutputStream.toString("8859_1");
                    textBuffer.insert(0, string.toCharArray());
                    UpdateMessage.fireStructureChanged((Subject)textNode);
                }
                finally {
                    if (textBuffer != null) {
                        textNode.releaseTextBuffer();
                    }
                }
            }
            node.save();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    private class PathRoot {
        private URL url;
        private String property;

        public PathRoot(String string, URL uRL) {
            this.property = string;
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

