/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.ant.Target;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdeveloper.library.JDK;
import oracle.jdevimpl.ant.AntModel;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.TargetImpl;
import oracle.jdevimpl.ant.parser.AntParser;
import oracle.jdevimpl.ant.parser.PropertyFilePropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyProviderListener;
import oracle.jdevimpl.ant.parser.SimplePropertyProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;

public class AntContextImpl
implements PropertyProviderListener,
AntContext {
    private XmlContext xmlContext;
    private AntParser parser;
    private String projectName;
    private String projectDescription;
    private File baseDir;
    private String defaultTarget;
    private HashMap targets;
    private HashMap targetCache;
    private boolean targetsDirty;
    private LinkedList propertyProviders;
    private HashMap propertyCache;
    private HashMap idCache;
    private boolean propertiesDirty;
    private ArrayList imports;
    private ArrayList importingContexts;
    private FileUtils fileUtils;
    private HashSet alreadySeen;

    void $init$() {
        this.targets = new HashMap();
        this.targetCache = new HashMap();
        this.targetsDirty = true;
        this.propertyProviders = new LinkedList();
        this.propertyCache = new HashMap();
        this.idCache = new HashMap();
        this.propertiesDirty = true;
        this.imports = new ArrayList();
        this.importingContexts = new ArrayList();
        this.fileUtils = FileUtils.newFileUtils();
        this.alreadySeen = new HashSet();
    }

    public AntContextImpl(XmlContext xmlContext) {
        this.$init$();
        this.xmlContext = xmlContext;
        this.parser = new AntParser(this);
        xmlContext.getModel().addModelListener((XmlModelListener)new ModelListener(null));
    }

    public XmlContext getXmlContext() {
        return this.xmlContext;
    }

    private void addImportingContext(AntContextImpl antContextImpl) {
        if (!this.importingContexts.contains(antContextImpl)) {
            this.importingContexts.add(antContextImpl);
        }
    }

    private void removeImportingContext(AntContextImpl antContextImpl) {
        this.importingContexts.remove(antContextImpl);
    }

    private List getImportingContexts() {
        return this.importingContexts;
    }

    public URL getBuildfile() {
        return ((JDevXmlContext)this.xmlContext).getIdeDocument().getURL();
    }

    public File resolveFile(String string) {
        if (this.baseDir == null && !FileUtils.isAbsolutePath((String)string)) {
            return null;
        }
        try {
            File file = this.fileUtils.resolveFile(this.baseDir, string);
            return file;
        }
        catch (BuildException buildException) {
            File file = null;
            return file;
        }
    }

    public URL resolveImport(String string) {
        URL uRL = URLFileSystem.getParent((URL)this.getBuildfile());
        if (uRL != null) {
            File file = new File(URLFileSystem.getPlatformPathName((URL)uRL));
            try {
                File file2 = this.fileUtils.resolveFile(file, string);
                URL uRL2 = URLFactory.newFileURL((File)file2);
                return uRL2;
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return null;
    }

    public AntContextImpl getAntContext(URL uRL) {
        AntContextImpl antContextImpl = null;
        XmlModel xmlModel = this.xmlContext.getRelatedXmlModel(uRL);
        if (xmlModel instanceof AntModel) {
            antContextImpl = (AntContextImpl)((AntModel)xmlModel).getAntContext();
        }
        return antContextImpl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public Target getDefaultTarget() {
        return this.getTarget(this.defaultTarget);
    }

    public List getTargets() {
        this.loadTargets();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.targetCache.entrySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getValue());
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public Target getTarget(String string) {
        Target target = (Target)this.targets.get(string);
        if (target == null) {
            this.loadTargets();
            target = (Target)this.targetCache.get(string);
        }
        return target;
    }

    public List getPropertyNames() {
        this.loadProperties();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.propertyCache.keySet());
        arrayList.trimToSize();
        return arrayList;
    }

    public String getProperty(String string) {
        this.loadProperties();
        return (String)this.propertyCache.get(string);
    }

    public List getImports() {
        return this.imports;
    }

    public String getDefaultTargetName() {
        return this.defaultTarget;
    }

    public List getTargetsInternal() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.targets.entrySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getValue());
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public String resolveProperties(String string) {
        return this.resolveProperties(string, false);
    }

    public String resolveProperties(String string, boolean bl) {
        this.loadProperties();
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n, matcher.start(1)));
            String string2 = matcher.group(2);
            String string3 = this.getProperty(string2);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                if (bl) {
                    return null;
                }
                stringBuffer.append(matcher.group(1));
            }
            n = matcher.end(1);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    private void dumpCaches() {
        this.dumpPropertyCache();
        this.dumpTargetCache();
    }

    private void dumpPropertyCache() {
        if (!this.propertiesDirty) {
            this.propertiesDirty = true;
            this.propertyCache.clear();
            this.idCache.clear();
        }
    }

    private void dumpTargetCache() {
        if (!this.targetsDirty) {
            this.targetsDirty = true;
            this.targetCache.clear();
        }
    }

    private void loadProperties() {
        if (this.propertiesDirty) {
            this.propertiesDirty = false;
            this.addBuiltInProperties();
            this.addJavaProperties();
            HashSet<URL> hashSet = new HashSet<URL>();
            hashSet.add(this.getBuildfile());
            this.addConfigurationProperties(hashSet);
            this.getProperties(this.propertyCache, this.idCache, hashSet);
        }
    }

    private void addBuiltInProperties() {
        File file = new File(URLFileSystem.getPlatformPathName((URL)this.getBuildfile()));
        this.addProperty("ant.file", file.getAbsolutePath());
        String string = "";
        String string2 = "";
        URL uRL = null;
        JDevXmlContext jDevXmlContext = (JDevXmlContext)this.xmlContext;
        Project project = jDevXmlContext.getProject();
        AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration();
        if (antRunConfiguration != null) {
            AntVersion antVersion = null;
            uRL = antRunConfiguration.getAntHome();
            if (uRL != null) {
                antVersion = AntVersion.createAntVersion(uRL);
            }
            if (antVersion == null) {
                antVersion = AntVersion.getDefaultAntVersion();
                uRL = antVersion.getAntHome();
            }
            string = antVersion.getVersionString();
            JDK jDK = antRunConfiguration.getJDK(project);
            VersionNumber versionNumber = jDK.getJavaVersion();
            if (versionNumber.countParts() >= 2) {
                StringBuffer stringBuffer = new StringBuffer(3);
                stringBuffer.append(versionNumber.getPart(0));
                stringBuffer.append(".");
                stringBuffer.append(versionNumber.getPart(1));
                string2 = stringBuffer.toString();
            }
        }
        this.addProperty("ant.version", string);
        this.addProperty("ant.java.version", string2);
        if (uRL != null) {
            String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
            this.addProperty("ant.home", string3);
        } else {
            this.addProperty("ant.home", "");
        }
    }

    private void addJavaProperties() {
        String string = "";
        String string2 = "";
        AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration();
        if (antRunConfiguration != null) {
            JDevXmlContext jDevXmlContext = (JDevXmlContext)this.xmlContext;
            Project project = jDevXmlContext.getProject();
            JDK jDK = antRunConfiguration.getJDK(project);
            VersionNumber versionNumber = jDK.getJavaVersion();
            string = versionNumber.toString();
            URL uRL = URLFileSystem.getParent((URL)jDK.getSDKBinDir());
            if (uRL != null) {
                string2 = URLFileSystem.getPlatformPathName((URL)uRL);
            }
        }
        this.addProperty("file.separator", System.getProperty("file.separator"));
        this.addProperty("line.separator", System.getProperty("line.separator"));
        this.addProperty("path.separator", System.getProperty("path.separator"));
        this.addProperty("os.arch", System.getProperty("os.arch"));
        this.addProperty("os.name", System.getProperty("os.name"));
        this.addProperty("os.version", System.getProperty("os.version"));
        this.addProperty("user.dir", System.getProperty("user.dir"));
        this.addProperty("user.home", System.getProperty("user.home"));
        this.addProperty("user.name", System.getProperty("user.name"));
        this.addProperty("java.home", string2);
        this.addProperty("java.version", string);
        this.addProperty("java.class.path", "");
        this.addProperty("java.class.version", "");
        this.addProperty("java.vendor", "");
        this.addProperty("java.vendor.url", "");
    }

    private void addConfigurationProperties(Set set) {
        MacroRegistry macroRegistry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration();
        if (antRunConfiguration != null) {
            JDevXmlContext jDevXmlContext = (JDevXmlContext)this.xmlContext;
            Context context = JDevXmlContext.createContext((JDevXmlContext)jDevXmlContext);
            Iterator iterator = antRunConfiguration.getPropertyNames().iterator();
            Iterator iterator2 = antRunConfiguration.getPropertyValues().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)iterator2.next();
                this.addProperty(string, macroRegistry.expand(string2, context));
            }
            Iterator iterator3 = antRunConfiguration.getPropertyFiles().iterator();
            while (iterator3.hasNext()) {
                URL uRL = URLFactory.newFileURL((String)((String)iterator3.next()));
                this.addPropertyProvider(new PropertyFilePropertyProvider(uRL, null));
                set.add(uRL);
            }
        }
    }

    private AntRunConfiguration getAntRunConfiguration() {
        AntRunConfiguration antRunConfiguration = null;
        JDevXmlContext jDevXmlContext = (JDevXmlContext)this.xmlContext;
        Project project = jDevXmlContext.getProject();
        if (project != null) {
            antRunConfiguration = AntRunConfiguration.getInstance((PropertyStorage)project);
        }
        return antRunConfiguration;
    }

    private void loadTargets() {
        if (this.targetsDirty) {
            this.targetCache.putAll(this.targets);
            HashSet<URL> hashSet = new HashSet<URL>();
            hashSet.add(this.getBuildfile());
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(this.imports);
            while (!linkedList.isEmpty()) {
                URL uRL = (URL)linkedList.removeFirst();
                if (hashSet.contains(uRL)) continue;
                AntContextImpl antContextImpl = this.getAntContext(uRL);
                if (antContextImpl != null) {
                    Iterator iterator = antContextImpl.getTargetsInternal().iterator();
                    while (iterator.hasNext()) {
                        TargetImpl targetImpl = new TargetImpl(this, (Target)iterator.next());
                        if (this.targetCache.containsKey(targetImpl.getName())) {
                            String string = antContextImpl.getProjectName();
                            if (string == null) continue;
                            targetImpl.setName(string + "." + targetImpl.getName());
                        }
                        targetImpl.setImported(true);
                        this.targetCache.put(targetImpl.getName(), targetImpl);
                    }
                    linkedList.addAll(0, antContextImpl.getImports());
                }
                hashSet.add(uRL);
            }
            this.targetsDirty = false;
        }
    }

    public void getProperties(Map map, Map map2, Set set) {
        for (PropertyProvider propertyProvider : this.propertyProviders) {
            propertyProvider.getProperties(this, map, map2, set);
        }
    }

    public void setProjectName(String string) {
        this.projectName = string;
        this.addProperty("ant.project.name", string, null);
    }

    public void setProjectDescription(String string) {
        this.projectDescription = string;
    }

    public void setBaseDir(String string) {
        URL uRL = URLFileSystem.getParent((URL)this.getBuildfile());
        File file = new File(URLFileSystem.getPlatformPathName((URL)uRL));
        if (string == null) {
            this.baseDir = file;
        } else {
            try {
                this.baseDir = this.fileUtils.resolveFile(file, string);
            }
            catch (BuildException buildException) {
                this.baseDir = null;
            }
        }
        if (this.baseDir != null) {
            this.addProperty("basedir", this.baseDir.getPath(), null);
        } else {
            this.addProperty("basedir", string, null);
        }
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public void addTarget(Target target) {
        this.targets.put(target.getName(), target);
    }

    public void addImport(URL uRL) {
        if (!uRL.equals(this.getBuildfile())) {
            this.imports.add(uRL);
            AntContextImpl antContextImpl = this.getAntContext(uRL);
            if (antContextImpl != null) {
                antContextImpl.addImportingContext(this);
                String string = antContextImpl.getProjectName();
                if (string != null) {
                    String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
                    this.addProperty("ant.file." + string, string2);
                }
            }
        }
    }

    public String resolveId(String string) {
        this.loadProperties();
        return (String)this.idCache.get(string);
    }

    public void addId(String string, String string2) {
        this.addProperty(null, string2, string);
    }

    public void addProperty(String string, String string2) {
        this.addProperty(string, string2, null);
    }

    public void addProperty(String string, String string2, String string3) {
        SimplePropertyProvider simplePropertyProvider;
        if (!this.propertyProviders.isEmpty() && this.propertyProviders.getLast() instanceof SimplePropertyProvider) {
            simplePropertyProvider = (SimplePropertyProvider)this.propertyProviders.getLast();
        } else {
            simplePropertyProvider = new SimplePropertyProvider();
            this.propertyProviders.add(simplePropertyProvider);
        }
        simplePropertyProvider.addProperty(string, string2, string3);
        if (string != null && !this.propertyCache.containsKey(string)) {
            this.propertyCache.put(string, string2);
        }
        if (string3 != null) {
            this.idCache.put(string3, string2);
        }
    }

    public void addPropertyProvider(PropertyProvider propertyProvider) {
        this.propertyProviders.add(propertyProvider);
        propertyProvider.addPropertyProviderListener(this);
        propertyProvider.getProperties(this, this.propertyCache, this.idCache, this.alreadySeen);
    }

    private void reset() {
        this.projectName = null;
        this.projectDescription = null;
        this.baseDir = null;
        this.defaultTarget = null;
        this.targets.clear();
        this.dumpCaches();
        for (URL uRL : this.imports) {
            AntContextImpl antContextImpl = this.getAntContext(uRL);
            if (antContextImpl == null) continue;
            antContextImpl.removeImportingContext(this);
        }
        this.imports.clear();
        for (PropertyProvider propertyProvider : this.propertyProviders) {
            propertyProvider.removePropertyProviderListener(this);
            propertyProvider.dispose();
        }
        this.propertyProviders.clear();
        this.alreadySeen.clear();
    }

    public void parseDocument() {
        XmlModel xmlModel = this.xmlContext.getModel();
        xmlModel.acquireReadLock();
        try {
            this.propertiesDirty = false;
            this.alreadySeen.add(this.getBuildfile());
            this.addBuiltInProperties();
            this.addJavaProperties();
            this.addConfigurationProperties(this.alreadySeen);
            Document document = xmlModel.getDocument();
            if (document != null) {
                this.parser.parse(document);
            }
        }
        finally {
            xmlModel.releaseReadLock();
            this.propertiesDirty = true;
        }
    }

    private void dumpImportingContextCaches() {
        HashSet<URL> hashSet = new HashSet<URL>();
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.importingContexts);
        while (!linkedList.isEmpty()) {
            AntContextImpl antContextImpl = (AntContextImpl)linkedList.removeFirst();
            URL uRL = antContextImpl.getBuildfile();
            if (hashSet.contains(uRL)) continue;
            antContextImpl.dumpCaches();
            linkedList.addAll(antContextImpl.getImportingContexts());
            hashSet.add(uRL);
        }
    }

    public void propertiesChanged(PropertyProvider propertyProvider) {
        this.dumpCaches();
        this.dumpImportingContextCaches();
    }

    static void mav$reset(AntContextImpl antContextImpl) {
        antContextImpl.reset();
    }

    static void mav$dumpImportingContextCaches(AntContextImpl antContextImpl) {
        antContextImpl.dumpImportingContextCaches();
    }

    private class ModelListener
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent xmlModelEvent) {
            if (xmlModelEvent.isDomDocumentChanged() || xmlModelEvent.isDomTreeChanged()) {
                AntContextImpl.mav$reset(AntContextImpl.this);
                AntContextImpl.this.parseDocument();
                AntContextImpl.mav$dumpImportingContextCaches(AntContextImpl.this);
            }
        }

        private ModelListener() {
        }

        ModelListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

