/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.compiler.ant.AntConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.AntOptions;
import oracle.jdevimpl.ant.ProjectBuildfilePanel;
import oracle.jdevimpl.ant.TargetImpl;
import oracle.jdevimpl.ant.runner.AntDebuggingProcess;
import oracle.jdevimpl.ant.runner.AntRunConfigurationDialog;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AntController
implements Observer,
ContextMenuListener,
Controller {
    private static IdeAction runAntAction;
    private static IdeAction debugAntAction;
    private static IdeAction runTargetAction;
    private static IdeAction debugTargetAction;
    private static IdeAction goToImportAction;
    private static IdeAction runProjectBuildfileAction;
    private static IdeAction manageSettingsAction;
    private static final int RUN_ANT_CMD_ID;
    private static final int DEBUG_ANT_CMD_ID;
    private static final int RUN_TARGET_CMD_ID;
    private static final int DEBUG_TARGET_CMD_ID;
    private static final int GO_TO_IMPORT_CMD_ID;
    private static final int RUN_PROJECT_ANT_CMD_ID;
    private static final int MANAGE_ANT_SETTINGS_CMD_ID;
    private JMenuItem runProjectBuildfileItem;
    private Project activeProject;
    private static final float RUN_TARGET_SECTION = 1.0f;
    private static final float RUN_TARGET_ADVANCED_SECTION = 2.0f;

    static {
        RUN_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_ANT_CMD_ID");
        DEBUG_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.DEBUG_ANT_CMD_ID");
        RUN_TARGET_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_TARGET_CMD_ID");
        DEBUG_TARGET_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.DEBUG_TARGET_CMD_ID");
        GO_TO_IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.GO_TO_IMPORT_CMD_ID");
        RUN_PROJECT_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_PROJECT_ANT_CMD_ID");
        MANAGE_ANT_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.MANAGE_ANT_SETTINGS_CMD_ID");
    }

    public AntController() {
        this.createActions();
        Ide.getSystem().attach((Observer)this);
        Project.addProjectChangeListener((String)AntConfiguration.DATA_KEY, (ProjectChangeListener)new ProjectListener(null));
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (object == Ide.getSystem()) {
            if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                if (this.activeProject != null) {
                    this.activeProject.detach((Observer)this);
                }
                this.activeProject = Ide.getActiveProject();
                if (this.activeProject != null) {
                    this.activeProject.attach((Observer)this);
                }
                this.updateTargetList(this.activeProject);
            }
        } else if (object instanceof Project) {
            if (n == UpdateMessage.CHILD_REMOVED) {
                this.projectFilesRemoved((Project)object, updateMessage.getRemoveObjects());
            } else if (n == UpdateMessage.CHILD_RENAMED) {
                this.projectFileRenamed((Project)object, updateMessage);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RUN_TARGET_CMD_ID) {
            Node node;
            String string = this.getTarget(context);
            if (string != null && (node = context.getNode()) != null) {
                Project project;
                this.saveNode(context);
                URL uRL = node.getURL();
                if (uRL != null && (project = context.getProject()) != null) {
                    AntRunConfiguration antRunConfiguration = AntRunConfiguration.getInstance((PropertyStorage)project);
                    AntRunConfiguration antRunConfiguration2 = new AntRunConfiguration();
                    antRunConfiguration.copyTo((Object)antRunConfiguration2);
                    antRunConfiguration2.setBuildfile(uRL);
                    antRunConfiguration2.setTargetList(Collections.singletonList(string));
                    AntManager.getAntManager().runAntNonBlocking(context, antRunConfiguration2, null);
                }
            }
            return true;
        }
        if (n == DEBUG_TARGET_CMD_ID) {
            Node node;
            String string = this.getTarget(context);
            if (string != null && (node = context.getNode()) != null) {
                this.saveNode(context);
                URL uRL = node.getURL();
                if (uRL != null) {
                    this.debugAnt(context, uRL, string);
                }
            }
        } else {
            if (n == RUN_ANT_CMD_ID) {
                Node node = context.getNode();
                if (node != null) {
                    AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration(context);
                    antRunConfiguration.setBuildfile(node.getURL());
                    AntRunConfigurationDialog antRunConfigurationDialog = new AntRunConfigurationDialog(antRunConfiguration);
                    if (antRunConfigurationDialog.run(context, (Component)Ide.getMainWindow(), false)) {
                        this.saveNode(context);
                        AntManager.getAntManager().runAntNonBlocking(context, antRunConfiguration, null);
                    }
                }
                return true;
            }
            if (n == DEBUG_ANT_CMD_ID) {
                Node node = context.getNode();
                if (node != null) {
                    AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration(context);
                    antRunConfiguration.setBuildfile(node.getURL());
                    AntRunConfigurationDialog antRunConfigurationDialog = new AntRunConfigurationDialog(antRunConfiguration);
                    if (antRunConfigurationDialog.run(context, (Component)Ide.getMainWindow(), false)) {
                        this.debugAnt(antRunConfiguration, context);
                    }
                }
                return true;
            }
            if (n == RUN_PROJECT_ANT_CMD_ID) {
                Project project = Ide.getActiveProject();
                if (project != null) {
                    AntManager antManager = AntManager.getAntManager();
                    URL uRL = antManager.getProjectBuildfile(project);
                    if (uRL == null && ProjectBuildfilePanel.runDialog(project)) {
                        uRL = antManager.getProjectBuildfile(project);
                    }
                    if (uRL != null) {
                        String string = antManager.getDefaultTarget(project);
                        antManager.runAntNonBlocking(context, uRL, string, null);
                    }
                }
                return true;
            }
            if (n == GO_TO_IMPORT_CMD_ID) {
                URL uRL = this.getImport(context);
                if (uRL != null) {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)uRL);
                        if (node != null) {
                            EditorUtil.openExplicitDefaultEditorInFrame((Node)NodeFactory.find((URL)uRL));
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (n == MANAGE_ANT_SETTINGS_CMD_ID) {
                Project project = Ide.getActiveProject();
                if (project != null) {
                    String[] stringArray = new String[]{AntArb.getString(8)};
                    ProjectPropertiesDialog.showDialog((Frame)Ide.getMainWindow(), (Project)project, (String[])stringArray);
                }
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RUN_TARGET_CMD_ID || n == DEBUG_TARGET_CMD_ID || n == RUN_ANT_CMD_ID || n == DEBUG_ANT_CMD_ID || n == GO_TO_IMPORT_CMD_ID) {
            ideAction.setEnabled(context.getNode() instanceof AntNode);
            return true;
        }
        if (n == RUN_PROJECT_ANT_CMD_ID) {
            String string;
            Project project = Ide.getActiveProject();
            ideAction.setEnabled(project != null);
            if (project != null) {
                MessageFormat messageFormat = new MessageFormat(AntArb.getString(141));
                string = messageFormat.format(new Object[]{project.getShortLabel()});
            } else {
                string = AntArb.getString(139);
            }
            this.runProjectBuildfileItem.setText(string);
            ideAction.putValue("Name", (Object)string);
            return true;
        }
        if (n == MANAGE_ANT_SETTINGS_CMD_ID) {
            Project project = Ide.getActiveProject();
            ideAction.setEnabled(project != null);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Node node = contextMenu.getContext().getNode();
        if (node instanceof AntNode) {
            boolean bl = false;
            View view = contextMenu.getContext().getView();
            if (view instanceof ExplorerWindow) {
                URL uRL;
                String string = this.getTarget(contextMenu.getContext());
                if (string != null) {
                    bl = true;
                    String string2 = AntArb.format(37, string);
                    runTargetAction.putValue("Name", (Object)string2);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)runTargetAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                    string2 = AntArb.format(226, string);
                    debugTargetAction.putValue("Name", (Object)string2);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)debugTargetAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
                if ((uRL = this.getImport(contextMenu.getContext())) != null && URLFileSystem.exists((URL)uRL)) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)goToImportAction), MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
                }
            }
            if (!bl) {
                Context context = contextMenu.getContext();
                AntContext antContext = AntManager.getAntManager().getAntContext(node.getURL(), context.getProject());
                List list = antContext.getTargets();
                if (!list.isEmpty()) {
                    JMenu jMenu = this.createTargetMenu(context, node, list, AntArb.getString(220), AntArb.getInteger(221), false);
                    contextMenu.add((Component)jMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                    JMenu jMenu2 = this.createTargetMenu(context, node, list, AntArb.getString(224), AntArb.getInteger(225), true);
                    contextMenu.add((Component)jMenu2, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void createActions() {
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        String string = jMenu.getText();
        runAntAction = IdeAction.get((int)RUN_ANT_CMD_ID, null, (String)AntArb.getString(34), (String)string, (Integer)AntArb.getInteger(35), null, null, null, (boolean)true);
        runAntAction.addController((Controller)this);
        runTargetAction = IdeAction.get((int)RUN_TARGET_CMD_ID, null, (String)AntArb.getString(37), (String)string, (Integer)AntArb.getInteger(38), (ArrayResourceBundle)AntArb.getInstance(), (int)25, null, (boolean)true);
        runTargetAction.addController((Controller)this);
        debugAntAction = IdeAction.get((int)DEBUG_ANT_CMD_ID, null, (String)AntArb.getString(34), (String)string, (Integer)AntArb.getInteger(35), null, null, null, (boolean)true);
        debugAntAction.addController((Controller)this);
        debugTargetAction = IdeAction.get((int)DEBUG_TARGET_CMD_ID, null, (String)AntArb.getString(226), (String)string, (Integer)AntArb.getInteger(227), (ArrayResourceBundle)AntArb.getInstance(), (int)25, null, (boolean)true);
        debugTargetAction.addController((Controller)this);
        goToImportAction = IdeAction.get((int)GO_TO_IMPORT_CMD_ID, null, (String)AntArb.getString(212), (String)string, (Integer)AntArb.getInteger(213), null, null, null, (boolean)true);
        goToImportAction.addController((Controller)this);
        runProjectBuildfileAction = IdeAction.get((int)RUN_PROJECT_ANT_CMD_ID, null, (String)AntArb.getString(139), (String)string, (Integer)AntArb.getInteger(140), (ArrayResourceBundle)AntArb.getInstance(), (int)142, null, (boolean)true);
        runProjectBuildfileAction.addController((Controller)this);
        runProjectBuildfileAction.putValue("NoCtxName", (Object)AntArb.getString(139));
        runProjectBuildfileAction.putValue("ActionMenuActions", (Object)new IdeAction[]{manageSettingsAction});
        Menubar menubar = Ide.getMenubar();
        this.runProjectBuildfileItem = menubar.createMenuItem((ToggleAction)runProjectBuildfileAction, JDeveloperMenuConstants.WEIGHT_RUN_ANT);
        menubar.add((Component)this.runProjectBuildfileItem, jMenu, JDeveloperMenuConstants.SECTION_RUN_MAKE_REBUILD);
        manageSettingsAction = IdeAction.get((int)MANAGE_ANT_SETTINGS_CMD_ID, null, (String)AntArb.getString(214), (String)string, (Integer)AntArb.getInteger(215), null, null, (boolean)true);
        manageSettingsAction.addController((Controller)this);
    }

    private String getTarget(Context context) {
        XmlView xmlView;
        String string = null;
        JDevXmlContext jDevXmlContext = JDevXmlContext.getXmlContext((Context)context);
        if (jDevXmlContext != null && (xmlView = jDevXmlContext.getActiveView()) != null) {
            Selection selection = xmlView.getSelection();
            try {
                selection.acquireModelReadLock();
                if (selection.size() == 1) {
                    org.w3c.dom.Node node = selection.getSelectedNodesArray()[0];
                    string = this.getTarget(node);
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
        return string;
    }

    private String getTarget(org.w3c.dom.Node node) {
        Element element;
        Attr attr;
        if (node != null && node.getNodeType() == 1 && this.isAntNamespace(node.getNamespaceURI()) && "target".equals(node.getLocalName()) && (attr = (element = (Element)node).getAttributeNodeNS(null, "name")) != null) {
            return attr.getValue();
        }
        return null;
    }

    private URL getImport(Context context) {
        XmlView xmlView;
        URL uRL = null;
        JDevXmlContext jDevXmlContext = JDevXmlContext.getXmlContext((Context)context);
        if (jDevXmlContext != null && (xmlView = jDevXmlContext.getActiveView()) != null) {
            Selection selection = xmlView.getSelection();
            try {
                selection.acquireModelReadLock();
                if (selection.size() == 1) {
                    org.w3c.dom.Node node = selection.getSelectedNodesArray()[0];
                    uRL = this.getImport(context, node);
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
        return uRL;
    }

    private URL getImport(Context context, org.w3c.dom.Node node) {
        Element element;
        Attr attr;
        if (node != null && node.getNodeType() == 1 && this.isAntNamespace(node.getNamespaceURI()) && "import".equals(node.getLocalName()) && (attr = (element = (Element)node).getAttributeNodeNS(null, "file")) != null) {
            String string;
            AntContext antContext;
            String string2 = attr.getValue();
            Node node2 = context.getNode();
            if (node2 != null && (antContext = AntManager.getAntManager().getAntContext(node2.getURL(), context.getProject())) != null && (string = antContext.resolveProperties(string2, true)) != null) {
                return ((AntContextImpl)antContext).resolveImport(string);
            }
        }
        return null;
    }

    private boolean isAntNamespace(String string) {
        return string == null || "antlib:org.apache.tools.ant".equals(string);
    }

    private void saveNode(Context context) {
        Node node = context.getNode();
        if (node != null && node.isDirty()) {
            try {
                node.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void updateTargetList(Project project) {
        AntManager antManager;
        List list;
        Action[] actionArray = null;
        if (project != null && project.isOpen() && (list = (antManager = AntManager.getAntManager()).getTargetList(project)).size() > 0) {
            int n = list.size() + 2;
            Icon icon = AntArb.getIcon(25);
            actionArray = new Action[n];
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                4 var10_10 = new 4(string, icon);
                actionArray[n2] = var10_10;
                ++n2;
            }
            actionArray[n - 2] = null;
            actionArray[n - 1] = manageSettingsAction;
        }
        if (actionArray == null) {
            actionArray = new Action[]{manageSettingsAction};
        }
        SwingUtilities.invokeLater(new MenuActionUpdater(actionArray));
    }

    private void projectFilesRemoved(Project project, List list) {
        AntConfiguration antConfiguration = AntConfiguration.getAntConfiguration((PropertyStorage)project);
        URL uRL = antConfiguration.getProjectBuildfile();
        if (uRL != null) {
            for (Object e : list) {
                if (!(e instanceof Locatable) || !((Locatable)e).getURL().equals(uRL)) continue;
                antConfiguration.setProjectBuildfile(null);
                antConfiguration.setTargetList(null);
                antConfiguration.setMakeTarget(null);
                antConfiguration.setRebuildTarget(null);
                project.markDirty(true);
            }
        }
    }

    private void projectFileRenamed(Project project, UpdateMessage updateMessage) {
        Node node;
        URL uRL;
        AntConfiguration antConfiguration = AntConfiguration.getAntConfiguration((PropertyStorage)project);
        URL uRL2 = antConfiguration.getProjectBuildfile();
        if (uRL2 != null && (uRL = RenameMessage.getOldURL((UpdateMessage)updateMessage)) != null && URLFileSystem.equals((URL)uRL, (URL)uRL2) && (node = RenameMessage.getRenamedNode((UpdateMessage)updateMessage)) != null) {
            antConfiguration.setProjectBuildfile(node.getURL());
            project.markDirty(true);
        }
    }

    private JMenu createTargetMenu(Context context, Node node, List list, String string, Integer n, boolean bl) {
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = menubar.createSubMenu(string, n, Float.MAX_VALUE, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        jMenu.addMenuListener(new 3(this, jMenu, context, node, list, bl));
        return jMenu;
    }

    private void createTargetSubmenu(Context context, URL uRL, JMenu jMenu, List list, boolean bl) {
        Collections.sort(list);
        AntOptions antOptions = this.getAntOptions();
        boolean bl2 = antOptions.getShowOnlyMainTargets();
        boolean bl3 = antOptions.getShowImportedTargets();
        boolean bl4 = false;
        int n = 0;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(list.size());
        Menubar menubar = Ide.getMenubar();
        Icon icon = AntArb.getIcon(25);
        for (TargetImpl targetImpl : list) {
            boolean bl5;
            if (!bl3 && targetImpl.isImported()) continue;
            boolean bl6 = bl5 = targetImpl.getDescription() != null;
            if (bl2 && !bl4 && bl5) {
                bl4 = true;
                arrayList.clear();
                n = 0;
            }
            if (bl2 && bl4 && !bl5) continue;
            String string = targetImpl.getName();
            2 var18_18 = new 2(this, string, icon, bl, context, uRL, string);
            JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)var18_18, Float.MAX_VALUE);
            n += jMenuItem.getPreferredSize().height;
            arrayList.add(jMenuItem);
        }
        if (arrayList.size() > 0) {
            int n2 = ((JMenuItem)arrayList.get((int)0)).getToolkit().getScreenSize().height;
            if (n > n2 * 9 / 10) {
                int n3 = arrayList.size();
                int n4 = n2 * 9 / 10;
                int n5 = n / n4 + 1;
                int n6 = arrayList.size() / n5 + 1;
                int n7 = n6 + 1;
                JMenu jMenu2 = null;
                int n8 = 0;
                while (n8 < n3) {
                    JMenuItem jMenuItem = (JMenuItem)arrayList.get(n8);
                    if (n7 >= n6) {
                        String string = jMenuItem.getText();
                        int n9 = Math.min(n8 + n6, n3) - 1;
                        JMenuItem jMenuItem2 = (JMenuItem)arrayList.get(n9);
                        String string2 = jMenuItem2.getText();
                        jMenu2 = new JMenu(string + " - " + string2);
                        menubar.add((Component)jMenu2, jMenu, 1.0f);
                        n7 = 0;
                    }
                    jMenu2.add(jMenuItem);
                    ++n7;
                    ++n8;
                }
            } else {
                for (JMenuItem jMenuItem : arrayList) {
                    menubar.add((Component)jMenuItem, jMenu, 1.0f);
                }
            }
        }
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)(bl ? debugAntAction : runAntAction));
        menubar.add((Component)jMenuItem, jMenu, 2.0f);
    }

    private AntOptions getAntOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (AntOptions)clientSetting.getData("AntOptions");
    }

    private void debugAnt(Context context, URL uRL, String string) {
        AntRunConfiguration antRunConfiguration = this.getAntRunConfiguration(context);
        antRunConfiguration.setBuildfile(uRL);
        antRunConfiguration.addTarget(string);
        this.debugAnt(antRunConfiguration, context);
    }

    private void debugAnt(AntRunConfiguration antRunConfiguration, Context context) {
        this.saveNode(context);
        AntDebuggingProcess antDebuggingProcess = new AntDebuggingProcess(antRunConfiguration, context);
        HashMap hashMap = new HashMap();
        NodeUtil.storeAllTimestamps(hashMap);
        antDebuggingProcess.setRunProcessListener(new 1(this, hashMap, antDebuggingProcess));
        antDebuggingProcess.start();
    }

    private AntRunConfiguration getAntRunConfiguration(Context context) {
        AntRunConfiguration antRunConfiguration = new AntRunConfiguration();
        Project project = context.getProject();
        if (project != null) {
            AntRunConfiguration antRunConfiguration2 = AntRunConfiguration.getInstance((PropertyStorage)project);
            antRunConfiguration2.copyTo((Object)antRunConfiguration);
        }
        return antRunConfiguration;
    }

    static void mav$createTargetSubmenu(AntController antController, Context context, URL uRL, JMenu jMenu, List list, boolean bl) {
        antController.createTargetSubmenu(context, uRL, jMenu, list, bl);
    }

    static void mav$debugAnt(AntController antController, Context context, URL uRL, String string) {
        antController.debugAnt(context, uRL, string);
    }

    static IdeAction ra$runProjectBuildfileAction() {
        return runProjectBuildfileAction;
    }

    static Project ra$activeProject(AntController antController) {
        return antController.activeProject;
    }

    static void mav$updateTargetList(AntController antController, Project project) {
        antController.updateTargetList(project);
    }

    public final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AntManager antManager;
            URL uRL;
            Project project = Ide.getActiveProject();
            if (project != null && (uRL = (antManager = AntManager.getAntManager()).getProjectBuildfile(project)) != null) {
                String string = (String)this.getValue("Name");
                Context context = Context.newIdeContext();
                antManager.runAntNonBlocking(context, uRL, string, null);
            }
        }

        public 4(String string, Icon icon) {
            super(string, icon);
        }
    }

    public final class 3
    implements MenuListener {
        private final /* synthetic */ JMenu v$targetMenu;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ List v$targets;
        private final /* synthetic */ boolean v$debug;
        final /* synthetic */ AntController this$0;

        public void menuSelected(MenuEvent menuEvent) {
            if (this.v$targetMenu.getMenuComponentCount() == 0) {
                AntController.mav$createTargetSubmenu(this.this$0, this.v$context, this.v$node.getURL(), this.v$targetMenu, this.v$targets, this.v$debug);
            }
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public 3(AntController antController, JMenu jMenu, Context context, Node node, List list, boolean bl) {
            this.v$debug = bl;
            this.v$targets = list;
            this.v$node = node;
            this.v$context = context;
            this.v$targetMenu = jMenu;
            this.this$0 = antController;
        }
    }

    public final class 2
    extends ToggleAction {
        private final /* synthetic */ boolean v$debug;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ URL v$buildfile;
        private final /* synthetic */ String v$name;
        final /* synthetic */ AntController this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.v$debug) {
                AntController.mav$debugAnt(this.this$0, this.v$context, this.v$buildfile, this.v$name);
            } else {
                AntManager antManager = AntManager.getAntManager();
                antManager.runAntNonBlocking(this.v$context, this.v$buildfile, this.v$name, null);
            }
        }

        public 2(AntController antController, String string, Icon icon, boolean bl, Context context, URL uRL, String string2) {
            this.v$name = string2;
            this.v$buildfile = uRL;
            this.v$context = context;
            this.v$debug = bl;
            this.this$0 = antController;
            super(string, icon);
        }
    }

    public final class 1
    implements RunProcessListener {
        private final /* synthetic */ HashMap v$timestampMap;
        private final /* synthetic */ AntDebuggingProcess v$process;
        final /* synthetic */ AntController this$0;

        public void processFinished(int n) {
            NodeUtil.reloadBuffers((Map)this.v$timestampMap);
            this.v$process.setRunProcessListener(null);
        }

        public 1(AntController antController, HashMap hashMap, AntDebuggingProcess antDebuggingProcess) {
            this.v$process = antDebuggingProcess;
            this.v$timestampMap = hashMap;
            this.this$0 = antController;
        }
    }

    private class MenuActionUpdater
    implements Runnable {
        private Action[] actions;

        public MenuActionUpdater(Action[] actionArray) {
            this.actions = actionArray;
        }

        public void run() {
            AntController.ra$runProjectBuildfileAction().putValue("ActionMenuActions", (Object)this.actions);
        }
    }

    private class ProjectListener
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            Project project = projectChangeEvent.getProject();
            if (AntController.ra$activeProject(AntController.this) == project) {
                AntController.mav$updateTargetList(AntController.this, project);
            }
        }

        public void projectOpened(Project project) {
            if (AntController.ra$activeProject(AntController.this) == project) {
                AntController.mav$updateTargetList(AntController.this, project);
            }
        }

        private ProjectListener() {
        }

        ProjectListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

