/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntOptions;

public class AntOptionsPanel
extends DefaultTraversablePanel {
    private CustomColorChoice errColor;
    private CustomColorChoice warnColor;
    private CustomColorChoice infoColor;
    private CustomColorChoice verboseColor;
    private CustomColorChoice debugColor;
    private JCheckBox showMain;
    private JCheckBox showImported;

    void $init$() {
        this.errColor = new CustomColorChoice();
        this.warnColor = new CustomColorChoice();
        this.infoColor = new CustomColorChoice();
        this.verboseColor = new CustomColorChoice();
        this.debugColor = new CustomColorChoice();
        this.showMain = new JCheckBox();
        this.showImported = new JCheckBox();
    }

    public AntOptionsPanel() {
        this.$init$();
        this.setHelpID("f1_ant_prefs_html");
        this.jbInit();
    }

    public void onEntry(TraversableContext traversableContext) {
        AntOptions antOptions = this.getAntOptions(traversableContext);
        this.errColor.setClosestSelectedColor(new Color(antOptions.getErrColor()));
        this.warnColor.setClosestSelectedColor(new Color(antOptions.getWarnColor()));
        this.infoColor.setClosestSelectedColor(new Color(antOptions.getInfoColor()));
        this.verboseColor.setClosestSelectedColor(new Color(antOptions.getVerboseColor()));
        this.debugColor.setClosestSelectedColor(new Color(antOptions.getDebugColor()));
        this.showMain.setSelected(antOptions.getShowOnlyMainTargets());
        this.showImported.setSelected(antOptions.getShowImportedTargets());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        AntOptions antOptions = this.getAntOptions(traversableContext);
        antOptions.setErrColor(this.errColor.getSelectedColor().getRGB());
        antOptions.setWarnColor(this.warnColor.getSelectedColor().getRGB());
        antOptions.setInfoColor(this.infoColor.getSelectedColor().getRGB());
        antOptions.setVerboseColor(this.verboseColor.getSelectedColor().getRGB());
        antOptions.setDebugColor(this.debugColor.getSelectedColor().getRGB());
        antOptions.setShowOnlyMainTargets(this.showMain.isSelected());
        antOptions.setShowImportedTargets(this.showImported.isSelected());
    }

    private AntOptions getAntOptions(TraversableContext traversableContext) {
        return (AntOptions)((Object)traversableContext.find("AntOptions"));
    }

    private void jbInit() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 5, 3);
        this.add((Component)this.errColor, AntArb.getString(127), gridBagConstraints);
        this.add((Component)this.warnColor, AntArb.getString(128), gridBagConstraints);
        this.add((Component)this.infoColor, AntArb.getString(129), gridBagConstraints);
        this.add((Component)this.verboseColor, AntArb.getString(130), gridBagConstraints);
        this.add((Component)this.debugColor, AntArb.getString(131), gridBagConstraints);
        ResourceUtils.resButton((AbstractButton)this.showMain, (String)AntArb.getString(222));
        ResourceUtils.resButton((AbstractButton)this.showImported, (String)AntArb.getString(223));
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add(this.showMain, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        this.add(this.showImported, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(new JLabel(), gridBagConstraints);
    }

    private void add(Component component, String string, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)component, (String)string);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 3;
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 4;
        this.add(component, gridBagConstraints);
    }
}

