/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;

public class AntTooltipProvider
implements EditorListener,
CEToolTipProvider {
    private boolean enabled;
    private final Pattern pattern;

    void $init$() {
        this.enabled = true;
        this.pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int n) {
        if (!this.enabled) {
            return null;
        }
        try {
            int n2 = codeEditor.getLineFromOffset(n);
            int n3 = codeEditor.getLineStartOffset(n2);
            int n4 = codeEditor.getLineEndOffset(n2);
            int n5 = n - n3;
            n3 = Math.max(n3, n - 100);
            n4 = Math.min(n4, n + 100);
            String string = codeEditor.getText(n3, n4 - n3);
            Matcher matcher = this.pattern.matcher(string);
            String string2 = null;
            while (matcher.find()) {
                if (matcher.start(1) > n5 || matcher.end(1) < n5) continue;
                string2 = matcher.group(2);
                break;
            }
            if (string2 != null) {
                Context context = codeEditor.getContext();
                Node node = context.getNode();
                URL uRL = node.getURL();
                AntContext antContext = AntManager.getAntManager().getAntContext(uRL, context.getProject());
                String string3 = antContext.getProperty(string2);
                if (string3 != null && string3.trim().length() == 0) {
                    string3 = null;
                }
                String string4 = string3;
                return string4;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            Context context = editor.getContext();
            Node node = context.getNode();
            if (node instanceof AntNode) {
                codeEditor.addCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void editorClosed(Editor editor) {
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public AntTooltipProvider() {
        this.$init$();
    }
}

