/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.Copyable;

public class AntVersion
implements Copyable {
    public static final String VERSION_PROPERTY = "Version";
    private static final String BUILT_IN_ANT_VERSION = "apache-ant-1.6.5";
    private VersionNumber version;
    private String versionString;
    private URL antHome;
    private static final String ANT_MAIN_CLASS = "org.apache.tools.ant.Main";
    private static final String ANT_VERSION_METHOD = "getAntVersion";
    private static final String ANT_VERSION_PATTERN = "(?:Apache )?Ant version\\s*(\\d+\\.\\d+(?:\\.\\d+)?(?:\\.\\d+)?).*";
    private static final AntVersion defaultAntVersion;

    static {
        URL uRL = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)BUILT_IN_ANT_VERSION);
        defaultAntVersion = AntVersion.createAntVersion(uRL2);
    }

    private AntVersion() {
    }

    public static AntVersion getDefaultAntVersion() {
        return defaultAntVersion;
    }

    public static AntVersion createAntVersion(URL uRL) {
        URLPath uRLPath = AntVersion.getClassPath(uRL);
        URL[] uRLArray = uRLPath.getEntries();
        if (uRLArray.length > 0) {
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
            try {
                Class<?> clazz = uRLClassLoader.loadClass(ANT_MAIN_CLASS);
                Method method = clazz.getMethod(ANT_VERSION_METHOD, null);
                String string = (String)method.invoke(null, null);
                Pattern pattern = Pattern.compile(ANT_VERSION_PATTERN);
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    VersionNumber versionNumber = new VersionNumber(matcher.group(1));
                    AntVersion antVersion = new AntVersion();
                    antVersion.version = versionNumber;
                    antVersion.versionString = string;
                    antVersion.antHome = uRL;
                    AntVersion antVersion2 = antVersion;
                    return antVersion2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getAntHome() {
        return this.antHome;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public URLPath getClassPath() {
        return AntVersion.getClassPath(this.antHome);
    }

    private static URLPath getClassPath(URL uRL) {
        URLPath uRLPath = new URLPath();
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)"lib");
        URL[] uRLArray = URLFileSystem.list((URL)uRL2);
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                if (!URLFileSystem.isDirectory((URL)uRLArray[n]) && URLFileSystem.getFileName((URL)uRLArray[n]).toLowerCase().endsWith(".jar")) {
                    uRLPath.add(uRLArray[n]);
                }
                ++n;
            }
        }
        return uRLPath;
    }

    public Object copyTo(Object object) {
        AntVersion antVersion = object != null ? (AntVersion)object : new AntVersion();
        this.copyToImpl(antVersion);
        return antVersion;
    }

    protected void copyToImpl(AntVersion antVersion) {
        antVersion.antHome = this.antHome;
        antVersion.version = this.version;
        antVersion.versionString = this.versionString;
    }

    public boolean equals(Object object) {
        return object instanceof AntVersion ? this.equalsImpl((AntVersion)object) : false;
    }

    protected boolean equalsImpl(AntVersion antVersion) {
        return ModelUtil.areEqual((Object)antVersion.antHome, (Object)this.antHome) && ModelUtil.areEqual((Object)antVersion.version, (Object)this.version) && ModelUtil.areEqual((Object)antVersion.versionString, (Object)this.versionString);
    }
}

