/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.jdev.explorer.XmlExplorer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.explorer.AntExplorerOptions;
import oracle.jdevimpl.java.JavaArb;

public class AntExplorer
extends XmlExplorer
implements PropertyChangeListener,
Controller {
    private IdeAction showOnlyMainTargetsAction;
    private IdeAction showPropertiesAction;
    private IdeAction showTopLevelAction;
    private IdeAction sortAlphabeticallyAction;
    private IdeAction sortByLocationAction;
    private IdeAction sortByTypeAction;
    private ArrayList toolbarButtons;
    private IdeAction localShowOnlyMainTargetsAction;
    private IdeAction localShowPropertiesAction;
    private IdeAction localShowTopLevelAction;
    private IdeAction[] localSortActions;
    private static final int SHOW_MAIN_TARGETS_ONLY_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowMainTargetsOnly");
    private static final int SHOW_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowProperties");
    private static final int SHOW_TOP_LEVEL_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowTopLevel");
    private static final int SORT_BY_LOCATION_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortByLocation");
    private static final int SORT_ALPHABETICALLY_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortAlphabetically");
    private static final int SORT_BY_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortByType");
    private static final String SORT_GROUP_NAME = "AntExplorerSortGroup";

    public AntExplorer() {
        this.createActions();
        AntExplorer.getAntExplorerOptions().addPropertyChangeListener(this);
    }

    public void stateChanged(int n) {
        super.stateChanged(n);
        switch (n) {
            case 0: {
                SwingUtilities.invokeLater(new 2());
                break;
            }
            case 1: {
                this.hideToolbarButtons();
                break;
            }
            case 2: {
                AntExplorer.getAntExplorerOptions().removePropertyChangeListener(this);
                this.removeToolbarButtons();
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ant_struct_html");
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SHOW_MAIN_TARGETS_ONLY_CMD_ID) {
            AntExplorerOptions antExplorerOptions = AntExplorer.getAntExplorerOptions();
            antExplorerOptions.setShowMainTargetsOnly(ideAction.getState());
            return true;
        }
        if (n == SHOW_PROPERTIES_CMD_ID) {
            AntExplorerOptions antExplorerOptions = AntExplorer.getAntExplorerOptions();
            antExplorerOptions.setShowProperties(ideAction.getState());
            return true;
        }
        if (n == SHOW_TOP_LEVEL_CMD_ID) {
            AntExplorerOptions antExplorerOptions = AntExplorer.getAntExplorerOptions();
            antExplorerOptions.setShowTopLevelElements(ideAction.getState());
            return true;
        }
        if (n == SORT_BY_LOCATION_CMD_ID || n == SORT_ALPHABETICALLY_CMD_ID || n == SORT_BY_TYPE_CMD_ID) {
            int n2 = 0;
            if (n == SORT_ALPHABETICALLY_CMD_ID) {
                n2 = 1;
            } else if (n == SORT_BY_TYPE_CMD_ID) {
                n2 = 2;
            } else if (n == SORT_ALPHABETICALLY_CMD_ID) {
                n2 = 1;
            }
            AntExplorerOptions antExplorerOptions = AntExplorer.getAntExplorerOptions();
            antExplorerOptions.setSortOrder(n2);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        return n == SHOW_MAIN_TARGETS_ONLY_CMD_ID || n == SHOW_PROPERTIES_CMD_ID || n == SHOW_TOP_LEVEL_CMD_ID || n == SORT_ALPHABETICALLY_CMD_ID || n == SORT_BY_TYPE_CMD_ID || n == SORT_BY_LOCATION_CMD_ID;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("AntExplorerOptions".equals(propertyChangeEvent.getPropertyName())) {
            1 var2_2 = new 1();
            SwingUtilities.invokeLater(var2_2);
        }
    }

    private static AntExplorerOptions getAntExplorerOptions() {
        IdeSettings ideSettings = Ide.getSettings();
        AntExplorerOptions antExplorerOptions = (AntExplorerOptions)ideSettings.getData("AntExplorerOptions");
        if (antExplorerOptions == null) {
            antExplorerOptions = new AntExplorerOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("AntExplorerOptions", (Copyable)antExplorerOptions);
        }
        return antExplorerOptions;
    }

    private void createActions() {
        this.showOnlyMainTargetsAction = IdeAction.get((int)SHOW_MAIN_TARGETS_ONLY_CMD_ID, null, (String)AntArb.getString(26), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)AntArb.getInstance(), (int)25, null, (boolean)true);
        this.showOnlyMainTargetsAction.addController((Controller)this);
        this.showPropertiesAction = IdeAction.get((int)SHOW_PROPERTIES_CMD_ID, null, (String)AntArb.getString(27), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (Icon)CommonIconsUtils.getPropertyIcon(), null, (boolean)true);
        this.showPropertiesAction.addController((Controller)this);
        this.showTopLevelAction = IdeAction.get((int)SHOW_TOP_LEVEL_CMD_ID, null, (String)AntArb.getString(28), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)AntArb.getInstance(), (int)33, null, (boolean)true);
        this.showTopLevelAction.addController((Controller)this);
        this.sortByLocationAction = IdeAction.get((int)SORT_BY_LOCATION_CMD_ID, null, (String)AntArb.getString(31), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)91, null, (boolean)true);
        this.sortByLocationAction.addController((Controller)this);
        this.sortAlphabeticallyAction = IdeAction.get((int)SORT_ALPHABETICALLY_CMD_ID, null, (String)AntArb.getString(30), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)92, null, (boolean)true);
        this.sortAlphabeticallyAction.addController((Controller)this);
        this.sortByTypeAction = IdeAction.get((int)SORT_BY_TYPE_CMD_ID, null, (String)AntArb.getString(32), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)93, null, (boolean)true);
        this.sortByTypeAction.addController((Controller)this);
        this.sortByLocationAction.setState(false);
        this.sortAlphabeticallyAction.setState(false);
        this.sortByTypeAction.setState(false);
        this.sortByLocationAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortAlphabeticallyAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortByTypeAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortByLocationAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this.sortAlphabeticallyAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this.sortByTypeAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
    }

    private void addToolbarButtons() {
        Toolbar toolbar;
        View view = this.owner();
        Toolbar toolbar2 = toolbar = view != null ? view.getToolbar() : null;
        if (toolbar != null) {
            toolbar.addSeparator();
            if (this.toolbarButtons == null) {
                this.toolbarButtons = new ArrayList();
                IdeAction[] ideActionArray = IdeAction.findGroup((String)SORT_GROUP_NAME);
                int n = ideActionArray.length;
                this.localSortActions = new IdeAction[n];
                int n2 = 0;
                while (n2 < n) {
                    this.localSortActions[n2] = ideActionArray[n2].newLocalAction((View)this);
                    ++n2;
                }
                this.toolbarButtons.add(toolbar.addMenuButton((ToggleAction[])this.localSortActions));
                this.localShowPropertiesAction = this.showPropertiesAction.newLocalAction((View)this);
                this.localShowTopLevelAction = this.showTopLevelAction.newLocalAction((View)this);
                this.localShowOnlyMainTargetsAction = this.showOnlyMainTargetsAction.newLocalAction((View)this);
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowPropertiesAction));
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowTopLevelAction));
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowOnlyMainTargetsAction));
                this.toolbarButtons.trimToSize();
            } else {
                int n = 0;
                while (n < this.toolbarButtons.size()) {
                    toolbar.add((Component)((AbstractButton)this.toolbarButtons.get(n)));
                    ++n;
                }
            }
        }
    }

    private void hideToolbarButtons() {
        Toolbar toolbar;
        View view = this.owner();
        Toolbar toolbar2 = toolbar = view != null ? view.getToolbar() : null;
        if (toolbar != null && this.toolbarButtons != null) {
            int n = 0;
            while (n < this.toolbarButtons.size()) {
                toolbar.remove((Component)((AbstractButton)this.toolbarButtons.get(n)));
                ++n;
            }
        }
    }

    private void removeToolbarButtons() {
        this.hideToolbarButtons();
        if (this.toolbarButtons != null) {
            int n = 0;
            while (n < this.toolbarButtons.size()) {
                AbstractButton abstractButton = (AbstractButton)this.toolbarButtons.get(n);
                abstractButton.setAction(null);
                ++n;
            }
            this.toolbarButtons.clear();
            this.toolbarButtons = null;
        }
        this.localSortActions = null;
        this.localShowOnlyMainTargetsAction = null;
        this.localShowPropertiesAction = null;
        this.localShowTopLevelAction = null;
    }

    private void updateToolbarActions() {
        AntExplorerOptions antExplorerOptions = AntExplorer.getAntExplorerOptions();
        if (this.localShowOnlyMainTargetsAction != null) {
            this.localShowOnlyMainTargetsAction.setState(antExplorerOptions.getShowMainTargetsOnly());
        }
        if (this.localShowPropertiesAction != null) {
            this.localShowPropertiesAction.setState(antExplorerOptions.getShowProperties());
        }
        if (this.localShowTopLevelAction != null) {
            this.localShowTopLevelAction.setState(antExplorerOptions.getShowTopLevelElements());
        }
        if (this.localSortActions != null) {
            int n = antExplorerOptions.getSortOrder();
            int n2 = SORT_BY_LOCATION_CMD_ID;
            switch (n) {
                case 1: {
                    n2 = SORT_ALPHABETICALLY_CMD_ID;
                    break;
                }
                case 2: {
                    n2 = SORT_BY_TYPE_CMD_ID;
                    break;
                }
                case 0: {
                    n2 = SORT_BY_LOCATION_CMD_ID;
                }
            }
            int n3 = this.localSortActions.length;
            int n4 = 0;
            while (n4 < n3) {
                if (this.localSortActions[n4].getCommandId() == n2) {
                    this.localSortActions[n4].setState(true);
                    break;
                }
                ++n4;
            }
        }
    }

    static void mav$addToolbarButtons(AntExplorer antExplorer) {
        antExplorer.addToolbarButtons();
    }

    static void mav$updateToolbarActions(AntExplorer antExplorer) {
        antExplorer.updateToolbarActions();
    }

    public final class 2
    implements Runnable {
        public void run() {
            AntExplorer.mav$addToolbarButtons(AntExplorer.this);
            AntExplorer.mav$updateToolbarActions(AntExplorer.this);
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            AntExplorer.mav$updateToolbarActions(AntExplorer.this);
        }
    }
}

