/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import oracle.bali.xml.share.PropertyChange;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.ant.explorer.AntExplorerOptions;
import oracle.jdevimpl.ant.explorer.SortedTreeTraversal;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AntExplorerView
extends FilteredView {
    private SortedTreeTraversal sortedTraversal;
    private AntExplorerOptionsListener optionsListener;
    private int sortOrder;
    private static final int TYPE_PROJECT = 0;
    private static final int TYPE_TARGET = 1;
    private static final int TYPE_PROPERTY = 2;
    private static final int TYPE_TASK = 3;
    private static final int TYPE_UNKNOWN = 4;

    protected void postCreationHook() {
        super.postCreationHook();
        if (this.getDocument() != null) {
            this.optionsListener = new AntExplorerOptionsListener(null);
            AntExplorerView.getAntExplorerOptions().addPropertyChangeListener(this.optionsListener);
        }
    }

    protected short acceptNode(Node node) {
        short s = node.getNodeType();
        if (s == 1 && "antlib:org.apache.tools.ant".equals(node.getNamespaceURI())) {
            Element element;
            Attr attr;
            AntExplorerOptions antExplorerOptions = AntExplorerView.getAntExplorerOptions();
            if (!antExplorerOptions.getShowTopLevelElements() && this.isTopLevel(node) && !"target".equals(node.getLocalName())) {
                return 2;
            }
            if (antExplorerOptions.getShowMainTargetsOnly() && "target".equals(node.getLocalName()) && (attr = (element = (Element)node).getAttributeNodeNS(null, "description")) == null) {
                return 2;
            }
            if (!antExplorerOptions.getShowProperties() && "property".equals(node.getLocalName())) {
                return 2;
            }
        } else if (s == 8 || s == 10) {
            return 2;
        }
        return 1;
    }

    protected TreeTraversal createTreeTraversal() {
        this.sortOrder = AntExplorerView.getAntExplorerOptions().getSortOrder();
        TreeTraversal treeTraversal = super.createTreeTraversal();
        this.sortedTraversal = new SortedTreeTraversal(treeTraversal, this.getComparator(this.sortOrder));
        return this.sortedTraversal;
    }

    protected void handleModelChangeEvent(XmlModelEvent xmlModelEvent) {
        PropertyChange propertyChange;
        super.handleModelChangeEvent(xmlModelEvent);
        if (xmlModelEvent.isDomTreeChanged()) {
            this.sortedTraversal.clearCaches();
        }
        if (xmlModelEvent.isPropertyChanged() && (propertyChange = xmlModelEvent.getDomDocumentPropertyChange()) != null) {
            if (propertyChange.getNewValue() == null) {
                AntExplorerView.getAntExplorerOptions().removePropertyChangeListener(this.optionsListener);
                this.optionsListener = null;
            } else if (this.optionsListener == null) {
                this.optionsListener = new AntExplorerOptionsListener(null);
                AntExplorerView.getAntExplorerOptions().addPropertyChangeListener(this.optionsListener);
                this.updateSortOrder();
            }
        }
    }

    protected String getDisplayName(Node node) {
        return this.getXmlMetadataResolver().getMediumDisplayName(node);
    }

    private Comparator getComparator(int n) {
        Comparator comparator;
        switch (n) {
            case 1: {
                comparator = new AlphabeticalNodeComparator();
                break;
            }
            case 2: {
                comparator = new TypeNodeComparitor();
                break;
            }
            default: {
                comparator = null;
            }
        }
        return comparator;
    }

    private void updateSortOrder() {
        int n = AntExplorerView.getAntExplorerOptions().getSortOrder();
        if (n != this.sortOrder) {
            this.sortOrder = n;
            Comparator comparator = this.getComparator(this.sortOrder);
            this.sortedTraversal.setComparator(comparator);
        }
    }

    private static AntExplorerOptions getAntExplorerOptions() {
        IdeSettings ideSettings = Ide.getSettings();
        AntExplorerOptions antExplorerOptions = (AntExplorerOptions)ideSettings.getData("AntExplorerOptions");
        if (antExplorerOptions == null) {
            antExplorerOptions = new AntExplorerOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("AntExplorerOptions", (Copyable)antExplorerOptions);
        }
        return antExplorerOptions;
    }

    private boolean isTopLevel(Node node) {
        Node node2 = node.getParentNode();
        return node2 != null && (node2 = node2.getParentNode()) != null && node2.getNodeType() == 9;
    }

    static void mav$updateSortOrder(AntExplorerView antExplorerView) {
        antExplorerView.updateSortOrder();
    }

    static SortedTreeTraversal ra$sortedTraversal(AntExplorerView antExplorerView) {
        return antExplorerView.sortedTraversal;
    }

    private class AlphabeticalNodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            return AntExplorerView.this.getDisplayName(node).compareTo(AntExplorerView.this.getDisplayName(node2));
        }
    }

    private class TypeNodeComparitor
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            Node node = (Node)object;
            Node node2 = (Node)object2;
            int n2 = this.getType(node);
            if (n2 != (n = this.getType(node2))) {
                return n2 - n;
            }
            return AntExplorerView.this.getDisplayName(node).compareTo(AntExplorerView.this.getDisplayName(node2));
        }

        private int getType(Node node) {
            if (node.getNodeType() == 1 && "antlib:org.apache.tools.ant".equals(node.getNamespaceURI())) {
                String string = node.getLocalName();
                if ("project".equals(string)) {
                    return 0;
                }
                if ("target".equals(string)) {
                    return 1;
                }
                if ("property".equals(string)) {
                    return 2;
                }
                return 3;
            }
            return 4;
        }
    }

    private class AntExplorerOptionsListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("AntExplorerOptions".equals(propertyChangeEvent.getPropertyName())) {
                AntExplorerView.mav$updateSortOrder(AntExplorerView.this);
                AntExplorerView.ra$sortedTraversal(AntExplorerView.this).clearCaches();
                AntExplorerView.this.getBaseModel().getDomModel().forceReparse();
            }
        }

        private AntExplorerOptionsListener() {
        }

        AntExplorerOptionsListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

