/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import org.w3c.dom.Node;

public class SortedTreeTraversal
extends TreeTraversal {
    private TreeTraversal beforeTraversal;
    private List childCache;
    private Comparator comparator;

    public SortedTreeTraversal(TreeTraversal treeTraversal, Comparator comparator) {
        this.beforeTraversal = treeTraversal;
        this.comparator = comparator;
    }

    public void clearCaches() {
        if (this.childCache != null) {
            this.childCache.clear();
            this.childCache = null;
        }
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.clearCaches();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Node getParentNode(Node node) {
        return this.beforeTraversal.getParentNode(node);
    }

    public Node getFirstChild(Node node) {
        if (this.comparator != null && this.isRootElement(node)) {
            List list = this.getSortedChildList(node);
            return list.size() > 0 ? (Node)list.get(0) : null;
        }
        return this.beforeTraversal.getFirstChild(node);
    }

    public Node getLastChild(Node node) {
        if (this.comparator != null && this.isRootElement(node)) {
            List list = this.getSortedChildList(node);
            return list.size() > 0 ? (Node)list.get(list.size() - 1) : null;
        }
        return this.beforeTraversal.getLastChild(node);
    }

    public Node getNextSibling(Node node) {
        Node node2;
        if (this.comparator != null && (node2 = node.getParentNode()) != null && this.isRootElement(node2)) {
            List list = this.getSortedChildList(node2);
            int n = list.indexOf(node);
            return list.size() > n + 1 ? (Node)list.get(n + 1) : null;
        }
        return this.beforeTraversal.getNextSibling(node);
    }

    public Node getPreviousSibling(Node node) {
        Node node2;
        if (this.comparator != null && (node2 = node.getParentNode()) != null && this.isRootElement(node2)) {
            List list = this.getSortedChildList(node2);
            int n = list.indexOf(node);
            return n > 0 ? (Node)list.get(n - 1) : null;
        }
        return this.beforeTraversal.getNextSibling(node);
    }

    private List getSortedChildList(Node node) {
        if (this.childCache == null) {
            int n = this.beforeTraversal.getChildCount(node);
            if (n > 0) {
                this.childCache = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    this.childCache.add(this.beforeTraversal.getChild(node, n2));
                    ++n2;
                }
                Collections.sort(this.childCache, this.comparator);
                ((ArrayList)this.childCache).trimToSize();
            } else {
                this.childCache = Collections.EMPTY_LIST;
            }
        }
        return this.childCache;
    }

    private boolean isRootElement(Node node) {
        Node node2;
        return node.getNodeType() == 1 && (node2 = node.getParentNode()) != null && node2.getNodeType() == 9;
    }
}

