/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.extension;

import java.net.MalformedURLException;
import java.net.URL;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdevimpl.ant.registry.AntRegistry;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.PropertyInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public final class AntHookHandler
extends ExtensionHook {
    private static final String NAMESPACE = "http://xmlns.oracle.com/jdeveloper/1013/jdev-ant";
    private static final String KEY_ANTLIB = "Ant-antlib";
    private static final String KEY_TASK = "Ant-task";
    private static final String KEY_TYPE = "Ant-type";
    private static final String KEY_PROPERTY = "Ant-property";
    private static final String KEY_CLASSPATH = "Ant-classpath";
    private static final String KEY_BASEDIR = "Ant-basedir";
    private static final String KEY_JARFILE = "Ant-jarfile";
    private final ElementVisitor antlibHandler;
    private final ElementVisitor taskHandler;
    private final ElementVisitor typeHandler;
    private final ElementVisitor propertyHandler;
    private final ElementVisitor taskGroupHandler;
    private final ElementVisitor typeGroupHandler;
    private final ElementVisitor displayNameHandler;
    private final ElementVisitor classPathHandler;

    void $init$() {
        this.antlibHandler = new AntlibHandler(null);
        this.taskHandler = new TaskHandler(null);
        this.typeHandler = new TypeHandler(null);
        this.propertyHandler = new PropertyHandler(null);
        this.taskGroupHandler = new TaskGroupHandler(null);
        this.typeGroupHandler = new TypeGroupHandler(null);
        this.displayNameHandler = new DisplayNameHandler(null);
        this.classPathHandler = new ClassPathHandler(null);
    }

    private static final ElementName ns(String string) {
        return new ElementName(NAMESPACE, string);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(AntHookHandler.ns("antlib"), this.antlibHandler);
        elementStartContext.registerChildVisitor(AntHookHandler.ns("task"), this.taskHandler);
        elementStartContext.registerChildVisitor(AntHookHandler.ns("type"), this.typeHandler);
        elementStartContext.registerChildVisitor(AntHookHandler.ns("property"), this.propertyHandler);
        try {
            URL uRL = elementStartContext.getExtensionSourceURI().toURL();
            if (uRL != null) {
                elementStartContext.getScopeData().put(KEY_BASEDIR, this.getDirectory(uRL));
                if (JarUtil.isJarURL((URL)uRL)) {
                    elementStartContext.getScopeData().put(KEY_JARFILE, JarUtil.getJarFileURL((URL)uRL));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private URL getDirectory(URL uRL) {
        uRL = JarUtil.getJarFileURL((URL)uRL);
        return URLFileSystem.getParent((URL)uRL);
    }

    private void getURLPath(URLPath uRLPath, String string, URL uRL) {
        String[] stringArray = string.split(";");
        int n = 0;
        while (n < stringArray.length) {
            uRLPath.add(URLFactory.newURL((URL)uRL, (String)stringArray[n]));
            ++n;
        }
    }

    public AntHookHandler() {
        this.$init$();
    }

    static ElementName maS$ns(String string) {
        return AntHookHandler.ns(string);
    }

    static ElementVisitor ra$displayNameHandler(AntHookHandler antHookHandler) {
        return antHookHandler.displayNameHandler;
    }

    static ElementVisitor ra$classPathHandler(AntHookHandler antHookHandler) {
        return antHookHandler.classPathHandler;
    }

    static ElementVisitor ra$taskGroupHandler(AntHookHandler antHookHandler) {
        return antHookHandler.taskGroupHandler;
    }

    static ElementVisitor ra$typeGroupHandler(AntHookHandler antHookHandler) {
        return antHookHandler.typeGroupHandler;
    }

    static void mav$getURLPath(AntHookHandler antHookHandler, URLPath uRLPath, String string, URL uRL) {
        antHookHandler.getURLPath(uRLPath, string, uRL);
    }

    private class AntlibHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("displayName"), AntHookHandler.ra$displayNameHandler(AntHookHandler.this));
            elementStartContext.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            AntlibInfo antlibInfo = new AntlibInfo();
            antlibInfo.setNamespace(elementStartContext.getAttributeValue("namespace"));
            antlibInfo.setFile(elementStartContext.getAttributeValue("file"));
            antlibInfo.setSchema(elementStartContext.getAttributeValue("schema"));
            Extension extension = elementStartContext.getExtension();
            antlibInfo.setExtension(extension.getName());
            elementStartContext.getScopeData().put(AntHookHandler.KEY_ANTLIB, antlibInfo);
        }

        public void end(ElementEndContext elementEndContext) {
            AntRegistry antRegistry = AntRegistry.getExtensionAntRegistry();
            AntlibInfo antlibInfo = (AntlibInfo)((Object)elementEndContext.getScopeData().get(AntHookHandler.KEY_ANTLIB));
            antlibInfo.setClassPath((URLPath)elementEndContext.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            antRegistry.addAntlib(antlibInfo);
        }

        private AntlibHandler() {
        }

        AntlibHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TaskHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("group"), AntHookHandler.ra$taskGroupHandler(AntHookHandler.this));
            elementStartContext.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setName(elementStartContext.getAttributeValue("name"));
            taskInfo.setNamespace(elementStartContext.getAttributeValue("namespace"));
            taskInfo.setClassName(elementStartContext.getAttributeValue("class"));
            try {
                URL uRL = new URL(elementStartContext.getAttributeValue("documentation"));
                taskInfo.setDocumentation(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            Extension extension = elementStartContext.getExtension();
            taskInfo.setExtension(extension.getName());
            elementStartContext.getScopeData().put(AntHookHandler.KEY_TASK, taskInfo);
        }

        public void end(ElementEndContext elementEndContext) {
            AntRegistry antRegistry = AntRegistry.getExtensionAntRegistry();
            TaskInfo taskInfo = (TaskInfo)((Object)elementEndContext.getScopeData().get(AntHookHandler.KEY_TASK));
            taskInfo.setClassPath((URLPath)elementEndContext.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            antRegistry.addTask(taskInfo);
        }

        private TaskHandler() {
        }

        TaskHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TypeHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("group"), AntHookHandler.ra$typeGroupHandler(AntHookHandler.this));
            elementStartContext.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            elementStartContext.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.setName(elementStartContext.getAttributeValue("name"));
            typeInfo.setNamespace(elementStartContext.getAttributeValue("namespace"));
            typeInfo.setClassName(elementStartContext.getAttributeValue("class"));
            Extension extension = elementStartContext.getExtension();
            typeInfo.setExtension(extension.getName());
            elementStartContext.getScopeData().put(AntHookHandler.KEY_TYPE, typeInfo);
        }

        public void end(ElementEndContext elementEndContext) {
            AntRegistry antRegistry = AntRegistry.getExtensionAntRegistry();
            TypeInfo typeInfo = (TypeInfo)((Object)elementEndContext.getScopeData().get(AntHookHandler.KEY_TYPE));
            typeInfo.setClassPath((URLPath)elementEndContext.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            antRegistry.addType(typeInfo);
        }

        private TypeHandler() {
        }

        TypeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PropertyHandler
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.setName(elementStartContext.getAttributeValue("name"));
            propertyInfo.setValue(elementStartContext.getAttributeValue("value"));
            Extension extension = elementStartContext.getExtension();
            propertyInfo.setExtension(extension.getName());
            elementStartContext.getScopeData().put(AntHookHandler.KEY_PROPERTY, propertyInfo);
        }

        public void end(ElementEndContext elementEndContext) {
            AntRegistry antRegistry = AntRegistry.getExtensionAntRegistry();
            PropertyInfo propertyInfo = (PropertyInfo)((Object)elementEndContext.getScopeData().get(AntHookHandler.KEY_PROPERTY));
            antRegistry.addProperty(propertyInfo);
        }

        private PropertyHandler() {
        }

        PropertyHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DisplayNameHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            AntlibInfo antlibInfo = (AntlibInfo)((Object)elementContext.getScopeData().get(AntHookHandler.KEY_ANTLIB));
            antlibInfo.setDisplayName(string);
        }

        private DisplayNameHandler() {
        }

        DisplayNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TaskGroupHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            TaskInfo taskInfo = (TaskInfo)((Object)elementContext.getScopeData().get(AntHookHandler.KEY_TASK));
            taskInfo.setGroup(string);
        }

        private TaskGroupHandler() {
        }

        TaskGroupHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TypeGroupHandler
    extends I18NStringVisitor {
        protected void string(ElementContext elementContext, String string) {
            TypeInfo typeInfo = (TypeInfo)((Object)elementContext.getScopeData().get(AntHookHandler.KEY_TYPE));
            typeInfo.setGroup(string);
        }

        private TypeGroupHandler() {
        }

        TypeGroupHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ClassPathHandler
    extends ElementVisitor {
        public void end(ElementEndContext elementEndContext) {
            URL uRL = (URL)elementEndContext.getScopeData().get(AntHookHandler.KEY_BASEDIR);
            URLPath uRLPath = (URLPath)elementEndContext.getScopeData().get(AntHookHandler.KEY_CLASSPATH);
            AntHookHandler.mav$getURLPath(AntHookHandler.this, uRLPath, elementEndContext.getText(), uRL);
            URL uRL2 = (URL)elementEndContext.getScopeData().get(AntHookHandler.KEY_JARFILE);
            if (uRL2 != null) {
                uRLPath.add(uRL2);
            }
        }

        private ClassPathHandler() {
        }

        ClassPathHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

