/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.generator;

import java.net.URL;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.model.PathsConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CopyGenerator
implements AntGenerator {
    private static final String COPY_TARGET = "copy";
    private static final String COPY_TARGET_DESCRIPTION = "Copy files to output directory";
    private static final String COPY_PATTERNS = "copy.patterns";

    public void generate(Project project, AntBuildfile antBuildfile) {
        Project project2;
        if (project instanceof Project && this.hasSrcPath(project2 = project)) {
            this.createCopyTarget(project2, antBuildfile);
        }
    }

    private boolean hasSrcPath(Project project) {
        for (URL uRL : PathsConfiguration.getInstance(project).getProjectSourcePath()) {
            if (!URLFileSystem.exists((URL)uRL)) continue;
            return true;
        }
        return false;
    }

    private void createCopyTarget(Project project, AntBuildfile antBuildfile) {
        Element element = antBuildfile.createTarget(COPY_TARGET, COPY_TARGET_DESCRIPTION);
        OjcConfiguration ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)project);
        String[] stringArray = ojcConfiguration.getCopyRes();
        this.fixPatterns(stringArray);
        boolean bl = ojcConfiguration.getReverseCopyRes();
        Element element2 = bl ? antBuildfile.createPatternSet(COPY_PATTERNS, null, stringArray) : antBuildfile.createPatternSet(COPY_PATTERNS, stringArray, null);
        element.appendChild(element2);
        Document document = antBuildfile.getDocument();
        Element element3 = document.createElementNS("antlib:org.apache.tools.ant", COPY_TARGET);
        element3.setAttributeNS(null, "todir", antBuildfile.createPropertyReference("output.dir"));
        Iterator iterator = PathsConfiguration.getInstance(project).getProjectSourcePath().iterator();
        while (iterator.hasNext()) {
            Element element4 = document.createElementNS("antlib:org.apache.tools.ant", "fileset");
            URL uRL = (URL)iterator.next();
            element4.setAttributeNS(null, "dir", antBuildfile.getRelativePath(uRL));
            element2 = document.createElementNS("antlib:org.apache.tools.ant", "patternset");
            element2.setAttributeNS(null, "refid", COPY_PATTERNS);
            element4.appendChild(element2);
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        antBuildfile.addDependency("all", COPY_TARGET);
        antBuildfile.addDependency(COPY_TARGET, "init");
    }

    private void fixPatterns(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "**/*" + stringArray[n];
            ++n;
        }
    }
}

