/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.generator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.ant.generator.LibraryGenerator;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.ojc.ant.taskdefs.OjcAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaCompilationGenerator
implements AntGenerator {
    public static final String CLASSPATH = "classpath";
    private static final String COMPILE_TARGET = "compile";
    private static final String DEBUG_PROPERTY = "javac.debug";
    private static final String NOWARN_PROPERTY = "javac.nowarn";
    private static final String DEPRECATION_PROPERTY = "javac.deprecation";
    private boolean hasClasspath;
    private boolean hasSrcPath;
    private boolean hasSrcPatterns;

    public void generate(Project project, AntBuildfile antBuildfile) {
        this.hasClasspath = false;
        this.hasSrcPath = false;
        this.hasSrcPatterns = false;
        this.createClassPath(project, antBuildfile);
        this.createCompileTarget(project, antBuildfile);
    }

    private void createClassPath(Project project, AntBuildfile antBuildfile) {
        Document document = antBuildfile.getDocument();
        Element element = document.createElementNS("antlib:org.apache.tools.ant", "path");
        element.setAttributeNS(null, "id", CLASSPATH);
        URLPath uRLPath = new URLPath();
        JProjectPaths jProjectPaths = JProjectPaths.getInstance((PropertyStorage)project);
        uRLPath.add(jProjectPaths.getAdditionalClassPath().getEntries());
        Iterator iterator = DependencyConfiguration.getInstance((Project)project).getDependencies();
        while (iterator.hasNext()) {
            Dependable dependable = (Dependable)iterator.next();
            if (!(dependable instanceof Library)) continue;
            Library library = (Library)dependable;
            uRLPath.add(library.getClassPath());
        }
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            Element element2 = document.createElementNS("antlib:org.apache.tools.ant", "pathelement");
            element2.setAttributeNS(null, "location", antBuildfile.getRelativePath(uRLArray[n]));
            element.appendChild(element2);
            ++n;
        }
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] jLibraryArray = jProjectLibraries.getLibraries();
        int n2 = 0;
        while (n2 < jLibraryArray.length) {
            Element element3 = document.createElementNS("antlib:org.apache.tools.ant", "path");
            element3.setAttributeNS(null, "refid", LibraryGenerator.getPathName(jLibraryArray[n2].getName()));
            element.appendChild(element3);
            ++n2;
        }
        if (element.hasChildNodes()) {
            this.hasClasspath = true;
            antBuildfile.appendBeforeTargets(element);
        }
    }

    private void createCompileTarget(Project project, AntBuildfile antBuildfile) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Stack<ContentSet> stack = new Stack<ContentSet>();
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        stack.push(pathsConfiguration.getJavaContentSet());
        while (!stack.isEmpty()) {
            ContentSet contentSet = (ContentSet)stack.pop();
            Element element = this.getCompileTask(contentSet, project, antBuildfile);
            if (element != null) {
                arrayList.add(element);
            }
            int n = contentSet.countContentSets();
            int n2 = 0;
            while (n2 < n) {
                stack.push(contentSet.getContentSet(n2));
                ++n2;
            }
        }
        if (!arrayList.isEmpty()) {
            Element element = antBuildfile.createTarget(COMPILE_TARGET, "Compile Java source files");
            for (Element element2 : arrayList) {
                element.appendChild(element2);
            }
            antBuildfile.addDependency("all", COMPILE_TARGET);
            antBuildfile.addDependency(COMPILE_TARGET, "init");
        }
    }

    private Element getCompileTask(ContentSet contentSet, Project project, AntBuildfile antBuildfile) {
        Document document = antBuildfile.getDocument();
        Element element = document.createElementNS("antlib:org.apache.tools.ant", "javac");
        element.setAttributeNS(null, "destdir", antBuildfile.createPropertyReference("output.dir"));
        this.setJavacOptions(project, antBuildfile, element);
        URLPath uRLPath = contentSet.getURLPath();
        if (uRLPath.size() > 0) {
            boolean bl = false;
            for (URL uRL : uRLPath) {
                if (!URLFileSystem.exists((URL)uRL)) continue;
                Element element2 = document.createElementNS("antlib:org.apache.tools.ant", "src");
                element2.setAttributeNS(null, "path", antBuildfile.getRelativePath(uRL));
                element.appendChild(element2);
                bl = true;
            }
            if (bl) {
                PatternFilter[] patternFilterArray = contentSet.getPatternFilters().getFilters();
                if (patternFilterArray != null) {
                    int n = 0;
                    while (n < patternFilterArray.length) {
                        Element element3 = this.getPattern(patternFilterArray[n], document);
                        if (element3 != null) {
                            element.appendChild(element3);
                        }
                        ++n;
                    }
                }
                return element;
            }
        }
        return null;
    }

    private Element getPattern(PatternFilter patternFilter, Document document) {
        String string = this.fixPattern(patternFilter.getPattern());
        if (patternFilter.isInclude()) {
            if (!string.equals("**")) {
                Element element = document.createElementNS("antlib:org.apache.tools.ant", "include");
                element.setAttributeNS(null, "name", string);
                return element;
            }
        } else {
            Element element = document.createElementNS("antlib:org.apache.tools.ant", "exclude");
            element.setAttributeNS(null, "name", string);
            return element;
        }
        return null;
    }

    private String fixPattern(String string) {
        if (!string.endsWith("/") && !string.endsWith("*")) {
            string = string + "/";
        }
        return string;
    }

    private void setJavacOptions(Project project, AntBuildfile antBuildfile, Element element) {
        String string;
        String string2;
        OjcConfiguration ojcConfiguration;
        if (this.hasClasspath) {
            element.setAttributeNS(null, "classpathref", CLASSPATH);
        }
        if (!(ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)project)).isUseJavac()) {
            String string3 = OjcAdapter.class.getName();
            antBuildfile.addGlobalProperty("build.compiler", string3);
            if (ojcConfiguration.isShowUnusedImportWarnings()) {
                this.addCompilerArg(antBuildfile, element, string3, "-warn:486");
            }
            if (ojcConfiguration.isShowPartialImportWarnings()) {
                this.addCompilerArg(antBuildfile, element, string3, "-warn:487");
            }
            if (ojcConfiguration.isShowObjectDotStaticWarnings()) {
                this.addCompilerArg(antBuildfile, element, string3, "-warn:320");
            }
            if (ojcConfiguration.isShowSelfDeprecations()) {
                this.addCompilerArg(antBuildfile, element, string3, "-deprecation:self");
            }
            String[] stringArray = ojcConfiguration.getExcludedClasses();
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    if (n < stringArray.length - 1) {
                        stringBuffer.append(";");
                    }
                    ++n;
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "-exclude ");
                Document document = antBuildfile.getDocument();
                Element element2 = document.createElementNS("antlib:org.apache.tools.ant", "compilerarg");
                element2.setAttributeNS(null, "compiler", string3);
                element2.setAttributeNS(null, "line", stringBuffer.toString());
                element.appendChild(element2);
            }
        }
        antBuildfile.addGlobalProperty(DEBUG_PROPERTY, ojcConfiguration.isDebugInformation() ? "on" : "off");
        element.setAttributeNS(null, "debug", antBuildfile.createPropertyReference(DEBUG_PROPERTY));
        antBuildfile.addGlobalProperty(NOWARN_PROPERTY, ojcConfiguration.isShowWarnings() ? "off" : "on");
        element.setAttributeNS(null, "nowarn", antBuildfile.createPropertyReference(NOWARN_PROPERTY));
        antBuildfile.addGlobalProperty(DEPRECATION_PROPERTY, ojcConfiguration.isShowDeprecations() ? "on" : "off");
        element.setAttributeNS(null, "deprecation", antBuildfile.createPropertyReference(DEPRECATION_PROPERTY));
        String string4 = ojcConfiguration.getCurrentEncoding();
        if (!"Default".equals(string4)) {
            element.setAttributeNS(null, "encoding", string4);
        }
        if (!(string2 = ojcConfiguration.getSource()).equals("Default")) {
            element.setAttributeNS(null, "source", string2);
        }
        if (!(string = ojcConfiguration.getTarget()).equals("Default")) {
            element.setAttributeNS(null, "target", string);
        }
    }

    private void addCompilerArg(AntBuildfile antBuildfile, Element element, String string, String string2) {
        Document document = antBuildfile.getDocument();
        Element element2 = document.createElementNS("antlib:org.apache.tools.ant", "compilerarg");
        element2.setAttributeNS(null, "compiler", string);
        element2.setAttributeNS(null, "value", string2);
        element.appendChild(element2);
    }
}

