/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.grammar;

import java.awt.Window;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.LayeredGrammarProvider;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.grammar.AntGrammar;
import oracle.jdevimpl.ant.registry.AntRegistry;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public class AntGrammarProvider
extends LayeredGrammarProvider {
    final LinkedHashMap grammars;
    private static SoftReference baseGrammarRef;
    private static final Object BASE_GRAMMAR_LOCK;
    private static final String ANT_SCHEMA = "/oracle/jdevimpl/ant/ant.xsd";
    private OracleSchemaFactory schemaFactory;
    private JDevXmlContext context;

    void $init$() {
        this.grammars = new LinkedHashMap();
        this.schemaFactory = new OracleSchemaFactory();
    }

    static {
        BASE_GRAMMAR_LOCK = new Object();
    }

    public AntGrammarProvider(GrammarProvider grammarProvider, JDevXmlContext jDevXmlContext) {
        super(grammarProvider);
        this.$init$();
        this.context = jDevXmlContext;
        AntGrammar antGrammar = new AntGrammar(this, "antlib:org.apache.tools.ant");
        antGrammar.setBaseGrammar(this.getBaseAntGrammar());
        this.grammars.put("antlib:org.apache.tools.ant", antGrammar);
        this.loadExtensionGrammars();
    }

    public JDevXmlContext getContext() {
        return this.context;
    }

    protected Map getLayerGrammarMap() {
        return this.grammars;
    }

    protected Grammar getLayerGrammarForNamespace(String string) {
        if (string != null) {
            this.findOrCreateGrammar(string);
        }
        return super.getLayerGrammarForNamespace(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grammar getBaseAntGrammar() {
        Grammar grammar;
        Object object = BASE_GRAMMAR_LOCK;
        synchronized (object) {
            Grammar grammar2 = grammar = baseGrammarRef == null ? null : (Grammar)baseGrammarRef.get();
            if (grammar == null) {
                URL uRL = AntGrammar.class.getResource(ANT_SCHEMA);
                try {
                    OracleSchema[] oracleSchemaArray = this.schemaFactory.buildSchemas(uRL);
                    if (oracleSchemaArray.length > 0) {
                        grammar = oracleSchemaArray[0];
                        baseGrammarRef = new SoftReference<Grammar>(grammar);
                    }
                }
                catch (GrammarException grammarException) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)grammarException));
                }
            }
        }
        return grammar;
    }

    private AntGrammar findOrCreateGrammar(String string) {
        AntGrammar antGrammar = (AntGrammar)this.grammars.get(string);
        if (antGrammar == null) {
            antGrammar = new AntGrammar(this, string);
            this.grammars.put(string, antGrammar);
        }
        return antGrammar;
    }

    private void loadExtensionGrammars() {
        AntRegistry antRegistry = AntRegistry.getExtensionAntRegistry();
        List list = antRegistry.getAntlibList();
        for (AntlibInfo antlibInfo : list) {
            this.loadAntlib(antlibInfo);
        }
        List list2 = antRegistry.getTaskList();
        for (TaskInfo taskInfo : list2) {
            String string = taskInfo.getNamespace();
            if (string == null) {
                string = "antlib:org.apache.tools.ant";
            }
            AntGrammar antGrammar = this.findOrCreateGrammar(string);
            antGrammar.addTask(taskInfo);
        }
        List list3 = antRegistry.getTypeList();
        for (TypeInfo typeInfo : list3) {
            String string = typeInfo.getNamespace();
            if (string == null) {
                string = "antlib:org.apache.tools.ant";
            }
            AntGrammar antGrammar = this.findOrCreateGrammar(string);
            antGrammar.addType(typeInfo);
        }
    }

    private void loadAntlib(AntlibInfo antlibInfo) {
        URLPath uRLPath = antlibInfo.getClassPath();
        String string = antlibInfo.getSchema();
        if (string != null) {
            this.loadSchema(string, uRLPath);
        } else {
            String string2 = antlibInfo.getNamespace();
            if (string2 != null) {
                AntGrammar antGrammar = this.findOrCreateGrammar(string2);
                String string3 = antlibInfo.getFile();
                URL uRL = null;
                uRL = string3 != null ? this.getClassLoader(uRLPath).getResource(string3) : this.getAntlibFile(string2, uRLPath);
                if (uRL != null) {
                    antGrammar.loadAntLib(uRL, uRLPath);
                }
            }
        }
    }

    private void loadSchema(String string, URLPath uRLPath) {
        block3: {
            ClassLoader classLoader = this.getClassLoader(uRLPath);
            URL uRL = classLoader.getResource(string);
            if (uRL == null) break block3;
            try {
                OracleSchema[] oracleSchemaArray = this.schemaFactory.buildSchemas(uRL);
                int n = 0;
                while (n < oracleSchemaArray.length) {
                    String string2 = oracleSchemaArray[n].getTargetNamespace();
                    AntGrammar antGrammar = this.findOrCreateGrammar(string2);
                    antGrammar.setBaseGrammar((Grammar)oracleSchemaArray[n]);
                    ++n;
                }
            }
            catch (GrammarException grammarException) {
                grammarException.printStackTrace();
            }
        }
    }

    protected ClassLoader getClassLoader(URLPath uRLPath) {
        AntRunConfiguration antRunConfiguration = new AntRunConfiguration();
        Project project = this.context.getProject();
        if (project != null) {
            AntRunConfiguration antRunConfiguration2 = AntRunConfiguration.getInstance((PropertyStorage)project);
            antRunConfiguration2.copyTo((Object)antRunConfiguration);
        }
        antRunConfiguration.setBuildfile(this.context.getIdeDocument().getURL());
        ClassLoader classLoader = antRunConfiguration.getAntClassLoader(project);
        if (uRLPath != null) {
            return new URLClassLoader(uRLPath.getEntries(), classLoader);
        }
        return classLoader;
    }

    protected URL getAntlibFile(String string, URLPath uRLPath) {
        if (string.startsWith("antlib:")) {
            String string2 = string.substring(7).replace('.', '/') + "/antlib.xml";
            ClassLoader classLoader = this.getClassLoader(uRLPath);
            return classLoader.getResource(string2);
        }
        return null;
    }
}

