/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.insight;

import java.awt.Window;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntModel;
import oracle.jdevimpl.ant.insight.AntPropertyDataItem;
import oracle.jdevimpl.ant.insight.AntPropertyInsightProvider;

public class AntPropertyInsightData
implements ListInsightData {
    private ListDataItem[] insightData;
    private ListDataItemListModel listModel;
    private AntPropertyInsightProvider insight;
    private String currentPrefix;
    private Object[] matchingData;

    public AntPropertyInsightData(AntPropertyInsightProvider antPropertyInsightProvider) {
        this.insight = antPropertyInsightProvider;
        XmlModel xmlModel = antPropertyInsightProvider.getXmlContext().getModel();
        if (xmlModel instanceof AntModel) {
            AntContext antContext = ((AntModel)xmlModel).getAntContext();
            int n = 0;
            List list = antContext.getPropertyNames();
            int n2 = list.size();
            this.insightData = new ListDataItem[n2];
            while (n < n2) {
                this.insightData[n] = new AntPropertyDataItem((String)list.get(n));
                ++n;
            }
        }
    }

    public Object[] getData() {
        return this.insightData;
    }

    public Object[] getMatchingData() {
        if (this.matchingData == null) {
            String string = this.getCurrentPrefix();
            this.matchingData = this.buildListModel().getMatchingData(string);
        }
        return this.matchingData;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray != null ? objectArray.length : 0;
    }

    public Object getDefault() {
        String string = this.getCurrentPrefix();
        return this.buildListModel().findClosestDataItem(string);
    }

    public boolean complete(Object object) {
        AntPropertyDataItem antPropertyDataItem = (AntPropertyDataItem)((Object)object);
        String string = antPropertyDataItem.getName();
        this.replacePrefix(string, true);
        return false;
    }

    public void partialComplete() {
        ListDataItem[] listDataItemArray = (ListDataItem[])this.getMatchingData();
        if (listDataItemArray.length > 0) {
            String string = listDataItemArray[0].getName();
            int n = 1;
            while (n < listDataItemArray.length) {
                string = this.getCommonPrefix(string, listDataItemArray[n].getName());
                ++n;
            }
            this.replacePrefix(string, false);
        }
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    public void updateData() {
        this.matchingData = null;
        this.listModel = null;
        this.currentPrefix = null;
    }

    private String getCommonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return string.substring(0, n2);
            }
            ++n2;
        }
        return string.substring(0, n);
    }

    private int getPropertyStart(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = readTextBuffer.getChar(n2);
            if (c == '{') break;
            --n2;
        }
        return n2 + 1;
    }

    private int getPropertyEnd(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n;
        int n3 = readTextBuffer.getLength();
        while (n2 < n3) {
            char c = readTextBuffer.getChar(n2);
            if (c == '}' || c == '\"' || c == '\n' || Character.isWhitespace(c)) break;
            ++n2;
        }
        return n2;
    }

    private ListDataItemListModel buildListModel() {
        if (this.listModel == null) {
            this.listModel = new ListDataItemListModel(this.insightData);
        }
        return this.listModel;
    }

    private String getCurrentPrefix() {
        if (this.currentPrefix == null) {
            TextBuffer textBuffer = this.insight.getTextBuffer();
            int n = this.insight.getCaretPosition();
            int n2 = this.getPropertyStart((ReadTextBuffer)textBuffer, n);
            int n3 = n - n2;
            this.currentPrefix = textBuffer.getString(n2, n3);
        }
        return this.currentPrefix;
    }

    private void replacePrefix(String string, boolean bl) {
        BasicDocument basicDocument = this.insight.getDocument();
        TextBuffer textBuffer = this.insight.getTextBuffer();
        int n = this.insight.getCaretPosition();
        int n2 = this.getPropertyStart((ReadTextBuffer)textBuffer, n);
        int n3 = this.getPropertyEnd((ReadTextBuffer)textBuffer, n);
        BasicEditorPane basicEditorPane = this.insight.getEditorPane();
        EditDescriptor editDescriptor = new EditDescriptor(AntArb.getString(24));
        basicEditorPane.beginEdit(editDescriptor);
        try {
            try {
                basicDocument.remove(n2, n3 - n2);
                if (bl && !string.endsWith("}") && textBuffer.getChar(n2) != '}') {
                    string = string + '}';
                }
                basicDocument.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)badLocationException);
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
    }
}

