/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.AntHandler;
import oracle.jdevimpl.ant.parser.ApplyHandler;
import oracle.jdevimpl.ant.parser.ChecksumHandler;
import oracle.jdevimpl.ant.parser.ConditionHandler;
import oracle.jdevimpl.ant.parser.FormatHandler;
import oracle.jdevimpl.ant.parser.ImportHandler;
import oracle.jdevimpl.ant.parser.InputHandler;
import oracle.jdevimpl.ant.parser.JUnitHandler;
import oracle.jdevimpl.ant.parser.NiceHandler;
import oracle.jdevimpl.ant.parser.P4SubmitHandler;
import oracle.jdevimpl.ant.parser.PathHandler;
import oracle.jdevimpl.ant.parser.ProjectHandler;
import oracle.jdevimpl.ant.parser.PropertyHandler;
import oracle.jdevimpl.ant.parser.SSHExecHandler;
import oracle.jdevimpl.ant.parser.TStampHandler;
import oracle.jdevimpl.ant.parser.TargetHandler;
import oracle.jdevimpl.ant.parser.WaitForHandler;
import oracle.jdevimpl.ant.parser.XmlPropertyHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class AntParser {
    private AntContextImpl context;
    private HashMap handlers;

    void $init$() {
        this.handlers = new HashMap();
    }

    public AntParser(AntContextImpl antContextImpl) {
        this.$init$();
        this.context = antContextImpl;
        this.handlers.put("checksum", new ChecksumHandler());
        this.handlers.put("classpath", new PathHandler());
        this.handlers.put("format", new FormatHandler());
        this.handlers.put("import", new ImportHandler());
        this.handlers.put("input", new InputHandler());
        this.handlers.put("junit", new JUnitHandler());
        this.handlers.put("nice", new NiceHandler());
        this.handlers.put("p4submit", new P4SubmitHandler());
        this.handlers.put("path", new PathHandler());
        this.handlers.put("project", new ProjectHandler());
        this.handlers.put("property", new PropertyHandler());
        this.handlers.put("sshexec", new SSHExecHandler());
        this.handlers.put("target", new TargetHandler());
        this.handlers.put("tstamp", new TStampHandler());
        this.handlers.put("waitfor", new WaitForHandler());
        this.handlers.put("xmlproperty", new XmlPropertyHandler());
        AntHandler antHandler = new ConditionHandler();
        this.handlers.put("available", antHandler);
        this.handlers.put("basename", antHandler);
        this.handlers.put("checksum", antHandler);
        this.handlers.put("condition", antHandler);
        this.handlers.put("dirname", antHandler);
        this.handlers.put("format", antHandler);
        this.handlers.put("jarlib-available", antHandler);
        this.handlers.put("jarlib-resolve", antHandler);
        this.handlers.put("loadfile", antHandler);
        this.handlers.put("p4counter", antHandler);
        this.handlers.put("pathconvert", antHandler);
        this.handlers.put("tempfile", antHandler);
        this.handlers.put("uptodate", antHandler);
        this.handlers.put("whichresource", antHandler);
        antHandler = new ApplyHandler();
        this.handlers.put("apply", antHandler);
        this.handlers.put("execon", antHandler);
        this.handlers.put("exec", antHandler);
        this.handlers.put("java ", antHandler);
    }

    public void parse(Node node) {
        if (node.getNodeType() == 9) {
            Element element = ((Document)node).getDocumentElement();
            if (element != null) {
                this.parse(element);
            }
        } else if (node.getNodeType() == 1) {
            if (this.isAntNamespace(node.getNamespaceURI()) && "project".equals(node.getLocalName())) {
                this.parseProject((Element)node);
            } else {
                this.parseTree(node);
            }
        }
    }

    private void parseProject(Element element) {
        this.handleElement(element);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (this.isAntNamespace(node.getNamespaceURI()) && "target".equals(node.getLocalName())) {
                    arrayList.add(node);
                } else {
                    this.parseTree(node);
                }
            }
            node = node.getNextSibling();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.parseTree((Node)iterator.next());
        }
    }

    private void parseTree(Node node) {
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)node.getOwnerDocument());
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(node, 1, new AntFilter(null), true);
        try {
            Element element = (Element)nodeIterator.nextNode();
            while (element != null) {
                this.handleElement(element);
                element = (Element)nodeIterator.nextNode();
            }
        }
        finally {
            nodeIterator.detach();
        }
    }

    private void handleElement(Element element) {
        String string = element.getLocalName();
        AntHandler antHandler = (AntHandler)this.handlers.get(string);
        if (antHandler != null) {
            antHandler.handleElement(this.context, element);
        }
    }

    private boolean isAntNamespace(String string) {
        return string == null || "antlib:org.apache.tools.ant".equals(string);
    }

    static boolean mav$isAntNamespace(AntParser antParser, String string) {
        return antParser.isAntNamespace(string);
    }

    private class AntFilter
    implements NodeFilter {
        public short acceptNode(Node node) {
            return AntParser.mav$isAntNamespace(AntParser.this, node.getNamespaceURI()) ? (short)1 : 3;
        }

        private AntFilter() {
        }

        AntFilter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

