/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.URLPropertyProvider;

public class PropertyFilePropertyProvider
extends URLPropertyProvider {
    private String prefix;
    private boolean loaded;
    private Properties props;

    void $init$() {
        this.loaded = false;
        this.props = new Properties();
    }

    public PropertyFilePropertyProvider(URL uRL, String string) {
        super(uRL);
        this.$init$();
        if (string != null) {
            if (!(string = string.trim()).endsWith(".")) {
                string = string + ".";
            }
            this.prefix = string;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getProperties(AntContextImpl antContextImpl, Map map, Map map2, Set set) {
        URL uRL = this.getURL();
        if (!set.contains(uRL)) {
            if (!this.loaded) {
                this.loadProperties();
            }
            this.resolveAllProperties(antContextImpl, this.props);
            for (String string : this.props.keySet()) {
                void string2;
                if (this.prefix != null) {
                    String string3 = this.prefix + string;
                }
                if (map.containsKey(string2)) continue;
                String string4 = this.props.getProperty((String)string2);
                map.put(string2, string4);
            }
        }
    }

    private void loadProperties() {
        URL uRL = this.getURL();
        InputStream inputStream = this.getInputStream(uRL);
        if (inputStream != null) {
            try {
                try {
                    this.props.load(inputStream);
                }
                catch (IOException iOException) {}
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                this.loaded = true;
            }
        }
    }

    public void firePropertiesChanged() {
        super.firePropertiesChanged();
        this.loaded = false;
        this.props.clear();
    }

    private void resolveAllProperties(AntContextImpl antContextImpl, Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.resolve(antContextImpl, properties, string, new Stack());
        }
    }

    private void resolve(AntContextImpl antContextImpl, Properties properties, String string, Stack stack) {
        if (!stack.contains(string)) {
            String string2 = properties.getProperty(string);
            stack.push(string);
            StringBuffer stringBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
            Matcher matcher = pattern.matcher(string2);
            int n = 0;
            while (matcher.find()) {
                stringBuffer.append(string2.substring(n, matcher.start(1)));
                String string3 = matcher.group(2);
                String string4 = antContextImpl.getProperty(string3);
                if (string4 == null && properties.containsKey(string3)) {
                    this.resolve(antContextImpl, properties, string3, stack);
                    string4 = properties.getProperty(string3);
                }
                if (string4 != null) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append(matcher.group(1));
                }
                n = matcher.end(1);
            }
            stringBuffer.append(string2.substring(n, string2.length()));
            properties.put(string, stringBuffer.toString());
            stack.pop();
        }
    }

    private InputStream getInputStream(URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                textBuffer.readLock();
                try {
                    InputStream inputStream = TextBufferStreamFactory.getInputStream((TextBuffer)textBuffer);
                    textBuffer.readUnlock();
                    textNode.releaseTextBuffer();
                    return inputStream;
                }
                catch (Throwable throwable) {
                    textBuffer.readUnlock();
                    textNode.releaseTextBuffer();
                    throw throwable;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }
}

