/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.AntHandler;
import oracle.jdevimpl.ant.parser.EnvironmentPropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyFilePropertyProvider;
import org.apache.tools.ant.PathTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PropertyHandler
implements AntHandler {
    public void handleElement(AntContextImpl antContextImpl, Element element) {
        Attr attr = element.getAttributeNodeNS(null, "name");
        if (attr != null) {
            String string = attr.getValue();
            String string2 = null;
            attr = element.getAttributeNodeNS(null, "value");
            if (attr != null) {
                string2 = antContextImpl.resolveProperties(attr.getValue());
            }
            if (string2 == null && (attr = element.getAttributeNodeNS(null, "location")) != null) {
                String string3 = antContextImpl.resolveProperties(attr.getValue());
                File file = antContextImpl.resolveFile(string3);
                if (file == null) {
                    return;
                }
                string2 = file.getPath();
            }
            if (string2 == null && (attr = element.getAttributeNodeNS(null, "refid")) != null) {
                String string4 = antContextImpl.resolveProperties(attr.getValue());
                string2 = antContextImpl.resolveId(string4);
            }
            if (string2 != null) {
                String string5 = null;
                attr = element.getAttributeNodeNS(null, "id");
                if (attr != null) {
                    string5 = attr.getValue();
                    antContextImpl.addId(string5, string2);
                }
                antContextImpl.addProperty(string, string2, string5);
            }
        } else {
            URL uRL = null;
            attr = element.getAttributeNodeNS(null, "url");
            if (attr != null) {
                try {
                    String string = antContextImpl.resolveProperties(attr.getValue(), true);
                    if (string == null) {
                        return;
                    }
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null && (attr = element.getAttributeNodeNS(null, "file")) != null) {
                String string = antContextImpl.resolveProperties(attr.getValue(), true);
                if (string == null) {
                    return;
                }
                File file = antContextImpl.resolveFile(string);
                if (file == null) {
                    return;
                }
                URL uRL2 = uRL = file.isDirectory() ? URLFactory.newDirURL((File)file) : URLFactory.newFileURL((File)file);
            }
            if (uRL == null && (attr = element.getAttributeNodeNS(null, "resource")) != null) {
                String string = antContextImpl.resolveProperties(attr.getValue(), true);
                if (string == null) {
                    return;
                }
                attr = element.getAttributeNodeNS(null, "classpath");
                ClassLoader classLoader = null;
                if (attr != null) {
                    String string6 = antContextImpl.resolveProperties(attr.getValue(), true);
                    if (string6 == null) {
                        return;
                    }
                    URL[] uRLArray = this.resolvePath(antContextImpl, string6);
                    if (uRLArray == null) {
                        return;
                    }
                    classLoader = new URLClassLoader(uRLArray, null);
                } else {
                    JDevXmlContext jDevXmlContext = (JDevXmlContext)antContextImpl.getXmlContext();
                    Project project = jDevXmlContext.getProject();
                    if (project != null) {
                        AntRunConfiguration antRunConfiguration = AntRunConfiguration.getInstance((PropertyStorage)project);
                        classLoader = antRunConfiguration.getAntClassLoader(project);
                    }
                }
                if (classLoader != null) {
                    uRL = classLoader.getResource(string);
                }
            }
            if (uRL != null) {
                String string = null;
                attr = element.getAttributeNodeNS(null, "prefix");
                if (attr != null) {
                    string = antContextImpl.resolveProperties(attr.getValue());
                }
                antContextImpl.addPropertyProvider(new PropertyFilePropertyProvider(uRL, string));
            } else {
                attr = element.getAttributeNodeNS(null, "environment");
                if (attr != null) {
                    String string = antContextImpl.resolveProperties(attr.getValue());
                    antContextImpl.addPropertyProvider(new EnvironmentPropertyProvider(string));
                }
            }
        }
    }

    private URL[] resolvePath(AntContextImpl antContextImpl, String string) {
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (pathTokenizer.hasMoreTokens()) {
            File file = antContextImpl.resolveFile(pathTokenizer.nextToken());
            if (file == null) {
                return null;
            }
            URL uRL = file.isDirectory() ? URLFactory.newDirURL((File)file) : URLFactory.newFileURL((File)file);
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }
}

