/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.model.XmlModel;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.URLPropertyProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFilePropertyProvider
extends URLPropertyProvider {
    private String prefix;
    private boolean keepRoot;
    private boolean semanticAttributes;
    private boolean includeSemanticAttribute;
    private boolean collapseAttributes;
    private HashMap addedAttributes;
    private HashSet semantic;

    void $init$() {
        this.addedAttributes = new HashMap();
        this.semantic = new HashSet();
    }

    public XmlFilePropertyProvider(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(uRL);
        this.$init$();
        this.prefix = string;
        this.keepRoot = bl;
        this.semanticAttributes = bl3;
        this.includeSemanticAttribute = bl4;
        this.collapseAttributes = bl2;
        this.semantic.add("id");
        this.semantic.add("refid");
        this.semantic.add("location");
        this.semantic.add("value");
        this.semantic.add("path");
        this.semantic.add("pathid");
    }

    public void getProperties(AntContextImpl antContextImpl, Map map, Map map2, Set set) {
        block17: {
            URL uRL = this.getURL();
            if (!set.contains(uRL)) {
                this.addedAttributes.clear();
                InputStream inputStream = null;
                try {
                    try {
                        XmlModel xmlModel = antContextImpl.getXmlContext().getRelatedXmlModel(uRL);
                        if (xmlModel == null) break block17;
                        try {
                            xmlModel.acquireReadLock();
                            Document document = xmlModel.getDocument();
                            Element element = document.getDocumentElement();
                            if (this.keepRoot) {
                                this.addNodeRecursively(antContextImpl, map, map2, element, this.prefix, null);
                            } else {
                                NodeList nodeList = element.getChildNodes();
                                int n = nodeList.getLength();
                                int n2 = 0;
                                while (n2 < n) {
                                    this.addNodeRecursively(antContextImpl, map, map2, nodeList.item(n2), this.prefix, null);
                                    ++n2;
                                }
                            }
                        }
                        finally {
                            xmlModel.releaseReadLock();
                        }
                    }
                    catch (Exception exception) {}
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private void addNodeRecursively(AntContextImpl antContextImpl, Map map, Map map2, Node node, String string, Object object) {
        String string2 = string;
        if (node.getNodeType() != 3) {
            if (string.trim().length() > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + node.getNodeName();
        }
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNodeNS(null, "pathid") != null) {
            return;
        }
        Object object2 = this.processNode(antContextImpl, map, map2, node, string2, object);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.addNodeRecursively(antContextImpl, map, map2, nodeList.item(n2), string2, object2);
                ++n2;
            }
        }
    }

    public Object processNode(AntContextImpl antContextImpl, Map map, Map map2, Node node, String string, Object object) {
        String string2 = null;
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("id");
            string2 = this.semanticAttributes && node2 != null ? node2.getNodeValue() : null;
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = namedNodeMap.item(n2);
                if (!this.semanticAttributes || !"id".equals(node3.getNodeName())) {
                    String string3 = this.getAttributeName(node3);
                    String string4 = this.getAttributeValue(antContextImpl, node3);
                    if (string4 != null) {
                        this.addProperty(map, map2, string + string3, string4, string2);
                    }
                }
                ++n2;
            }
        }
        String string5 = null;
        if (node.getNodeType() == 3) {
            string5 = this.getAttributeValue(antContextImpl, node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            string5 = node.getFirstChild().getNodeValue();
        }
        if (string5 != null && string5.trim().length() > 0) {
            if (this.semanticAttributes && string2 == null && object instanceof String) {
                string2 = (String)object;
            }
            this.addProperty(map, map2, string, string5, string2);
        }
        return string2;
    }

    private String getAttributeName(Node node) {
        String string = node.getNodeName();
        if (this.semanticAttributes) {
            if ("refid".equals(string)) {
                return "";
            }
            if (this.includeSemanticAttribute || !this.semantic.contains(string)) {
                return "." + string;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + string;
        }
        return "(" + string + ")";
    }

    private String getAttributeValue(AntContextImpl antContextImpl, Node node) {
        String string = node.getNodeValue();
        if (this.semanticAttributes) {
            string = antContextImpl.resolveProperties(string);
            String string2 = node.getNodeName();
            if ("location".equals(string2)) {
                File file = antContextImpl.resolveFile(string);
                if (file != null) {
                    string = file.getPath();
                }
            } else if ("refid".equals(string2)) {
                string = antContextImpl.resolveId(string);
            }
        }
        return string;
    }

    private void addProperty(Map map, Map map2, String string, String string2, String string3) {
        if (this.addedAttributes.containsKey(string)) {
            string2 = this.addedAttributes.get(string) + "," + string2;
        }
        if (!map.containsKey(string)) {
            map.put(string, string2);
        }
        if (this.semanticAttributes && string3 != null) {
            map2.put(string3, string2);
        }
        this.addedAttributes.put(string, string2);
    }
}

