/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.PropertyInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public class AntRegistry
extends HashStructureAdapter {
    public static final String DATA_KEY = AntRegistry.class.getName();
    public static final String ANTLIB_LIST = "antlibList";
    public static final String TASK_LIST = "taskList";
    public static final String TYPE_LIST = "taskList";
    public static final String PROPERTY_LIST = "propertyList";
    private static AntRegistry extensionRegistry;

    public AntRegistry() {
        this(HashStructure.newInstance());
    }

    private AntRegistry(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static AntRegistry getInstance(PropertyStorage propertyStorage) {
        return new AntRegistry(propertyStorage.getProperties().getOrCreateHashStructure(DATA_KEY));
    }

    public static AntRegistry getExtensionAntRegistry() {
        if (extensionRegistry == null) {
            extensionRegistry = new AntRegistry();
        }
        return extensionRegistry;
    }

    public void addAntlib(AntlibInfo antlibInfo) {
        HashStructure hashStructure = HashStructure.newInstance();
        AntlibInfo antlibInfo2 = new AntlibInfo(hashStructure);
        antlibInfo.copyTo((Object)antlibInfo2);
        ListStructure listStructure = this._hash.getOrCreateListStructure(ANTLIB_LIST);
        listStructure.add(hashStructure);
    }

    public void addTask(TaskInfo taskInfo) {
        HashStructure hashStructure = HashStructure.newInstance();
        TaskInfo taskInfo2 = new TaskInfo(hashStructure);
        taskInfo.copyTo((Object)taskInfo2);
        ListStructure listStructure = this._hash.getOrCreateListStructure("taskList");
        listStructure.add(hashStructure);
    }

    public void addType(TypeInfo typeInfo) {
        HashStructure hashStructure = HashStructure.newInstance();
        TypeInfo typeInfo2 = new TypeInfo(hashStructure);
        typeInfo.copyTo((Object)typeInfo2);
        ListStructure listStructure = this._hash.getOrCreateListStructure("taskList");
        listStructure.add(hashStructure);
    }

    public void addProperty(PropertyInfo propertyInfo) {
        HashStructure hashStructure = HashStructure.newInstance();
        PropertyInfo propertyInfo2 = new PropertyInfo(hashStructure);
        propertyInfo.copyTo((Object)propertyInfo2);
        ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_LIST);
        listStructure.add(hashStructure);
    }

    public List getAntlibList() {
        ArrayList<AntlibInfo> arrayList = new ArrayList<AntlibInfo>();
        ListStructure listStructure = this._hash.getListStructure(ANTLIB_LIST);
        if (listStructure != null) {
            for (HashStructure hashStructure : listStructure) {
                arrayList.add(new AntlibInfo(hashStructure));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setAntlibList(List list) {
        if (list == null) {
            this._hash.remove(ANTLIB_LIST);
        } else {
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AntlibInfo antlibInfo = (AntlibInfo)((Object)iterator.next());
                HashStructure hashStructure = (HashStructure)iterator.next();
                AntlibInfo antlibInfo2 = new AntlibInfo(hashStructure);
                antlibInfo.copyTo((Object)antlibInfo2);
                arrayList.add(hashStructure);
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure(ANTLIB_LIST);
            listStructure.mirror(list);
        }
    }

    public List getTaskList() {
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>();
        ListStructure listStructure = this._hash.getListStructure("taskList");
        if (listStructure != null) {
            for (HashStructure hashStructure : listStructure) {
                arrayList.add(new TaskInfo(hashStructure));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setTaskList(List list) {
        if (list == null) {
            this._hash.remove("taskList");
        } else {
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TaskInfo taskInfo = (TaskInfo)((Object)iterator.next());
                HashStructure hashStructure = (HashStructure)iterator.next();
                TaskInfo taskInfo2 = new TaskInfo(hashStructure);
                taskInfo.copyTo((Object)taskInfo2);
                arrayList.add(hashStructure);
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure("taskList");
            listStructure.mirror(list);
        }
    }

    public List getTypeList() {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        ListStructure listStructure = this._hash.getListStructure("taskList");
        if (listStructure != null) {
            for (HashStructure hashStructure : listStructure) {
                arrayList.add(new TypeInfo(hashStructure));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setTypeList(List list) {
        if (list == null) {
            this._hash.remove("taskList");
        } else {
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TypeInfo typeInfo = (TypeInfo)((Object)iterator.next());
                HashStructure hashStructure = (HashStructure)iterator.next();
                TypeInfo typeInfo2 = new TypeInfo(hashStructure);
                typeInfo.copyTo((Object)typeInfo2);
                arrayList.add(hashStructure);
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure("taskList");
            listStructure.mirror(list);
        }
    }

    public List getPropertyList() {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        ListStructure listStructure = this._hash.getListStructure(PROPERTY_LIST);
        if (listStructure != null) {
            for (HashStructure hashStructure : listStructure) {
                arrayList.add(new PropertyInfo(hashStructure));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setPropertyList(List list) {
        if (list == null) {
            this._hash.remove(PROPERTY_LIST);
        } else {
            ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PropertyInfo propertyInfo = (PropertyInfo)((Object)iterator.next());
                HashStructure hashStructure = (HashStructure)iterator.next();
                PropertyInfo propertyInfo2 = new PropertyInfo(hashStructure);
                propertyInfo.copyTo((Object)propertyInfo2);
                arrayList.add(hashStructure);
            }
            ListStructure listStructure = this._hash.getOrCreateListStructure(PROPERTY_LIST);
            listStructure.mirror(list);
        }
    }

    public URLPath getClassPath() {
        URLPath uRLPath = new URLPath();
        for (AntlibInfo antlibInfo : this.getAntlibList()) {
            uRLPath.add(antlibInfo.getClassPath());
        }
        for (TaskInfo taskInfo : this.getTaskList()) {
            uRLPath.add(taskInfo.getClassPath());
        }
        for (TypeInfo typeInfo : this.getTypeList()) {
            uRLPath.add(typeInfo.getClassPath());
        }
        return uRLPath;
    }
}

