/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntOptions;

public class AntLogPage
extends MessagePage {
    private static List availablePages;
    private Context context;
    private String tooltip;
    private boolean buildFinished;
    private final Pattern linePattern;
    private Pattern errorPattern;
    private Pattern importPattern;
    private static final String ANT_LOG_PAGE = "AntLogPage";
    protected static SimpleAttributeSet errAttributes;
    protected static SimpleAttributeSet warnAttributes;
    protected static SimpleAttributeSet infoAttributes;
    protected static SimpleAttributeSet verboseAttributes;
    protected static SimpleAttributeSet debugAttributes;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = AntLogPage.class.desiredAssertionStatus() ^ true;
        availablePages = new ArrayList();
        errAttributes = new SimpleAttributeSet();
        warnAttributes = new SimpleAttributeSet();
        infoAttributes = new SimpleAttributeSet();
        verboseAttributes = new SimpleAttributeSet();
        debugAttributes = new SimpleAttributeSet();
        AntLogPage.getAntOptions().addChangeListener(new 4());
        AntLogPage.updateAttributeSets();
    }

    void $init$() {
        this.linePattern = Pattern.compile("\\s*(?:\\[(.*)\\])?\\s*(?:file:)?(.+?):(\\d+):(?:(\\d+):)?(?:\\d+:\\d+:)?(.+)");
        this.errorPattern = Pattern.compile("\\s*(?:(?:(warning|error)\\s*:?\\s*(?:#\\s*(\\d+)\\s*:)?)|(?:note:))(.+)", 66);
        this.importPattern = Pattern.compile(".*?(import.*;.*)");
    }

    public AntLogPage(Context context) {
        super(new ViewId(ANT_LOG_PAGE, AntArb.getString(70)), AntArb.getIcon(0), false, true);
        this.$init$();
        this.setContext(context);
        this.tooltip = AntArb.getString(70);
        LogManager.getLogManager().addPage((LogPage)this);
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (environOptions.isSaveLogToFile()) {
            URL uRL = environOptions.getLogFilePreffix();
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)this.tooltip.replace(' ', '_'));
            this.setLogFileName(URLFileSystem.getPlatformPathName((URL)uRL2));
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntLogPage getAntLogPage(Context context) {
        AntLogPage antLogPage = null;
        List list = availablePages;
        synchronized (list) {
            if (availablePages.size() > 0) {
                antLogPage = (AntLogPage)((Object)availablePages.remove(0));
                if (!$assertionsDisabled && !antLogPage.isFinished()) {
                    throw new AssertionError();
                }
                antLogPage.setContext(context);
            }
        }
        if (antLogPage == null) {
            antLogPage = new AntLogPage(context);
        }
        return antLogPage;
    }

    public void close() {
        super.close();
        availablePages.remove((Object)this);
    }

    public void log(Object object) {
        StyledMessage styledMessage;
        String string;
        if (object instanceof StyledMessage && (string = (styledMessage = (StyledMessage)object).getText()) != null) {
            AttributeSet attributeSet = styledMessage.getAttributes();
            if (attributeSet == RunProcess.getSystemErrAttributeSet()) {
                object = new StyledMessage((AttributeSet)errAttributes, string);
            } else if (attributeSet == RunProcess.getSystemOutAttributeSet()) {
                object = new StyledMessage((AttributeSet)infoAttributes, string);
            }
        }
        super.log(object);
    }

    public void log(int n, String string) {
        this.log(n, string, null, null, -1);
    }

    public void log(int n, String string, String string2, String string3, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        if (string2 != null) {
            int n4 = 12 - string2.length() - 3;
            n3 += n4 > 0 ? n4 + 1 : 1;
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(" ");
                ++n5;
            }
            stringBuffer.append("[");
            stringBuffer.append(string2);
            stringBuffer.append("] ");
        }
        stringBuffer.append(string);
        stringBuffer.append("\n");
        String string4 = stringBuffer.toString();
        StyledMessage styledMessage = new StyledMessage(AntLogPage.getAttributeSet(n), string4);
        super.logMsg((Object)styledMessage);
        if (string2 != null && string3.length() > 0) {
            this.addHref(string3, n2, n3 += styledMessage.getStartOffset(), n3 + string2.length());
        }
        this.addFileLinks(string4, styledMessage.getStartOffset(), string2, n);
        SwingUtilities.invokeLater(new 3());
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public String getToolTip() {
        if (this.buildFinished) {
            return RunMgrArb.format((int)9, (Object)this.tooltip);
        }
        return this.tooltip;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ant_log_html");
    }

    public void buildStarted() {
        this.buildFinished = false;
        this.updateToolTipText();
        SwingUtilities.invokeLater(new 2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        this.buildFinished = true;
        List list = availablePages;
        synchronized (list) {
            availablePages.add(this);
        }
        this.updateToolTipText();
    }

    public void buildCancelled() {
        String string = AntArb.getString(111);
        this.log(0, string);
    }

    public boolean isFinished() {
        return this.buildFinished;
    }

    private void addHref(String string, int n, int n2, int n3) {
        URL uRL = null;
        if (string.startsWith("jar:") || string.startsWith("file:")) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
        } else {
            uRL = URLFactory.newFileURL((String)string);
        }
        if (uRL != null) {
            URL uRL2 = uRL;
            1 var8_8 = new 1(this, string, uRL, uRL2, n);
            var8_8.setStartOffset(n2);
            var8_8.setEndOffset(n3);
            this.addHref(var8_8);
        }
    }

    private void addFileLinks(String string, int n, String string2, int n2) {
        Matcher matcher = this.linePattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(2).trim();
            int n3 = Integer.valueOf(matcher.group(3));
            int n4 = n + matcher.start(2);
            int n5 = n + matcher.end(2);
            this.addHref(string3, n3, n4, n5);
        }
    }

    private static AttributeSet getAttributeSet(int n) {
        SimpleAttributeSet simpleAttributeSet;
        switch (n) {
            case 0: {
                simpleAttributeSet = errAttributes;
                break;
            }
            case 1: {
                simpleAttributeSet = warnAttributes;
                break;
            }
            case 2: {
                simpleAttributeSet = infoAttributes;
                break;
            }
            case 3: {
                simpleAttributeSet = verboseAttributes;
                break;
            }
            case 4: {
                simpleAttributeSet = debugAttributes;
                break;
            }
            default: {
                simpleAttributeSet = infoAttributes;
            }
        }
        return simpleAttributeSet;
    }

    private static AntOptions getAntOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (AntOptions)clientSetting.getData("AntOptions");
    }

    private static void updateAttributeSets() {
        AntOptions antOptions = AntLogPage.getAntOptions();
        AntLogPage.checkColor(errAttributes, antOptions.getErrColor());
        AntLogPage.checkColor(warnAttributes, antOptions.getWarnColor());
        AntLogPage.checkColor(infoAttributes, antOptions.getInfoColor());
        AntLogPage.checkColor(verboseAttributes, antOptions.getVerboseColor());
        AntLogPage.checkColor(debugAttributes, antOptions.getDebugColor());
    }

    private static void checkColor(SimpleAttributeSet simpleAttributeSet, int n) {
        if (StyleConstants.getForeground(simpleAttributeSet).getRGB() != n) {
            StyleConstants.setForeground(simpleAttributeSet, new Color(n));
        }
    }

    static void maS$updateAttributeSets() {
        AntLogPage.updateAttributeSets();
    }

    static void mav$requestShow(AntLogPage antLogPage) {
        antLogPage.requestShow();
    }

    static Context ra$context(AntLogPage antLogPage) {
        return antLogPage.context;
    }

    public static final class 4
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            AntLogPage.maS$updateAttributeSets();
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            AntLogPage.mav$requestShow(AntLogPage.this);
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
        }
    }

    public final class 1
    extends Href {
        private final /* synthetic */ URL v$localURL;
        private final /* synthetic */ int v$line;
        final /* synthetic */ AntLogPage this$0;

        public void go() {
            Source.showSourceFile(AntLogPage.ra$context(this.this$0).getWorkspace(), AntLogPage.ra$context(this.this$0).getProject(), this.v$localURL, this.v$line, true);
        }

        public 1(AntLogPage antLogPage, String string, URL uRL, URL uRL2, int n) {
            this.v$line = n;
            this.v$localURL = uRL2;
            this.this$0 = antLogPage;
            super(string, uRL);
        }
    }
}

