/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.ant.AntListener;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.ant.AntManagerImpl;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.runner.AntInputHandler;
import oracle.jdevimpl.ant.runner.AntLogPage;
import oracle.jdevimpl.ant.runner.AntProcess;
import oracle.jdevimpl.ant.runner.JAXPProperties;
import oracle.jdevimpl.ant.runner.OutOfProcessInputHandler;

public class AntStarter
extends JStarter {
    private AntNode node;
    private Project project;
    private AntProcess antProcess;
    private AntRunConfiguration antConfiguration;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private Object portLock;
    private int port;
    private static final String ANT_MAIN_CLASS = "org.apache.tools.ant.Main";
    private static final String LOGGER_CLASS = "oracle.jdevimpl.ant.runner.OutOfProcessAntLogger";
    private static final String PROPERTY_FILE_INPUT_HANDLER_CLASS = "org.apache.tools.ant.input.PropertyFileInputHandler";
    private static final int SERVER_COMMAND_MESSAGE = 0;
    private static final int SERVER_COMMAND_TASK_MESSAGE = 1;
    private static final int SERVER_COMMAND_INPUT_REQUEST = 2;
    private static final int SOCKET_TIMEOUT = 30000;

    void $init$() {
        this.portLock = new Object();
    }

    public AntStarter(AntProcess antProcess, AntNode antNode) {
        super((JRunProcess)((Object)antProcess), null);
        this.$init$();
        this.node = antNode;
        this.antProcess = antProcess;
        this.project = ((JRunProcess)((Object)antProcess)).getJProject();
        this.antConfiguration = antProcess.getAntRunConfiguration();
    }

    public boolean start() {
        this.saveAll();
        this.startServer(this.runProcess.getContext());
        ((AntLogPage)this.runProcess.getLogPage()).buildStarted();
        AntListener antListener2 = this.antProcess.getAntListener();
        if (antListener2 != null) {
            antListener2.buildStarted(this.antConfiguration);
        }
        AntManagerImpl antManagerImpl = (AntManagerImpl)AntManager.getAntManager();
        for (AntListener antListener2 : antManagerImpl.getAntListeners()) {
            antListener2.buildStarted(this.antConfiguration);
        }
        return super.start();
    }

    public void finished() {
        super.finished();
        ((AntLogPage)this.runProcess.getLogPage()).buildFinished();
        AntListener antListener2 = this.antProcess.getAntListener();
        if (antListener2 != null) {
            antListener2.buildFinished(this.antConfiguration);
        }
        AntManagerImpl antManagerImpl = (AntManagerImpl)AntManager.getAntManager();
        for (AntListener antListener2 : antManagerImpl.getAntListeners()) {
            antListener2.buildFinished(this.antConfiguration);
        }
        this.shutdownServer();
    }

    public void terminate() {
        super.terminate();
        this.shutdownServer();
    }

    public File getStartDirectory() {
        URL uRL = this.antConfiguration.getWorkingDirectory();
        if (uRL != null) {
            return new File(URLFileSystem.getPath((URL)uRL));
        }
        URL uRL2 = this.antConfiguration.getBuildfile();
        if (uRL2 != null) {
            URL uRL3 = URLFileSystem.getParent((URL)uRL2);
            return new File(URLFileSystem.getPath((URL)uRL3));
        }
        return null;
    }

    public String[] getStartEnvironmentParams() {
        List list = this.antConfiguration.getEnvironmentNames();
        if (!list.isEmpty()) {
            Map<String, String> map = System.getenv();
            List list2 = this.antConfiguration.getEnvironmentValues();
            MacroRegistry macroRegistry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)list.get(n2);
                String string2 = (String)list2.get(n2);
                String string3 = macroRegistry.expand(string2, this.runProcess.getContext());
                map.put(string, string3);
                ++n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : map.keySet()) {
                String string4 = map.get(string);
                arrayList.add(string + "=" + string4);
            }
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public String[] getStartCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.addJavaExecutableName(arrayList)) {
            return null;
        }
        this.addClassPathOption(arrayList);
        this.addBootClassPathOption(arrayList);
        this.addJavaOptions(arrayList);
        this.addFirstAntOptions(arrayList);
        arrayList.add(ANT_MAIN_CLASS);
        this.addAntOptions(arrayList);
        this.addLastAntOptions(arrayList);
        arrayList.addAll(this.antConfiguration.getTargetList());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected boolean addJavaExecutableName(List list) {
        JDK jDK = this.antConfiguration.getJDK(this.runProcess.getProject());
        String string = jDK.getSDKBinJavaExecutableNoConsole();
        if (string == null) {
            string = jDK.getJavaExecutableNoConsole();
        }
        if (string != null) {
            list.add(string);
            JAXPProperties.getCommandLineArgs(jDK.getJavaVersion());
            return true;
        }
        return false;
    }

    protected void addJavaOptions(List list) {
        String string;
        list.add("-Djdev.ant.port=" + this.port);
        URL uRL = this.antConfiguration.getAntHome();
        if (uRL == null) {
            AntVersion antVersion = AntVersion.getDefaultAntVersion();
            uRL = antVersion.getAntHome();
        }
        list.add("-Dant.home=" + URLFileSystem.getPlatformPathName((URL)uRL));
        if (this.antConfiguration.getUseInputFile()) {
            URL uRL2 = this.antConfiguration.getInputFile();
            String string2 = URLFileSystem.getPlatformPathName((URL)uRL2);
            list.add("-Dant.input.properties=" + string2);
        }
        if ((string = this.antConfiguration.getJavaArgs()) != null) {
            String[] stringArray = IdeUtil.convertStringToStringArray((String)string, (boolean)true, (boolean)true);
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
    }

    protected String getClassPath() {
        Project project = this.runProcess.getContext().getProject();
        URLPath uRLPath = this.antConfiguration.getAntClassPath(project);
        return uRLPath.toString();
    }

    private void addFirstAntOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("Ant", null, "FirstAntCommandOptions");
        if (stringArray != null) {
            AntStarter.addArrayToList(list, stringArray);
        }
    }

    private void addLastAntOptions(List list) {
        String[] stringArray = (String[])this.jrunProcess.getValue("Ant", null, "LastAntCommandOptions");
        if (stringArray != null) {
            AntStarter.addArrayToList(list, stringArray);
        }
    }

    private void addAntOptions(List list) {
        AntVersion antVersion = null;
        URL uRL = this.antConfiguration.getAntHome();
        if (uRL != null) {
            antVersion = AntVersion.createAntVersion(uRL);
        }
        if (antVersion == null) {
            antVersion = AntVersion.getDefaultAntVersion();
        }
        VersionNumber versionNumber = antVersion.getVersion();
        boolean bl = versionNumber.isAfter(new VersionNumber("1.5"));
        boolean bl2 = versionNumber.isAfter(new VersionNumber("1.6"));
        int n = this.antConfiguration.getOutputLevel();
        switch (n) {
            case 0: 
            case 1: {
                list.add("-quiet");
                break;
            }
            case 3: {
                list.add("-verbose");
                break;
            }
            case 4: {
                list.add("-debug");
                break;
            }
        }
        if (bl2 && this.antConfiguration.getKeepGoing()) {
            list.add("-k");
        }
        list.add("-logger");
        list.add(LOGGER_CLASS);
        if (bl) {
            list.add("-inputhandler");
            if (this.antConfiguration.getUseInputFile()) {
                list.add(PROPERTY_FILE_INPUT_HANDLER_CLASS);
            } else {
                list.add(OutOfProcessInputHandler.class.getName());
            }
        }
        list.add("-f");
        list.add(URLFileSystem.getPlatformPathName((URL)this.antConfiguration.getBuildfile()));
        MacroRegistry macroRegistry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        Iterator iterator = this.antConfiguration.getPropertyNames().iterator();
        Iterator iterator2 = this.antConfiguration.getPropertyValues().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            String string3 = macroRegistry.expand(string2, this.runProcess.getContext());
            list.add("-D" + string + "=" + string3);
        }
        Iterator iterator3 = this.antConfiguration.getPropertyFiles().iterator();
        while (iterator3.hasNext()) {
            list.add("-propertyfile");
            list.add((String)iterator3.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(Context context) {
        Object object = this.portLock;
        synchronized (object) {
            this.serverThread = new ServerThread(context);
            this.serverThread.start();
            try {
                this.portLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void shutdownServer() {
        this.serverThread = null;
    }

    private void saveAll() {
        if (Ide.getEnvironOptions().getSaveBeforeCompile()) {
            IdeUtil.runNow((Runnable)new 1());
        }
    }

    static void wa$serverSocket(AntStarter antStarter, ServerSocket serverSocket) {
        antStarter.serverSocket = serverSocket;
    }

    static ServerSocket ra$serverSocket(AntStarter antStarter) {
        return antStarter.serverSocket;
    }

    static Object ra$portLock(AntStarter antStarter) {
        return antStarter.portLock;
    }

    static void wa$port(AntStarter antStarter, int n) {
        antStarter.port = n;
    }

    static RunProcess ra$runProcess(AntStarter antStarter) {
        return antStarter.runProcess;
    }

    static Thread ra$serverThread(AntStarter antStarter) {
        return antStarter.serverThread;
    }

    private class ServerThread
    extends Thread {
        private Context context;
        private AntLogPage logPage;
        private AntInputHandler inputHandler;

        void $init$() {
            this.inputHandler = new AntInputHandler();
        }

        public ServerThread(Context context) {
            super("Ant Server");
            this.$init$();
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    AntStarter.wa$serverSocket(AntStarter.this, new ServerSocket(0, 0, InetAddress.getByName(null)));
                    AntStarter.ra$serverSocket(AntStarter.this).setSoTimeout(30000);
                    Object object = AntStarter.ra$portLock(AntStarter.this);
                    synchronized (object) {
                        AntStarter.wa$port(AntStarter.this, AntStarter.ra$serverSocket(AntStarter.this).getLocalPort());
                        AntStarter.ra$portLock(AntStarter.this).notify();
                    }
                    Socket socket = AntStarter.ra$serverSocket(AntStarter.this).accept();
                    this.logPage = (AntLogPage)AntStarter.ra$runProcess(AntStarter.this).getLogPage();
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    while (AntStarter.ra$serverThread(AntStarter.this) == this) {
                        int n = dataInputStream.readInt();
                        switch (n) {
                            case 0: {
                                this.handleMessage(dataInputStream);
                                break;
                            }
                            case 1: {
                                this.handleTaskMessage(dataInputStream);
                                break;
                            }
                            case 2: {
                                this.handleInputRequest(dataInputStream, dataOutputStream);
                            }
                        }
                    }
                }
                catch (IOException iOException) {}
            }
            finally {
                try {
                    if (AntStarter.ra$serverSocket(AntStarter.this) != null) {
                        AntStarter.ra$serverSocket(AntStarter.this).close();
                    }
                }
                catch (IOException iOException) {}
                AntStarter.wa$serverSocket(AntStarter.this, null);
            }
        }

        private void handleMessage(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            if (this.logPage != null) {
                this.logPage.log(n, string, null, null, 0);
            }
        }

        private void handleTaskMessage(DataInputStream dataInputStream) throws IOException {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            String string3 = dataInputStream.readUTF();
            if (this.logPage != null) {
                this.logPage.log(n2, string3, string, string2, n);
            }
        }

        private void handleInputRequest(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
            String string;
            String string2 = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            String[] stringArray = null;
            if (n > 0) {
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = dataInputStream.readUTF();
                    ++n2;
                }
            }
            dataOutputStream.writeBoolean((string = this.inputHandler.getInput(string2, stringArray)) != null);
            if (string != null) {
                dataOutputStream.writeUTF(string);
            }
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            try {
                SaveAllCommand.saveAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

