/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.JDK;
import oracle.ide.util.VersionNumber;

public class JAXPProperties {
    private static final String[] properties = new String[]{"javax.xml.transform.TransformerFactory", "javax.xml.parsers.SAXParserFactory", "javax.xml.parsers.DocumentBuilderFactory"};
    private static final String[] jdk14values = new String[]{"org.apache.xalan.processor.TransformerFactoryImpl", "org.apache.crimson.jaxp.SAXParserFactoryImpl", "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl"};
    private static final String[] jdk15values = new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"};
    private static final String[] oldValues = new String[]{System.getProperty(properties[0]), System.getProperty(properties[1]), System.getProperty(properties[2])};

    public static final void override() {
        String[] stringArray = JDK.IS_JDK15 ? jdk15values : jdk14values;
        int n = 0;
        while (n < properties.length) {
            System.setProperty(properties[n], stringArray[n]);
            ++n;
        }
    }

    public static final void restore() {
        int n = 0;
        while (n < properties.length) {
            if (oldValues[n] == null) {
                System.clearProperty(properties[n]);
            } else {
                System.setProperty(properties[n], oldValues[n]);
            }
            ++n;
        }
    }

    public static final List getCommandLineArgs(VersionNumber versionNumber) {
        ArrayList<String> arrayList = new ArrayList<String>(properties.length);
        VersionNumber versionNumber2 = new VersionNumber("1.5");
        String[] stringArray = versionNumber.isAfter(versionNumber2, true) ? jdk15values : jdk14values;
        int n = 0;
        while (n < properties.length) {
            arrayList.add("-D" + properties[n] + "=" + stringArray[n]);
            ++n;
        }
        return arrayList;
    }
}

