/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import oracle.jdevimpl.ant.runner.AntLocation;
import org.apache.tools.ant.Task;

public class OutOfProcessIDEHook {
    private static final int SERVER_COMMAND_MESSAGE = 0;
    private static final int SERVER_COMMAND_TASK_MESSAGE = 1;
    private static final int SERVER_COMMAND_INPUT_REQUEST = 2;
    public static final String ANT_PORT_PROPERTY = "jdev.ant.port";
    private static Socket socket;
    private static DataInputStream input;
    private static DataOutputStream output;
    private static boolean connected;

    private OutOfProcessIDEHook() {
    }

    public static void connect() {
        int n = Integer.parseInt(System.getProperty(ANT_PORT_PROPERTY));
        try {
            socket = new Socket(InetAddress.getByName(null), n);
            output = new DataOutputStream(socket.getOutputStream());
            input = new DataInputStream(socket.getInputStream());
            connected = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void disconnect() {
        try {
            try {
                if (input != null) {
                    input.close();
                    input = null;
                }
                if (output != null) {
                    output.close();
                    output = null;
                }
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            connected = false;
        }
    }

    public static void sendMessage(String string, int n) {
        OutOfProcessIDEHook.sendMessage(null, string, n);
    }

    public static synchronized void sendMessage(Task task, String string, int n) {
        if (connected) {
            try {
                if (task != null) {
                    output.writeInt(1);
                    output.writeUTF(task.getTaskName());
                    AntLocation antLocation = new AntLocation(task.getLocation());
                    String string2 = antLocation.getFileName();
                    output.writeUTF(string2 == null ? "" : string2);
                    output.writeInt(antLocation.getLineNumber());
                } else {
                    output.writeInt(0);
                }
                output.writeInt(n);
                output.writeUTF(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static synchronized String sendInputRequest(String string, String[] stringArray) {
        try {
            output.writeInt(2);
            output.writeUTF(string);
            if (stringArray == null) {
                output.writeInt(0);
            } else {
                output.writeInt(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    output.writeUTF(stringArray[n]);
                    ++n;
                }
            }
            boolean bl = input.readBoolean();
            String string2 = bl ? input.readUTF() : null;
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

